/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmeetings.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartMeetingTranscriptionRequest extends ChimeSdkMeetingsRequest implements
        ToCopyableBuilder<StartMeetingTranscriptionRequest.Builder, StartMeetingTranscriptionRequest> {
    private static final SdkField<String> MEETING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MeetingId").getter(getter(StartMeetingTranscriptionRequest::meetingId))
            .setter(setter(Builder::meetingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("MeetingId").build()).build();

    private static final SdkField<TranscriptionConfiguration> TRANSCRIPTION_CONFIGURATION_FIELD = SdkField
            .<TranscriptionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("TranscriptionConfiguration")
            .getter(getter(StartMeetingTranscriptionRequest::transcriptionConfiguration))
            .setter(setter(Builder::transcriptionConfiguration))
            .constructor(TranscriptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptionConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEETING_ID_FIELD,
            TRANSCRIPTION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String meetingId;

    private final TranscriptionConfiguration transcriptionConfiguration;

    private StartMeetingTranscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.meetingId = builder.meetingId;
        this.transcriptionConfiguration = builder.transcriptionConfiguration;
    }

    /**
     * <p>
     * The unique ID of the meeting being transcribed.
     * </p>
     * 
     * @return The unique ID of the meeting being transcribed.
     */
    public final String meetingId() {
        return meetingId;
    }

    /**
     * <p>
     * The configuration for the current transcription operation. Must contain <code>EngineTranscribeSettings</code> or
     * <code>EngineTranscribeMedicalSettings</code>.
     * </p>
     * 
     * @return The configuration for the current transcription operation. Must contain
     *         <code>EngineTranscribeSettings</code> or <code>EngineTranscribeMedicalSettings</code>.
     */
    public final TranscriptionConfiguration transcriptionConfiguration() {
        return transcriptionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(meetingId());
        hashCode = 31 * hashCode + Objects.hashCode(transcriptionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMeetingTranscriptionRequest)) {
            return false;
        }
        StartMeetingTranscriptionRequest other = (StartMeetingTranscriptionRequest) obj;
        return Objects.equals(meetingId(), other.meetingId())
                && Objects.equals(transcriptionConfiguration(), other.transcriptionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartMeetingTranscriptionRequest").add("MeetingId", meetingId())
                .add("TranscriptionConfiguration", transcriptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MeetingId":
            return Optional.ofNullable(clazz.cast(meetingId()));
        case "TranscriptionConfiguration":
            return Optional.ofNullable(clazz.cast(transcriptionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MeetingId", MEETING_ID_FIELD);
        map.put("TranscriptionConfiguration", TRANSCRIPTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartMeetingTranscriptionRequest, T> g) {
        return obj -> g.apply((StartMeetingTranscriptionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMeetingsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartMeetingTranscriptionRequest> {
        /**
         * <p>
         * The unique ID of the meeting being transcribed.
         * </p>
         * 
         * @param meetingId
         *        The unique ID of the meeting being transcribed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meetingId(String meetingId);

        /**
         * <p>
         * The configuration for the current transcription operation. Must contain <code>EngineTranscribeSettings</code>
         * or <code>EngineTranscribeMedicalSettings</code>.
         * </p>
         * 
         * @param transcriptionConfiguration
         *        The configuration for the current transcription operation. Must contain
         *        <code>EngineTranscribeSettings</code> or <code>EngineTranscribeMedicalSettings</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcriptionConfiguration(TranscriptionConfiguration transcriptionConfiguration);

        /**
         * <p>
         * The configuration for the current transcription operation. Must contain <code>EngineTranscribeSettings</code>
         * or <code>EngineTranscribeMedicalSettings</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TranscriptionConfiguration.Builder}
         * avoiding the need to create one manually via {@link TranscriptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TranscriptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #transcriptionConfiguration(TranscriptionConfiguration)}.
         * 
         * @param transcriptionConfiguration
         *        a consumer that will call methods on {@link TranscriptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transcriptionConfiguration(TranscriptionConfiguration)
         */
        default Builder transcriptionConfiguration(Consumer<TranscriptionConfiguration.Builder> transcriptionConfiguration) {
            return transcriptionConfiguration(TranscriptionConfiguration.builder().applyMutation(transcriptionConfiguration)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkMeetingsRequest.BuilderImpl implements Builder {
        private String meetingId;

        private TranscriptionConfiguration transcriptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMeetingTranscriptionRequest model) {
            super(model);
            meetingId(model.meetingId);
            transcriptionConfiguration(model.transcriptionConfiguration);
        }

        public final String getMeetingId() {
            return meetingId;
        }

        public final void setMeetingId(String meetingId) {
            this.meetingId = meetingId;
        }

        @Override
        public final Builder meetingId(String meetingId) {
            this.meetingId = meetingId;
            return this;
        }

        public final TranscriptionConfiguration.Builder getTranscriptionConfiguration() {
            return transcriptionConfiguration != null ? transcriptionConfiguration.toBuilder() : null;
        }

        public final void setTranscriptionConfiguration(TranscriptionConfiguration.BuilderImpl transcriptionConfiguration) {
            this.transcriptionConfiguration = transcriptionConfiguration != null ? transcriptionConfiguration.build() : null;
        }

        @Override
        public final Builder transcriptionConfiguration(TranscriptionConfiguration transcriptionConfiguration) {
            this.transcriptionConfiguration = transcriptionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMeetingTranscriptionRequest build() {
            return new StartMeetingTranscriptionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
