/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmeetings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The video features set for the meeting. Applies to all attendees.
 * </p>
 * <note>
 * <p>
 * If you specify <code>MeetingFeatures:Video:MaxResolution:None</code> when you create a meeting, all API requests that
 * include <code>SendReceive</code>, <code>Send</code>, or <code>Receive</code> for
 * <code>AttendeeCapabilities:Video</code> will be rejected with <code>ValidationError 400</code>.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VideoFeatures implements SdkPojo, Serializable, ToCopyableBuilder<VideoFeatures.Builder, VideoFeatures> {
    private static final SdkField<String> MAX_RESOLUTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxResolution").getter(getter(VideoFeatures::maxResolutionAsString))
            .setter(setter(Builder::maxResolution))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResolution").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESOLUTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String maxResolution;

    private VideoFeatures(BuilderImpl builder) {
        this.maxResolution = builder.maxResolution;
    }

    /**
     * <p>
     * The maximum video resolution for the meeting. Applies to all attendees.
     * </p>
     * <note>
     * <p>
     * Defaults to <code>HD</code>. To use <code>FHD</code>, you must also provide a
     * <code>MeetingFeatures:Attendee:MaxCount</code> value and override the default size limit of 250 attendees.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #maxResolution}
     * will return {@link VideoResolution#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #maxResolutionAsString}.
     * </p>
     * 
     * @return The maximum video resolution for the meeting. Applies to all attendees.</p> <note>
     *         <p>
     *         Defaults to <code>HD</code>. To use <code>FHD</code>, you must also provide a
     *         <code>MeetingFeatures:Attendee:MaxCount</code> value and override the default size limit of 250
     *         attendees.
     *         </p>
     * @see VideoResolution
     */
    public final VideoResolution maxResolution() {
        return VideoResolution.fromValue(maxResolution);
    }

    /**
     * <p>
     * The maximum video resolution for the meeting. Applies to all attendees.
     * </p>
     * <note>
     * <p>
     * Defaults to <code>HD</code>. To use <code>FHD</code>, you must also provide a
     * <code>MeetingFeatures:Attendee:MaxCount</code> value and override the default size limit of 250 attendees.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #maxResolution}
     * will return {@link VideoResolution#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #maxResolutionAsString}.
     * </p>
     * 
     * @return The maximum video resolution for the meeting. Applies to all attendees.</p> <note>
     *         <p>
     *         Defaults to <code>HD</code>. To use <code>FHD</code>, you must also provide a
     *         <code>MeetingFeatures:Attendee:MaxCount</code> value and override the default size limit of 250
     *         attendees.
     *         </p>
     * @see VideoResolution
     */
    public final String maxResolutionAsString() {
        return maxResolution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxResolutionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoFeatures)) {
            return false;
        }
        VideoFeatures other = (VideoFeatures) obj;
        return Objects.equals(maxResolutionAsString(), other.maxResolutionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VideoFeatures").add("MaxResolution", maxResolutionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxResolution":
            return Optional.ofNullable(clazz.cast(maxResolutionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MaxResolution", MAX_RESOLUTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VideoFeatures, T> g) {
        return obj -> g.apply((VideoFeatures) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VideoFeatures> {
        /**
         * <p>
         * The maximum video resolution for the meeting. Applies to all attendees.
         * </p>
         * <note>
         * <p>
         * Defaults to <code>HD</code>. To use <code>FHD</code>, you must also provide a
         * <code>MeetingFeatures:Attendee:MaxCount</code> value and override the default size limit of 250 attendees.
         * </p>
         * </note>
         * 
         * @param maxResolution
         *        The maximum video resolution for the meeting. Applies to all attendees.</p> <note>
         *        <p>
         *        Defaults to <code>HD</code>. To use <code>FHD</code>, you must also provide a
         *        <code>MeetingFeatures:Attendee:MaxCount</code> value and override the default size limit of 250
         *        attendees.
         *        </p>
         * @see VideoResolution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoResolution
         */
        Builder maxResolution(String maxResolution);

        /**
         * <p>
         * The maximum video resolution for the meeting. Applies to all attendees.
         * </p>
         * <note>
         * <p>
         * Defaults to <code>HD</code>. To use <code>FHD</code>, you must also provide a
         * <code>MeetingFeatures:Attendee:MaxCount</code> value and override the default size limit of 250 attendees.
         * </p>
         * </note>
         * 
         * @param maxResolution
         *        The maximum video resolution for the meeting. Applies to all attendees.</p> <note>
         *        <p>
         *        Defaults to <code>HD</code>. To use <code>FHD</code>, you must also provide a
         *        <code>MeetingFeatures:Attendee:MaxCount</code> value and override the default size limit of 250
         *        attendees.
         *        </p>
         * @see VideoResolution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoResolution
         */
        Builder maxResolution(VideoResolution maxResolution);
    }

    static final class BuilderImpl implements Builder {
        private String maxResolution;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoFeatures model) {
            maxResolution(model.maxResolution);
        }

        public final String getMaxResolution() {
            return maxResolution;
        }

        public final void setMaxResolution(String maxResolution) {
            this.maxResolution = maxResolution;
        }

        @Override
        public final Builder maxResolution(String maxResolution) {
            this.maxResolution = maxResolution;
            return this;
        }

        @Override
        public final Builder maxResolution(VideoResolution maxResolution) {
            this.maxResolution(maxResolution == null ? null : maxResolution.toString());
            return this;
        }

        @Override
        public VideoFeatures build() {
            return new VideoFeatures(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
