/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmeetings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkmeetings.model.MediaPlacement;
import software.amazon.awssdk.services.chimesdkmeetings.model.MeetingFeaturesConfiguration;
import software.amazon.awssdk.services.chimesdkmeetings.model.TenantIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Meeting
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Meeting> {
    private static final SdkField<String> MEETING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MeetingId").getter(Meeting.getter(Meeting::meetingId)).setter(Meeting.setter(Builder::meetingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingId").build()}).build();
    private static final SdkField<String> MEETING_HOST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MeetingHostId").getter(Meeting.getter(Meeting::meetingHostId)).setter(Meeting.setter(Builder::meetingHostId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingHostId").build()}).build();
    private static final SdkField<String> EXTERNAL_MEETING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExternalMeetingId").getter(Meeting.getter(Meeting::externalMeetingId)).setter(Meeting.setter(Builder::externalMeetingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalMeetingId").build()}).build();
    private static final SdkField<String> MEDIA_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaRegion").getter(Meeting.getter(Meeting::mediaRegion)).setter(Meeting.setter(Builder::mediaRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaRegion").build()}).build();
    private static final SdkField<MediaPlacement> MEDIA_PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MediaPlacement").getter(Meeting.getter(Meeting::mediaPlacement)).setter(Meeting.setter(Builder::mediaPlacement)).constructor(MediaPlacement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaPlacement").build()}).build();
    private static final SdkField<MeetingFeaturesConfiguration> MEETING_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MeetingFeatures").getter(Meeting.getter(Meeting::meetingFeatures)).setter(Meeting.setter(Builder::meetingFeatures)).constructor(MeetingFeaturesConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingFeatures").build()}).build();
    private static final SdkField<String> PRIMARY_MEETING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryMeetingId").getter(Meeting.getter(Meeting::primaryMeetingId)).setter(Meeting.setter(Builder::primaryMeetingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryMeetingId").build()}).build();
    private static final SdkField<List<String>> TENANT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TenantIds").getter(Meeting.getter(Meeting::tenantIds)).setter(Meeting.setter(Builder::tenantIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MEETING_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MeetingArn").getter(Meeting.getter(Meeting::meetingArn)).setter(Meeting.setter(Builder::meetingArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEETING_ID_FIELD, MEETING_HOST_ID_FIELD, EXTERNAL_MEETING_ID_FIELD, MEDIA_REGION_FIELD, MEDIA_PLACEMENT_FIELD, MEETING_FEATURES_FIELD, PRIMARY_MEETING_ID_FIELD, TENANT_IDS_FIELD, MEETING_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Meeting.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String meetingId;
    private final String meetingHostId;
    private final String externalMeetingId;
    private final String mediaRegion;
    private final MediaPlacement mediaPlacement;
    private final MeetingFeaturesConfiguration meetingFeatures;
    private final String primaryMeetingId;
    private final List<String> tenantIds;
    private final String meetingArn;

    private Meeting(BuilderImpl builder) {
        this.meetingId = builder.meetingId;
        this.meetingHostId = builder.meetingHostId;
        this.externalMeetingId = builder.externalMeetingId;
        this.mediaRegion = builder.mediaRegion;
        this.mediaPlacement = builder.mediaPlacement;
        this.meetingFeatures = builder.meetingFeatures;
        this.primaryMeetingId = builder.primaryMeetingId;
        this.tenantIds = builder.tenantIds;
        this.meetingArn = builder.meetingArn;
    }

    public final String meetingId() {
        return this.meetingId;
    }

    public final String meetingHostId() {
        return this.meetingHostId;
    }

    public final String externalMeetingId() {
        return this.externalMeetingId;
    }

    public final String mediaRegion() {
        return this.mediaRegion;
    }

    public final MediaPlacement mediaPlacement() {
        return this.mediaPlacement;
    }

    public final MeetingFeaturesConfiguration meetingFeatures() {
        return this.meetingFeatures;
    }

    public final String primaryMeetingId() {
        return this.primaryMeetingId;
    }

    public final boolean hasTenantIds() {
        return this.tenantIds != null && !(this.tenantIds instanceof SdkAutoConstructList);
    }

    public final List<String> tenantIds() {
        return this.tenantIds;
    }

    public final String meetingArn() {
        return this.meetingArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.meetingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.meetingHostId());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalMeetingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaPlacement());
        hashCode = 31 * hashCode + Objects.hashCode(this.meetingFeatures());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryMeetingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTenantIds() ? this.tenantIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.meetingArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Meeting)) {
            return false;
        }
        Meeting other = (Meeting)obj;
        return Objects.equals(this.meetingId(), other.meetingId()) && Objects.equals(this.meetingHostId(), other.meetingHostId()) && Objects.equals(this.externalMeetingId(), other.externalMeetingId()) && Objects.equals(this.mediaRegion(), other.mediaRegion()) && Objects.equals(this.mediaPlacement(), other.mediaPlacement()) && Objects.equals(this.meetingFeatures(), other.meetingFeatures()) && Objects.equals(this.primaryMeetingId(), other.primaryMeetingId()) && this.hasTenantIds() == other.hasTenantIds() && Objects.equals(this.tenantIds(), other.tenantIds()) && Objects.equals(this.meetingArn(), other.meetingArn());
    }

    public final String toString() {
        return ToString.builder((String)"Meeting").add("MeetingId", (Object)this.meetingId()).add("MeetingHostId", (Object)(this.meetingHostId() == null ? null : "*** Sensitive Data Redacted ***")).add("ExternalMeetingId", (Object)(this.externalMeetingId() == null ? null : "*** Sensitive Data Redacted ***")).add("MediaRegion", (Object)this.mediaRegion()).add("MediaPlacement", (Object)this.mediaPlacement()).add("MeetingFeatures", (Object)this.meetingFeatures()).add("PrimaryMeetingId", (Object)this.primaryMeetingId()).add("TenantIds", this.hasTenantIds() ? this.tenantIds() : null).add("MeetingArn", (Object)this.meetingArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MeetingId": {
                return Optional.ofNullable(clazz.cast(this.meetingId()));
            }
            case "MeetingHostId": {
                return Optional.ofNullable(clazz.cast(this.meetingHostId()));
            }
            case "ExternalMeetingId": {
                return Optional.ofNullable(clazz.cast(this.externalMeetingId()));
            }
            case "MediaRegion": {
                return Optional.ofNullable(clazz.cast(this.mediaRegion()));
            }
            case "MediaPlacement": {
                return Optional.ofNullable(clazz.cast(this.mediaPlacement()));
            }
            case "MeetingFeatures": {
                return Optional.ofNullable(clazz.cast(this.meetingFeatures()));
            }
            case "PrimaryMeetingId": {
                return Optional.ofNullable(clazz.cast(this.primaryMeetingId()));
            }
            case "TenantIds": {
                return Optional.ofNullable(clazz.cast(this.tenantIds()));
            }
            case "MeetingArn": {
                return Optional.ofNullable(clazz.cast(this.meetingArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MeetingId", MEETING_ID_FIELD);
        map.put("MeetingHostId", MEETING_HOST_ID_FIELD);
        map.put("ExternalMeetingId", EXTERNAL_MEETING_ID_FIELD);
        map.put("MediaRegion", MEDIA_REGION_FIELD);
        map.put("MediaPlacement", MEDIA_PLACEMENT_FIELD);
        map.put("MeetingFeatures", MEETING_FEATURES_FIELD);
        map.put("PrimaryMeetingId", PRIMARY_MEETING_ID_FIELD);
        map.put("TenantIds", TENANT_IDS_FIELD);
        map.put("MeetingArn", MEETING_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Meeting, T> g) {
        return obj -> g.apply((Meeting)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String meetingId;
        private String meetingHostId;
        private String externalMeetingId;
        private String mediaRegion;
        private MediaPlacement mediaPlacement;
        private MeetingFeaturesConfiguration meetingFeatures;
        private String primaryMeetingId;
        private List<String> tenantIds = DefaultSdkAutoConstructList.getInstance();
        private String meetingArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Meeting model) {
            this.meetingId(model.meetingId);
            this.meetingHostId(model.meetingHostId);
            this.externalMeetingId(model.externalMeetingId);
            this.mediaRegion(model.mediaRegion);
            this.mediaPlacement(model.mediaPlacement);
            this.meetingFeatures(model.meetingFeatures);
            this.primaryMeetingId(model.primaryMeetingId);
            this.tenantIds(model.tenantIds);
            this.meetingArn(model.meetingArn);
        }

        public final String getMeetingId() {
            return this.meetingId;
        }

        public final void setMeetingId(String meetingId) {
            this.meetingId = meetingId;
        }

        @Override
        public final Builder meetingId(String meetingId) {
            this.meetingId = meetingId;
            return this;
        }

        public final String getMeetingHostId() {
            return this.meetingHostId;
        }

        public final void setMeetingHostId(String meetingHostId) {
            this.meetingHostId = meetingHostId;
        }

        @Override
        public final Builder meetingHostId(String meetingHostId) {
            this.meetingHostId = meetingHostId;
            return this;
        }

        public final String getExternalMeetingId() {
            return this.externalMeetingId;
        }

        public final void setExternalMeetingId(String externalMeetingId) {
            this.externalMeetingId = externalMeetingId;
        }

        @Override
        public final Builder externalMeetingId(String externalMeetingId) {
            this.externalMeetingId = externalMeetingId;
            return this;
        }

        public final String getMediaRegion() {
            return this.mediaRegion;
        }

        public final void setMediaRegion(String mediaRegion) {
            this.mediaRegion = mediaRegion;
        }

        @Override
        public final Builder mediaRegion(String mediaRegion) {
            this.mediaRegion = mediaRegion;
            return this;
        }

        public final MediaPlacement.Builder getMediaPlacement() {
            return this.mediaPlacement != null ? this.mediaPlacement.toBuilder() : null;
        }

        public final void setMediaPlacement(MediaPlacement.BuilderImpl mediaPlacement) {
            this.mediaPlacement = mediaPlacement != null ? mediaPlacement.build() : null;
        }

        @Override
        public final Builder mediaPlacement(MediaPlacement mediaPlacement) {
            this.mediaPlacement = mediaPlacement;
            return this;
        }

        public final MeetingFeaturesConfiguration.Builder getMeetingFeatures() {
            return this.meetingFeatures != null ? this.meetingFeatures.toBuilder() : null;
        }

        public final void setMeetingFeatures(MeetingFeaturesConfiguration.BuilderImpl meetingFeatures) {
            this.meetingFeatures = meetingFeatures != null ? meetingFeatures.build() : null;
        }

        @Override
        public final Builder meetingFeatures(MeetingFeaturesConfiguration meetingFeatures) {
            this.meetingFeatures = meetingFeatures;
            return this;
        }

        public final String getPrimaryMeetingId() {
            return this.primaryMeetingId;
        }

        public final void setPrimaryMeetingId(String primaryMeetingId) {
            this.primaryMeetingId = primaryMeetingId;
        }

        @Override
        public final Builder primaryMeetingId(String primaryMeetingId) {
            this.primaryMeetingId = primaryMeetingId;
            return this;
        }

        public final Collection<String> getTenantIds() {
            if (this.tenantIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tenantIds;
        }

        public final void setTenantIds(Collection<String> tenantIds) {
            this.tenantIds = TenantIdListCopier.copy(tenantIds);
        }

        @Override
        public final Builder tenantIds(Collection<String> tenantIds) {
            this.tenantIds = TenantIdListCopier.copy(tenantIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tenantIds(String ... tenantIds) {
            this.tenantIds(Arrays.asList(tenantIds));
            return this;
        }

        public final String getMeetingArn() {
            return this.meetingArn;
        }

        public final void setMeetingArn(String meetingArn) {
            this.meetingArn = meetingArn;
        }

        @Override
        public final Builder meetingArn(String meetingArn) {
            this.meetingArn = meetingArn;
            return this;
        }

        public Meeting build() {
            return new Meeting(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Meeting> {
        public Builder meetingId(String var1);

        public Builder meetingHostId(String var1);

        public Builder externalMeetingId(String var1);

        public Builder mediaRegion(String var1);

        public Builder mediaPlacement(MediaPlacement var1);

        default public Builder mediaPlacement(Consumer<MediaPlacement.Builder> mediaPlacement) {
            return this.mediaPlacement((MediaPlacement)((MediaPlacement.Builder)MediaPlacement.builder().applyMutation(mediaPlacement)).build());
        }

        public Builder meetingFeatures(MeetingFeaturesConfiguration var1);

        default public Builder meetingFeatures(Consumer<MeetingFeaturesConfiguration.Builder> meetingFeatures) {
            return this.meetingFeatures((MeetingFeaturesConfiguration)((MeetingFeaturesConfiguration.Builder)MeetingFeaturesConfiguration.builder().applyMutation(meetingFeatures)).build());
        }

        public Builder primaryMeetingId(String var1);

        public Builder tenantIds(Collection<String> var1);

        public Builder tenantIds(String ... var1);

        public Builder meetingArn(String var1);
    }
}

