/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmeetings.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkmeetings.model.ChimeSdkMeetingsRequest;
import software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeRequestItem;
import software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeRequestItemListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchCreateAttendeeRequest
extends ChimeSdkMeetingsRequest
implements ToCopyableBuilder<Builder, BatchCreateAttendeeRequest> {
    private static final SdkField<String> MEETING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MeetingId").getter(BatchCreateAttendeeRequest.getter(BatchCreateAttendeeRequest::meetingId)).setter(BatchCreateAttendeeRequest.setter(Builder::meetingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("MeetingId").build()}).build();
    private static final SdkField<List<CreateAttendeeRequestItem>> ATTENDEES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Attendees").getter(BatchCreateAttendeeRequest.getter(BatchCreateAttendeeRequest::attendees)).setter(BatchCreateAttendeeRequest.setter(Builder::attendees)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attendees").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CreateAttendeeRequestItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEETING_ID_FIELD, ATTENDEES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchCreateAttendeeRequest.memberNameToFieldInitializer();
    private final String meetingId;
    private final List<CreateAttendeeRequestItem> attendees;

    private BatchCreateAttendeeRequest(BuilderImpl builder) {
        super(builder);
        this.meetingId = builder.meetingId;
        this.attendees = builder.attendees;
    }

    public final String meetingId() {
        return this.meetingId;
    }

    public final boolean hasAttendees() {
        return this.attendees != null && !(this.attendees instanceof SdkAutoConstructList);
    }

    public final List<CreateAttendeeRequestItem> attendees() {
        return this.attendees;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.meetingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttendees() ? this.attendees() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateAttendeeRequest)) {
            return false;
        }
        BatchCreateAttendeeRequest other = (BatchCreateAttendeeRequest)((Object)obj);
        return Objects.equals(this.meetingId(), other.meetingId()) && this.hasAttendees() == other.hasAttendees() && Objects.equals(this.attendees(), other.attendees());
    }

    public final String toString() {
        return ToString.builder((String)"BatchCreateAttendeeRequest").add("MeetingId", (Object)this.meetingId()).add("Attendees", this.hasAttendees() ? this.attendees() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MeetingId": {
                return Optional.ofNullable(clazz.cast(this.meetingId()));
            }
            case "Attendees": {
                return Optional.ofNullable(clazz.cast(this.attendees()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MeetingId", MEETING_ID_FIELD);
        map.put("Attendees", ATTENDEES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateAttendeeRequest, T> g) {
        return obj -> g.apply((BatchCreateAttendeeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkMeetingsRequest.BuilderImpl
    implements Builder {
        private String meetingId;
        private List<CreateAttendeeRequestItem> attendees = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateAttendeeRequest model) {
            super(model);
            this.meetingId(model.meetingId);
            this.attendees(model.attendees);
        }

        public final String getMeetingId() {
            return this.meetingId;
        }

        public final void setMeetingId(String meetingId) {
            this.meetingId = meetingId;
        }

        @Override
        public final Builder meetingId(String meetingId) {
            this.meetingId = meetingId;
            return this;
        }

        public final List<CreateAttendeeRequestItem.Builder> getAttendees() {
            List<CreateAttendeeRequestItem.Builder> result = CreateAttendeeRequestItemListCopier.copyToBuilder(this.attendees);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttendees(Collection<CreateAttendeeRequestItem.BuilderImpl> attendees) {
            this.attendees = CreateAttendeeRequestItemListCopier.copyFromBuilder(attendees);
        }

        @Override
        public final Builder attendees(Collection<CreateAttendeeRequestItem> attendees) {
            this.attendees = CreateAttendeeRequestItemListCopier.copy(attendees);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attendees(CreateAttendeeRequestItem ... attendees) {
            this.attendees(Arrays.asList(attendees));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attendees(Consumer<CreateAttendeeRequestItem.Builder> ... attendees) {
            this.attendees(Stream.of(attendees).map(c -> (CreateAttendeeRequestItem)((CreateAttendeeRequestItem.Builder)CreateAttendeeRequestItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchCreateAttendeeRequest build() {
            return new BatchCreateAttendeeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ChimeSdkMeetingsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchCreateAttendeeRequest> {
        public Builder meetingId(String var1);

        public Builder attendees(Collection<CreateAttendeeRequestItem> var1);

        public Builder attendees(CreateAttendeeRequestItem ... var1);

        public Builder attendees(Consumer<CreateAttendeeRequestItem.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

