/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmeetings.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkmeetings.model.ChimeSdkMeetingsRequest;
import software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeRequestItem;
import software.amazon.awssdk.services.chimesdkmeetings.model.CreateMeetingWithAttendeesRequestItemListCopier;
import software.amazon.awssdk.services.chimesdkmeetings.model.MeetingFeaturesConfiguration;
import software.amazon.awssdk.services.chimesdkmeetings.model.NotificationsConfiguration;
import software.amazon.awssdk.services.chimesdkmeetings.model.Tag;
import software.amazon.awssdk.services.chimesdkmeetings.model.TagListCopier;
import software.amazon.awssdk.services.chimesdkmeetings.model.TenantIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMeetingWithAttendeesRequest
extends ChimeSdkMeetingsRequest
implements ToCopyableBuilder<Builder, CreateMeetingWithAttendeesRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateMeetingWithAttendeesRequest.getter(CreateMeetingWithAttendeesRequest::clientRequestToken)).setter(CreateMeetingWithAttendeesRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> MEDIA_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaRegion").getter(CreateMeetingWithAttendeesRequest.getter(CreateMeetingWithAttendeesRequest::mediaRegion)).setter(CreateMeetingWithAttendeesRequest.setter(Builder::mediaRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaRegion").build()}).build();
    private static final SdkField<String> MEETING_HOST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MeetingHostId").getter(CreateMeetingWithAttendeesRequest.getter(CreateMeetingWithAttendeesRequest::meetingHostId)).setter(CreateMeetingWithAttendeesRequest.setter(Builder::meetingHostId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingHostId").build()}).build();
    private static final SdkField<String> EXTERNAL_MEETING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExternalMeetingId").getter(CreateMeetingWithAttendeesRequest.getter(CreateMeetingWithAttendeesRequest::externalMeetingId)).setter(CreateMeetingWithAttendeesRequest.setter(Builder::externalMeetingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalMeetingId").build()}).build();
    private static final SdkField<MeetingFeaturesConfiguration> MEETING_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MeetingFeatures").getter(CreateMeetingWithAttendeesRequest.getter(CreateMeetingWithAttendeesRequest::meetingFeatures)).setter(CreateMeetingWithAttendeesRequest.setter(Builder::meetingFeatures)).constructor(MeetingFeaturesConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingFeatures").build()}).build();
    private static final SdkField<NotificationsConfiguration> NOTIFICATIONS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NotificationsConfiguration").getter(CreateMeetingWithAttendeesRequest.getter(CreateMeetingWithAttendeesRequest::notificationsConfiguration)).setter(CreateMeetingWithAttendeesRequest.setter(Builder::notificationsConfiguration)).constructor(NotificationsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationsConfiguration").build()}).build();
    private static final SdkField<List<CreateAttendeeRequestItem>> ATTENDEES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Attendees").getter(CreateMeetingWithAttendeesRequest.getter(CreateMeetingWithAttendeesRequest::attendees)).setter(CreateMeetingWithAttendeesRequest.setter(Builder::attendees)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attendees").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CreateAttendeeRequestItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PRIMARY_MEETING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryMeetingId").getter(CreateMeetingWithAttendeesRequest.getter(CreateMeetingWithAttendeesRequest::primaryMeetingId)).setter(CreateMeetingWithAttendeesRequest.setter(Builder::primaryMeetingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryMeetingId").build()}).build();
    private static final SdkField<List<String>> TENANT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TenantIds").getter(CreateMeetingWithAttendeesRequest.getter(CreateMeetingWithAttendeesRequest::tenantIds)).setter(CreateMeetingWithAttendeesRequest.setter(Builder::tenantIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateMeetingWithAttendeesRequest.getter(CreateMeetingWithAttendeesRequest::tags)).setter(CreateMeetingWithAttendeesRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD, MEDIA_REGION_FIELD, MEETING_HOST_ID_FIELD, EXTERNAL_MEETING_ID_FIELD, MEETING_FEATURES_FIELD, NOTIFICATIONS_CONFIGURATION_FIELD, ATTENDEES_FIELD, PRIMARY_MEETING_ID_FIELD, TENANT_IDS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateMeetingWithAttendeesRequest.memberNameToFieldInitializer();
    private final String clientRequestToken;
    private final String mediaRegion;
    private final String meetingHostId;
    private final String externalMeetingId;
    private final MeetingFeaturesConfiguration meetingFeatures;
    private final NotificationsConfiguration notificationsConfiguration;
    private final List<CreateAttendeeRequestItem> attendees;
    private final String primaryMeetingId;
    private final List<String> tenantIds;
    private final List<Tag> tags;

    private CreateMeetingWithAttendeesRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.mediaRegion = builder.mediaRegion;
        this.meetingHostId = builder.meetingHostId;
        this.externalMeetingId = builder.externalMeetingId;
        this.meetingFeatures = builder.meetingFeatures;
        this.notificationsConfiguration = builder.notificationsConfiguration;
        this.attendees = builder.attendees;
        this.primaryMeetingId = builder.primaryMeetingId;
        this.tenantIds = builder.tenantIds;
        this.tags = builder.tags;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String mediaRegion() {
        return this.mediaRegion;
    }

    public final String meetingHostId() {
        return this.meetingHostId;
    }

    public final String externalMeetingId() {
        return this.externalMeetingId;
    }

    public final MeetingFeaturesConfiguration meetingFeatures() {
        return this.meetingFeatures;
    }

    public final NotificationsConfiguration notificationsConfiguration() {
        return this.notificationsConfiguration;
    }

    public final boolean hasAttendees() {
        return this.attendees != null && !(this.attendees instanceof SdkAutoConstructList);
    }

    public final List<CreateAttendeeRequestItem> attendees() {
        return this.attendees;
    }

    public final String primaryMeetingId() {
        return this.primaryMeetingId;
    }

    public final boolean hasTenantIds() {
        return this.tenantIds != null && !(this.tenantIds instanceof SdkAutoConstructList);
    }

    public final List<String> tenantIds() {
        return this.tenantIds;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.meetingHostId());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalMeetingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.meetingFeatures());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttendees() ? this.attendees() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryMeetingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTenantIds() ? this.tenantIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMeetingWithAttendeesRequest)) {
            return false;
        }
        CreateMeetingWithAttendeesRequest other = (CreateMeetingWithAttendeesRequest)((Object)obj);
        return Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.mediaRegion(), other.mediaRegion()) && Objects.equals(this.meetingHostId(), other.meetingHostId()) && Objects.equals(this.externalMeetingId(), other.externalMeetingId()) && Objects.equals(this.meetingFeatures(), other.meetingFeatures()) && Objects.equals(this.notificationsConfiguration(), other.notificationsConfiguration()) && this.hasAttendees() == other.hasAttendees() && Objects.equals(this.attendees(), other.attendees()) && Objects.equals(this.primaryMeetingId(), other.primaryMeetingId()) && this.hasTenantIds() == other.hasTenantIds() && Objects.equals(this.tenantIds(), other.tenantIds()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMeetingWithAttendeesRequest").add("ClientRequestToken", (Object)(this.clientRequestToken() == null ? null : "*** Sensitive Data Redacted ***")).add("MediaRegion", (Object)this.mediaRegion()).add("MeetingHostId", (Object)(this.meetingHostId() == null ? null : "*** Sensitive Data Redacted ***")).add("ExternalMeetingId", (Object)(this.externalMeetingId() == null ? null : "*** Sensitive Data Redacted ***")).add("MeetingFeatures", (Object)this.meetingFeatures()).add("NotificationsConfiguration", (Object)this.notificationsConfiguration()).add("Attendees", this.hasAttendees() ? this.attendees() : null).add("PrimaryMeetingId", (Object)this.primaryMeetingId()).add("TenantIds", this.hasTenantIds() ? this.tenantIds() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "MediaRegion": {
                return Optional.ofNullable(clazz.cast(this.mediaRegion()));
            }
            case "MeetingHostId": {
                return Optional.ofNullable(clazz.cast(this.meetingHostId()));
            }
            case "ExternalMeetingId": {
                return Optional.ofNullable(clazz.cast(this.externalMeetingId()));
            }
            case "MeetingFeatures": {
                return Optional.ofNullable(clazz.cast(this.meetingFeatures()));
            }
            case "NotificationsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.notificationsConfiguration()));
            }
            case "Attendees": {
                return Optional.ofNullable(clazz.cast(this.attendees()));
            }
            case "PrimaryMeetingId": {
                return Optional.ofNullable(clazz.cast(this.primaryMeetingId()));
            }
            case "TenantIds": {
                return Optional.ofNullable(clazz.cast(this.tenantIds()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("MediaRegion", MEDIA_REGION_FIELD);
        map.put("MeetingHostId", MEETING_HOST_ID_FIELD);
        map.put("ExternalMeetingId", EXTERNAL_MEETING_ID_FIELD);
        map.put("MeetingFeatures", MEETING_FEATURES_FIELD);
        map.put("NotificationsConfiguration", NOTIFICATIONS_CONFIGURATION_FIELD);
        map.put("Attendees", ATTENDEES_FIELD);
        map.put("PrimaryMeetingId", PRIMARY_MEETING_ID_FIELD);
        map.put("TenantIds", TENANT_IDS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMeetingWithAttendeesRequest, T> g) {
        return obj -> g.apply((CreateMeetingWithAttendeesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkMeetingsRequest.BuilderImpl
    implements Builder {
        private String clientRequestToken;
        private String mediaRegion;
        private String meetingHostId;
        private String externalMeetingId;
        private MeetingFeaturesConfiguration meetingFeatures;
        private NotificationsConfiguration notificationsConfiguration;
        private List<CreateAttendeeRequestItem> attendees = DefaultSdkAutoConstructList.getInstance();
        private String primaryMeetingId;
        private List<String> tenantIds = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMeetingWithAttendeesRequest model) {
            super(model);
            this.clientRequestToken(model.clientRequestToken);
            this.mediaRegion(model.mediaRegion);
            this.meetingHostId(model.meetingHostId);
            this.externalMeetingId(model.externalMeetingId);
            this.meetingFeatures(model.meetingFeatures);
            this.notificationsConfiguration(model.notificationsConfiguration);
            this.attendees(model.attendees);
            this.primaryMeetingId(model.primaryMeetingId);
            this.tenantIds(model.tenantIds);
            this.tags(model.tags);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getMediaRegion() {
            return this.mediaRegion;
        }

        public final void setMediaRegion(String mediaRegion) {
            this.mediaRegion = mediaRegion;
        }

        @Override
        public final Builder mediaRegion(String mediaRegion) {
            this.mediaRegion = mediaRegion;
            return this;
        }

        public final String getMeetingHostId() {
            return this.meetingHostId;
        }

        public final void setMeetingHostId(String meetingHostId) {
            this.meetingHostId = meetingHostId;
        }

        @Override
        public final Builder meetingHostId(String meetingHostId) {
            this.meetingHostId = meetingHostId;
            return this;
        }

        public final String getExternalMeetingId() {
            return this.externalMeetingId;
        }

        public final void setExternalMeetingId(String externalMeetingId) {
            this.externalMeetingId = externalMeetingId;
        }

        @Override
        public final Builder externalMeetingId(String externalMeetingId) {
            this.externalMeetingId = externalMeetingId;
            return this;
        }

        public final MeetingFeaturesConfiguration.Builder getMeetingFeatures() {
            return this.meetingFeatures != null ? this.meetingFeatures.toBuilder() : null;
        }

        public final void setMeetingFeatures(MeetingFeaturesConfiguration.BuilderImpl meetingFeatures) {
            this.meetingFeatures = meetingFeatures != null ? meetingFeatures.build() : null;
        }

        @Override
        public final Builder meetingFeatures(MeetingFeaturesConfiguration meetingFeatures) {
            this.meetingFeatures = meetingFeatures;
            return this;
        }

        public final NotificationsConfiguration.Builder getNotificationsConfiguration() {
            return this.notificationsConfiguration != null ? this.notificationsConfiguration.toBuilder() : null;
        }

        public final void setNotificationsConfiguration(NotificationsConfiguration.BuilderImpl notificationsConfiguration) {
            this.notificationsConfiguration = notificationsConfiguration != null ? notificationsConfiguration.build() : null;
        }

        @Override
        public final Builder notificationsConfiguration(NotificationsConfiguration notificationsConfiguration) {
            this.notificationsConfiguration = notificationsConfiguration;
            return this;
        }

        public final List<CreateAttendeeRequestItem.Builder> getAttendees() {
            List<CreateAttendeeRequestItem.Builder> result = CreateMeetingWithAttendeesRequestItemListCopier.copyToBuilder(this.attendees);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttendees(Collection<CreateAttendeeRequestItem.BuilderImpl> attendees) {
            this.attendees = CreateMeetingWithAttendeesRequestItemListCopier.copyFromBuilder(attendees);
        }

        @Override
        public final Builder attendees(Collection<CreateAttendeeRequestItem> attendees) {
            this.attendees = CreateMeetingWithAttendeesRequestItemListCopier.copy(attendees);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attendees(CreateAttendeeRequestItem ... attendees) {
            this.attendees(Arrays.asList(attendees));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attendees(Consumer<CreateAttendeeRequestItem.Builder> ... attendees) {
            this.attendees(Stream.of(attendees).map(c -> (CreateAttendeeRequestItem)((CreateAttendeeRequestItem.Builder)CreateAttendeeRequestItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPrimaryMeetingId() {
            return this.primaryMeetingId;
        }

        public final void setPrimaryMeetingId(String primaryMeetingId) {
            this.primaryMeetingId = primaryMeetingId;
        }

        @Override
        public final Builder primaryMeetingId(String primaryMeetingId) {
            this.primaryMeetingId = primaryMeetingId;
            return this;
        }

        public final Collection<String> getTenantIds() {
            if (this.tenantIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tenantIds;
        }

        public final void setTenantIds(Collection<String> tenantIds) {
            this.tenantIds = TenantIdListCopier.copy(tenantIds);
        }

        @Override
        public final Builder tenantIds(Collection<String> tenantIds) {
            this.tenantIds = TenantIdListCopier.copy(tenantIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tenantIds(String ... tenantIds) {
            this.tenantIds(Arrays.asList(tenantIds));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMeetingWithAttendeesRequest build() {
            return new CreateMeetingWithAttendeesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ChimeSdkMeetingsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMeetingWithAttendeesRequest> {
        public Builder clientRequestToken(String var1);

        public Builder mediaRegion(String var1);

        public Builder meetingHostId(String var1);

        public Builder externalMeetingId(String var1);

        public Builder meetingFeatures(MeetingFeaturesConfiguration var1);

        default public Builder meetingFeatures(Consumer<MeetingFeaturesConfiguration.Builder> meetingFeatures) {
            return this.meetingFeatures((MeetingFeaturesConfiguration)((MeetingFeaturesConfiguration.Builder)MeetingFeaturesConfiguration.builder().applyMutation(meetingFeatures)).build());
        }

        public Builder notificationsConfiguration(NotificationsConfiguration var1);

        default public Builder notificationsConfiguration(Consumer<NotificationsConfiguration.Builder> notificationsConfiguration) {
            return this.notificationsConfiguration((NotificationsConfiguration)((NotificationsConfiguration.Builder)NotificationsConfiguration.builder().applyMutation(notificationsConfiguration)).build());
        }

        public Builder attendees(Collection<CreateAttendeeRequestItem> var1);

        public Builder attendees(CreateAttendeeRequestItem ... var1);

        public Builder attendees(Consumer<CreateAttendeeRequestItem.Builder> ... var1);

        public Builder primaryMeetingId(String var1);

        public Builder tenantIds(Collection<String> var1);

        public Builder tenantIds(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

