/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a message in a channel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChannelMessage implements SdkPojo, Serializable, ToCopyableBuilder<ChannelMessage.Builder, ChannelMessage> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelArn").getter(getter(ChannelMessage::channelArn)).setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelArn").build()).build();

    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageId").getter(getter(ChannelMessage::messageId)).setter(setter(Builder::messageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageId").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(ChannelMessage::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<String> METADATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Metadata").getter(getter(ChannelMessage::metadata)).setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ChannelMessage::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(ChannelMessage::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<Instant> LAST_EDITED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastEditedTimestamp").getter(getter(ChannelMessage::lastEditedTimestamp))
            .setter(setter(Builder::lastEditedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastEditedTimestamp").build())
            .build();

    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTimestamp").getter(getter(ChannelMessage::lastUpdatedTimestamp))
            .setter(setter(Builder::lastUpdatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build())
            .build();

    private static final SdkField<Identity> SENDER_FIELD = SdkField.<Identity> builder(MarshallingType.SDK_POJO)
            .memberName("Sender").getter(getter(ChannelMessage::sender)).setter(setter(Builder::sender))
            .constructor(Identity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sender").build()).build();

    private static final SdkField<Boolean> REDACTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Redacted").getter(getter(ChannelMessage::redacted)).setter(setter(Builder::redacted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Redacted").build()).build();

    private static final SdkField<String> PERSISTENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Persistence").getter(getter(ChannelMessage::persistenceAsString)).setter(setter(Builder::persistence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Persistence").build()).build();

    private static final SdkField<ChannelMessageStatusStructure> STATUS_FIELD = SdkField
            .<ChannelMessageStatusStructure> builder(MarshallingType.SDK_POJO).memberName("Status")
            .getter(getter(ChannelMessage::status)).setter(setter(Builder::status))
            .constructor(ChannelMessageStatusStructure::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Map<String, MessageAttributeValue>> MESSAGE_ATTRIBUTES_FIELD = SdkField
            .<Map<String, MessageAttributeValue>> builder(MarshallingType.MAP)
            .memberName("MessageAttributes")
            .getter(getter(ChannelMessage::messageAttributes))
            .setter(setter(Builder::messageAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<MessageAttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(MessageAttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CHANNEL_ARN_FIELD, MESSAGE_ID_FIELD, CONTENT_FIELD, METADATA_FIELD, TYPE_FIELD, CREATED_TIMESTAMP_FIELD,
                    LAST_EDITED_TIMESTAMP_FIELD, LAST_UPDATED_TIMESTAMP_FIELD, SENDER_FIELD, REDACTED_FIELD, PERSISTENCE_FIELD,
                    STATUS_FIELD, MESSAGE_ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String channelArn;

    private final String messageId;

    private final String content;

    private final String metadata;

    private final String type;

    private final Instant createdTimestamp;

    private final Instant lastEditedTimestamp;

    private final Instant lastUpdatedTimestamp;

    private final Identity sender;

    private final Boolean redacted;

    private final String persistence;

    private final ChannelMessageStatusStructure status;

    private final Map<String, MessageAttributeValue> messageAttributes;

    private ChannelMessage(BuilderImpl builder) {
        this.channelArn = builder.channelArn;
        this.messageId = builder.messageId;
        this.content = builder.content;
        this.metadata = builder.metadata;
        this.type = builder.type;
        this.createdTimestamp = builder.createdTimestamp;
        this.lastEditedTimestamp = builder.lastEditedTimestamp;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.sender = builder.sender;
        this.redacted = builder.redacted;
        this.persistence = builder.persistence;
        this.status = builder.status;
        this.messageAttributes = builder.messageAttributes;
    }

    /**
     * <p>
     * The ARN of the channel.
     * </p>
     * 
     * @return The ARN of the channel.
     */
    public final String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * The ID of a message.
     * </p>
     * 
     * @return The ID of a message.
     */
    public final String messageId() {
        return messageId;
    }

    /**
     * <p>
     * The message content.
     * </p>
     * 
     * @return The message content.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * The message metadata.
     * </p>
     * 
     * @return The message metadata.
     */
    public final String metadata() {
        return metadata;
    }

    /**
     * <p>
     * The message type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChannelMessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The message type.
     * @see ChannelMessageType
     */
    public final ChannelMessageType type() {
        return ChannelMessageType.fromValue(type);
    }

    /**
     * <p>
     * The message type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChannelMessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The message type.
     * @see ChannelMessageType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The time at which the message was created.
     * </p>
     * 
     * @return The time at which the message was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The time at which a message was edited.
     * </p>
     * 
     * @return The time at which a message was edited.
     */
    public final Instant lastEditedTimestamp() {
        return lastEditedTimestamp;
    }

    /**
     * <p>
     * The time at which a message was updated.
     * </p>
     * 
     * @return The time at which a message was updated.
     */
    public final Instant lastUpdatedTimestamp() {
        return lastUpdatedTimestamp;
    }

    /**
     * <p>
     * The message sender.
     * </p>
     * 
     * @return The message sender.
     */
    public final Identity sender() {
        return sender;
    }

    /**
     * <p>
     * Hides the content of a message.
     * </p>
     * 
     * @return Hides the content of a message.
     */
    public final Boolean redacted() {
        return redacted;
    }

    /**
     * <p>
     * The persistence setting for a channel message.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #persistence} will
     * return {@link ChannelMessagePersistenceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #persistenceAsString}.
     * </p>
     * 
     * @return The persistence setting for a channel message.
     * @see ChannelMessagePersistenceType
     */
    public final ChannelMessagePersistenceType persistence() {
        return ChannelMessagePersistenceType.fromValue(persistence);
    }

    /**
     * <p>
     * The persistence setting for a channel message.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #persistence} will
     * return {@link ChannelMessagePersistenceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #persistenceAsString}.
     * </p>
     * 
     * @return The persistence setting for a channel message.
     * @see ChannelMessagePersistenceType
     */
    public final String persistenceAsString() {
        return persistence;
    }

    /**
     * <p>
     * The status of the channel message.
     * </p>
     * 
     * @return The status of the channel message.
     */
    public final ChannelMessageStatusStructure status() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the MessageAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMessageAttributes() {
        return messageAttributes != null && !(messageAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The attributes for the message, used for message filtering along with a <code>FilterRule</code> defined in the
     * <code>PushNotificationPreferences</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMessageAttributes} method.
     * </p>
     * 
     * @return The attributes for the message, used for message filtering along with a <code>FilterRule</code> defined
     *         in the <code>PushNotificationPreferences</code>.
     */
    public final Map<String, MessageAttributeValue> messageAttributes() {
        return messageAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(messageId());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastEditedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(sender());
        hashCode = 31 * hashCode + Objects.hashCode(redacted());
        hashCode = 31 * hashCode + Objects.hashCode(persistenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(hasMessageAttributes() ? messageAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelMessage)) {
            return false;
        }
        ChannelMessage other = (ChannelMessage) obj;
        return Objects.equals(channelArn(), other.channelArn()) && Objects.equals(messageId(), other.messageId())
                && Objects.equals(content(), other.content()) && Objects.equals(metadata(), other.metadata())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(lastEditedTimestamp(), other.lastEditedTimestamp())
                && Objects.equals(lastUpdatedTimestamp(), other.lastUpdatedTimestamp())
                && Objects.equals(sender(), other.sender()) && Objects.equals(redacted(), other.redacted())
                && Objects.equals(persistenceAsString(), other.persistenceAsString()) && Objects.equals(status(), other.status())
                && hasMessageAttributes() == other.hasMessageAttributes()
                && Objects.equals(messageAttributes(), other.messageAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChannelMessage").add("ChannelArn", channelArn()).add("MessageId", messageId())
                .add("Content", content() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Metadata", metadata() == null ? null : "*** Sensitive Data Redacted ***").add("Type", typeAsString())
                .add("CreatedTimestamp", createdTimestamp()).add("LastEditedTimestamp", lastEditedTimestamp())
                .add("LastUpdatedTimestamp", lastUpdatedTimestamp()).add("Sender", sender()).add("Redacted", redacted())
                .add("Persistence", persistenceAsString()).add("Status", status())
                .add("MessageAttributes", messageAttributes() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "MessageId":
            return Optional.ofNullable(clazz.cast(messageId()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "Metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "LastEditedTimestamp":
            return Optional.ofNullable(clazz.cast(lastEditedTimestamp()));
        case "LastUpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(lastUpdatedTimestamp()));
        case "Sender":
            return Optional.ofNullable(clazz.cast(sender()));
        case "Redacted":
            return Optional.ofNullable(clazz.cast(redacted()));
        case "Persistence":
            return Optional.ofNullable(clazz.cast(persistenceAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "MessageAttributes":
            return Optional.ofNullable(clazz.cast(messageAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChannelMessage, T> g) {
        return obj -> g.apply((ChannelMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChannelMessage> {
        /**
         * <p>
         * The ARN of the channel.
         * </p>
         * 
         * @param channelArn
         *        The ARN of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * The ID of a message.
         * </p>
         * 
         * @param messageId
         *        The ID of a message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageId(String messageId);

        /**
         * <p>
         * The message content.
         * </p>
         * 
         * @param content
         *        The message content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * The message metadata.
         * </p>
         * 
         * @param metadata
         *        The message metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(String metadata);

        /**
         * <p>
         * The message type.
         * </p>
         * 
         * @param type
         *        The message type.
         * @see ChannelMessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelMessageType
         */
        Builder type(String type);

        /**
         * <p>
         * The message type.
         * </p>
         * 
         * @param type
         *        The message type.
         * @see ChannelMessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelMessageType
         */
        Builder type(ChannelMessageType type);

        /**
         * <p>
         * The time at which the message was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The time at which the message was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The time at which a message was edited.
         * </p>
         * 
         * @param lastEditedTimestamp
         *        The time at which a message was edited.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastEditedTimestamp(Instant lastEditedTimestamp);

        /**
         * <p>
         * The time at which a message was updated.
         * </p>
         * 
         * @param lastUpdatedTimestamp
         *        The time at which a message was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp);

        /**
         * <p>
         * The message sender.
         * </p>
         * 
         * @param sender
         *        The message sender.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sender(Identity sender);

        /**
         * <p>
         * The message sender.
         * </p>
         * This is a convenience that creates an instance of the {@link Identity.Builder} avoiding the need to create
         * one manually via {@link Identity#builder()}.
         *
         * When the {@link Consumer} completes, {@link Identity.Builder#build()} is called immediately and its result is
         * passed to {@link #sender(Identity)}.
         * 
         * @param sender
         *        a consumer that will call methods on {@link Identity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sender(Identity)
         */
        default Builder sender(Consumer<Identity.Builder> sender) {
            return sender(Identity.builder().applyMutation(sender).build());
        }

        /**
         * <p>
         * Hides the content of a message.
         * </p>
         * 
         * @param redacted
         *        Hides the content of a message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redacted(Boolean redacted);

        /**
         * <p>
         * The persistence setting for a channel message.
         * </p>
         * 
         * @param persistence
         *        The persistence setting for a channel message.
         * @see ChannelMessagePersistenceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelMessagePersistenceType
         */
        Builder persistence(String persistence);

        /**
         * <p>
         * The persistence setting for a channel message.
         * </p>
         * 
         * @param persistence
         *        The persistence setting for a channel message.
         * @see ChannelMessagePersistenceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelMessagePersistenceType
         */
        Builder persistence(ChannelMessagePersistenceType persistence);

        /**
         * <p>
         * The status of the channel message.
         * </p>
         * 
         * @param status
         *        The status of the channel message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(ChannelMessageStatusStructure status);

        /**
         * <p>
         * The status of the channel message.
         * </p>
         * This is a convenience that creates an instance of the {@link ChannelMessageStatusStructure.Builder} avoiding
         * the need to create one manually via {@link ChannelMessageStatusStructure#builder()}.
         *
         * When the {@link Consumer} completes, {@link ChannelMessageStatusStructure.Builder#build()} is called
         * immediately and its result is passed to {@link #status(ChannelMessageStatusStructure)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link ChannelMessageStatusStructure.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(ChannelMessageStatusStructure)
         */
        default Builder status(Consumer<ChannelMessageStatusStructure.Builder> status) {
            return status(ChannelMessageStatusStructure.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The attributes for the message, used for message filtering along with a <code>FilterRule</code> defined in
         * the <code>PushNotificationPreferences</code>.
         * </p>
         * 
         * @param messageAttributes
         *        The attributes for the message, used for message filtering along with a <code>FilterRule</code>
         *        defined in the <code>PushNotificationPreferences</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageAttributes(Map<String, MessageAttributeValue> messageAttributes);
    }

    static final class BuilderImpl implements Builder {
        private String channelArn;

        private String messageId;

        private String content;

        private String metadata;

        private String type;

        private Instant createdTimestamp;

        private Instant lastEditedTimestamp;

        private Instant lastUpdatedTimestamp;

        private Identity sender;

        private Boolean redacted;

        private String persistence;

        private ChannelMessageStatusStructure status;

        private Map<String, MessageAttributeValue> messageAttributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelMessage model) {
            channelArn(model.channelArn);
            messageId(model.messageId);
            content(model.content);
            metadata(model.metadata);
            type(model.type);
            createdTimestamp(model.createdTimestamp);
            lastEditedTimestamp(model.lastEditedTimestamp);
            lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            sender(model.sender);
            redacted(model.redacted);
            persistence(model.persistence);
            status(model.status);
            messageAttributes(model.messageAttributes);
        }

        public final String getChannelArn() {
            return channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        @Transient
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getMessageId() {
            return messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        @Transient
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        @Transient
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getMetadata() {
            return metadata;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        @Override
        @Transient
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(ChannelMessageType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        @Transient
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getLastEditedTimestamp() {
            return lastEditedTimestamp;
        }

        public final void setLastEditedTimestamp(Instant lastEditedTimestamp) {
            this.lastEditedTimestamp = lastEditedTimestamp;
        }

        @Override
        @Transient
        public final Builder lastEditedTimestamp(Instant lastEditedTimestamp) {
            this.lastEditedTimestamp = lastEditedTimestamp;
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        @Transient
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final Identity.Builder getSender() {
            return sender != null ? sender.toBuilder() : null;
        }

        public final void setSender(Identity.BuilderImpl sender) {
            this.sender = sender != null ? sender.build() : null;
        }

        @Override
        @Transient
        public final Builder sender(Identity sender) {
            this.sender = sender;
            return this;
        }

        public final Boolean getRedacted() {
            return redacted;
        }

        public final void setRedacted(Boolean redacted) {
            this.redacted = redacted;
        }

        @Override
        @Transient
        public final Builder redacted(Boolean redacted) {
            this.redacted = redacted;
            return this;
        }

        public final String getPersistence() {
            return persistence;
        }

        public final void setPersistence(String persistence) {
            this.persistence = persistence;
        }

        @Override
        @Transient
        public final Builder persistence(String persistence) {
            this.persistence = persistence;
            return this;
        }

        @Override
        @Transient
        public final Builder persistence(ChannelMessagePersistenceType persistence) {
            this.persistence(persistence == null ? null : persistence.toString());
            return this;
        }

        public final ChannelMessageStatusStructure.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(ChannelMessageStatusStructure.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        @Transient
        public final Builder status(ChannelMessageStatusStructure status) {
            this.status = status;
            return this;
        }

        public final Map<String, MessageAttributeValue.Builder> getMessageAttributes() {
            Map<String, MessageAttributeValue.Builder> result = MessageAttributeMapCopier.copyToBuilder(this.messageAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setMessageAttributes(Map<String, MessageAttributeValue.BuilderImpl> messageAttributes) {
            this.messageAttributes = MessageAttributeMapCopier.copyFromBuilder(messageAttributes);
        }

        @Override
        @Transient
        public final Builder messageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
            this.messageAttributes = MessageAttributeMapCopier.copy(messageAttributes);
            return this;
        }

        @Override
        public ChannelMessage build() {
            return new ChannelMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
