/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A processor's metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProcessorConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ProcessorConfiguration.Builder, ProcessorConfiguration> {
    private static final SdkField<LambdaConfiguration> LAMBDA_FIELD = SdkField
            .<LambdaConfiguration> builder(MarshallingType.SDK_POJO).memberName("Lambda")
            .getter(getter(ProcessorConfiguration::lambda)).setter(setter(Builder::lambda))
            .constructor(LambdaConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lambda").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAMBDA_FIELD));

    private static final long serialVersionUID = 1L;

    private final LambdaConfiguration lambda;

    private ProcessorConfiguration(BuilderImpl builder) {
        this.lambda = builder.lambda;
    }

    /**
     * <p>
     * Indicates that the processor is of type Lambda.
     * </p>
     * 
     * @return Indicates that the processor is of type Lambda.
     */
    public final LambdaConfiguration lambda() {
        return lambda;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lambda());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessorConfiguration)) {
            return false;
        }
        ProcessorConfiguration other = (ProcessorConfiguration) obj;
        return Objects.equals(lambda(), other.lambda());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProcessorConfiguration").add("Lambda", lambda()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Lambda":
            return Optional.ofNullable(clazz.cast(lambda()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProcessorConfiguration, T> g) {
        return obj -> g.apply((ProcessorConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProcessorConfiguration> {
        /**
         * <p>
         * Indicates that the processor is of type Lambda.
         * </p>
         * 
         * @param lambda
         *        Indicates that the processor is of type Lambda.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambda(LambdaConfiguration lambda);

        /**
         * <p>
         * Indicates that the processor is of type Lambda.
         * </p>
         * This is a convenience that creates an instance of the {@link LambdaConfiguration.Builder} avoiding the need
         * to create one manually via {@link LambdaConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link LambdaConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #lambda(LambdaConfiguration)}.
         * 
         * @param lambda
         *        a consumer that will call methods on {@link LambdaConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambda(LambdaConfiguration)
         */
        default Builder lambda(Consumer<LambdaConfiguration.Builder> lambda) {
            return lambda(LambdaConfiguration.builder().applyMutation(lambda).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LambdaConfiguration lambda;

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessorConfiguration model) {
            lambda(model.lambda);
        }

        public final LambdaConfiguration.Builder getLambda() {
            return lambda != null ? lambda.toBuilder() : null;
        }

        public final void setLambda(LambdaConfiguration.BuilderImpl lambda) {
            this.lambda = lambda != null ? lambda.build() : null;
        }

        @Override
        @Transient
        public final Builder lambda(LambdaConfiguration lambda) {
            this.lambda = lambda;
            return this;
        }

        @Override
        public ProcessorConfiguration build() {
            return new ProcessorConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
