/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a channel ban.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChannelBan implements SdkPojo, Serializable, ToCopyableBuilder<ChannelBan.Builder, ChannelBan> {
    private static final SdkField<Identity> MEMBER_FIELD = SdkField.<Identity> builder(MarshallingType.SDK_POJO)
            .memberName("Member").getter(getter(ChannelBan::member)).setter(setter(Builder::member))
            .constructor(Identity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Member").build()).build();

    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelArn").getter(getter(ChannelBan::channelArn)).setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelArn").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(ChannelBan::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<Identity> CREATED_BY_FIELD = SdkField.<Identity> builder(MarshallingType.SDK_POJO)
            .memberName("CreatedBy").getter(getter(ChannelBan::createdBy)).setter(setter(Builder::createdBy))
            .constructor(Identity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_FIELD,
            CHANNEL_ARN_FIELD, CREATED_TIMESTAMP_FIELD, CREATED_BY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Identity member;

    private final String channelArn;

    private final Instant createdTimestamp;

    private final Identity createdBy;

    private ChannelBan(BuilderImpl builder) {
        this.member = builder.member;
        this.channelArn = builder.channelArn;
        this.createdTimestamp = builder.createdTimestamp;
        this.createdBy = builder.createdBy;
    }

    /**
     * <p>
     * The member being banned from the channel.
     * </p>
     * 
     * @return The member being banned from the channel.
     */
    public final Identity member() {
        return member;
    }

    /**
     * <p>
     * The ARN of the channel from which a member is being banned.
     * </p>
     * 
     * @return The ARN of the channel from which a member is being banned.
     */
    public final String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * The time at which the ban was created.
     * </p>
     * 
     * @return The time at which the ban was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The <code>AppInstanceUser</code> who created the ban.
     * </p>
     * 
     * @return The <code>AppInstanceUser</code> who created the ban.
     */
    public final Identity createdBy() {
        return createdBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(member());
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelBan)) {
            return false;
        }
        ChannelBan other = (ChannelBan) obj;
        return Objects.equals(member(), other.member()) && Objects.equals(channelArn(), other.channelArn())
                && Objects.equals(createdTimestamp(), other.createdTimestamp()) && Objects.equals(createdBy(), other.createdBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChannelBan").add("Member", member()).add("ChannelArn", channelArn())
                .add("CreatedTimestamp", createdTimestamp()).add("CreatedBy", createdBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Member":
            return Optional.ofNullable(clazz.cast(member()));
        case "ChannelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChannelBan, T> g) {
        return obj -> g.apply((ChannelBan) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChannelBan> {
        /**
         * <p>
         * The member being banned from the channel.
         * </p>
         * 
         * @param member
         *        The member being banned from the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder member(Identity member);

        /**
         * <p>
         * The member being banned from the channel.
         * </p>
         * This is a convenience method that creates an instance of the {@link Identity.Builder} avoiding the need to
         * create one manually via {@link Identity#builder()}.
         *
         * When the {@link Consumer} completes, {@link Identity.Builder#build()} is called immediately and its result is
         * passed to {@link #member(Identity)}.
         * 
         * @param member
         *        a consumer that will call methods on {@link Identity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #member(Identity)
         */
        default Builder member(Consumer<Identity.Builder> member) {
            return member(Identity.builder().applyMutation(member).build());
        }

        /**
         * <p>
         * The ARN of the channel from which a member is being banned.
         * </p>
         * 
         * @param channelArn
         *        The ARN of the channel from which a member is being banned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * The time at which the ban was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The time at which the ban was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The <code>AppInstanceUser</code> who created the ban.
         * </p>
         * 
         * @param createdBy
         *        The <code>AppInstanceUser</code> who created the ban.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(Identity createdBy);

        /**
         * <p>
         * The <code>AppInstanceUser</code> who created the ban.
         * </p>
         * This is a convenience method that creates an instance of the {@link Identity.Builder} avoiding the need to
         * create one manually via {@link Identity#builder()}.
         *
         * When the {@link Consumer} completes, {@link Identity.Builder#build()} is called immediately and its result is
         * passed to {@link #createdBy(Identity)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link Identity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(Identity)
         */
        default Builder createdBy(Consumer<Identity.Builder> createdBy) {
            return createdBy(Identity.builder().applyMutation(createdBy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Identity member;

        private String channelArn;

        private Instant createdTimestamp;

        private Identity createdBy;

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelBan model) {
            member(model.member);
            channelArn(model.channelArn);
            createdTimestamp(model.createdTimestamp);
            createdBy(model.createdBy);
        }

        public final Identity.Builder getMember() {
            return member != null ? member.toBuilder() : null;
        }

        public final void setMember(Identity.BuilderImpl member) {
            this.member = member != null ? member.build() : null;
        }

        @Override
        public final Builder member(Identity member) {
            this.member = member;
            return this;
        }

        public final String getChannelArn() {
            return channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Identity.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(Identity.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(Identity createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        @Override
        public ChannelBan build() {
            return new ChannelBan(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
