/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListChannelMembershipsForAppInstanceUserResponse extends ChimeSdkMessagingResponse
        implements
        ToCopyableBuilder<ListChannelMembershipsForAppInstanceUserResponse.Builder, ListChannelMembershipsForAppInstanceUserResponse> {
    private static final SdkField<List<ChannelMembershipForAppInstanceUserSummary>> CHANNEL_MEMBERSHIPS_FIELD = SdkField
            .<List<ChannelMembershipForAppInstanceUserSummary>> builder(MarshallingType.LIST)
            .memberName("ChannelMemberships")
            .getter(getter(ListChannelMembershipsForAppInstanceUserResponse::channelMemberships))
            .setter(setter(Builder::channelMemberships))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelMemberships").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChannelMembershipForAppInstanceUserSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChannelMembershipForAppInstanceUserSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListChannelMembershipsForAppInstanceUserResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_MEMBERSHIPS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ChannelMembershipForAppInstanceUserSummary> channelMemberships;

    private final String nextToken;

    private ListChannelMembershipsForAppInstanceUserResponse(BuilderImpl builder) {
        super(builder);
        this.channelMemberships = builder.channelMemberships;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChannelMemberships property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasChannelMemberships() {
        return channelMemberships != null && !(channelMemberships instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The information for the requested channel memberships.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannelMemberships} method.
     * </p>
     * 
     * @return The information for the requested channel memberships.
     */
    public final List<ChannelMembershipForAppInstanceUserSummary> channelMemberships() {
        return channelMemberships;
    }

    /**
     * <p>
     * The token passed by previous API calls until all requested users are returned.
     * </p>
     * 
     * @return The token passed by previous API calls until all requested users are returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasChannelMemberships() ? channelMemberships() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChannelMembershipsForAppInstanceUserResponse)) {
            return false;
        }
        ListChannelMembershipsForAppInstanceUserResponse other = (ListChannelMembershipsForAppInstanceUserResponse) obj;
        return hasChannelMemberships() == other.hasChannelMemberships()
                && Objects.equals(channelMemberships(), other.channelMemberships())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListChannelMembershipsForAppInstanceUserResponse")
                .add("ChannelMemberships", hasChannelMemberships() ? channelMemberships() : null)
                .add("NextToken", nextToken() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelMemberships":
            return Optional.ofNullable(clazz.cast(channelMemberships()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListChannelMembershipsForAppInstanceUserResponse, T> g) {
        return obj -> g.apply((ListChannelMembershipsForAppInstanceUserResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMessagingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListChannelMembershipsForAppInstanceUserResponse> {
        /**
         * <p>
         * The information for the requested channel memberships.
         * </p>
         * 
         * @param channelMemberships
         *        The information for the requested channel memberships.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelMemberships(Collection<ChannelMembershipForAppInstanceUserSummary> channelMemberships);

        /**
         * <p>
         * The information for the requested channel memberships.
         * </p>
         * 
         * @param channelMemberships
         *        The information for the requested channel memberships.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelMemberships(ChannelMembershipForAppInstanceUserSummary... channelMemberships);

        /**
         * <p>
         * The information for the requested channel memberships.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <ChannelMembershipForAppInstanceUserSummary>.Builder} avoiding the need to create one manually via
         * {@link List<ChannelMembershipForAppInstanceUserSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ChannelMembershipForAppInstanceUserSummary>.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #channelMemberships(List<ChannelMembershipForAppInstanceUserSummary>)}.
         * 
         * @param channelMemberships
         *        a consumer that will call methods on {@link List<ChannelMembershipForAppInstanceUserSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelMemberships(List<ChannelMembershipForAppInstanceUserSummary>)
         */
        Builder channelMemberships(Consumer<ChannelMembershipForAppInstanceUserSummary.Builder>... channelMemberships);

        /**
         * <p>
         * The token passed by previous API calls until all requested users are returned.
         * </p>
         * 
         * @param nextToken
         *        The token passed by previous API calls until all requested users are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ChimeSdkMessagingResponse.BuilderImpl implements Builder {
        private List<ChannelMembershipForAppInstanceUserSummary> channelMemberships = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChannelMembershipsForAppInstanceUserResponse model) {
            super(model);
            channelMemberships(model.channelMemberships);
            nextToken(model.nextToken);
        }

        public final List<ChannelMembershipForAppInstanceUserSummary.Builder> getChannelMemberships() {
            List<ChannelMembershipForAppInstanceUserSummary.Builder> result = ChannelMembershipForAppInstanceUserSummaryListCopier
                    .copyToBuilder(this.channelMemberships);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannelMemberships(
                Collection<ChannelMembershipForAppInstanceUserSummary.BuilderImpl> channelMemberships) {
            this.channelMemberships = ChannelMembershipForAppInstanceUserSummaryListCopier.copyFromBuilder(channelMemberships);
        }

        @Override
        public final Builder channelMemberships(Collection<ChannelMembershipForAppInstanceUserSummary> channelMemberships) {
            this.channelMemberships = ChannelMembershipForAppInstanceUserSummaryListCopier.copy(channelMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelMemberships(ChannelMembershipForAppInstanceUserSummary... channelMemberships) {
            channelMemberships(Arrays.asList(channelMemberships));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelMemberships(
                Consumer<ChannelMembershipForAppInstanceUserSummary.Builder>... channelMemberships) {
            channelMemberships(Stream.of(channelMemberships)
                    .map(c -> ChannelMembershipForAppInstanceUserSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListChannelMembershipsForAppInstanceUserResponse build() {
            return new ListChannelMembershipsForAppInstanceUserResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
