/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListChannelMembershipsResponse extends ChimeSdkMessagingResponse implements
        ToCopyableBuilder<ListChannelMembershipsResponse.Builder, ListChannelMembershipsResponse> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelArn").getter(getter(ListChannelMembershipsResponse::channelArn))
            .setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelArn").build()).build();

    private static final SdkField<List<ChannelMembershipSummary>> CHANNEL_MEMBERSHIPS_FIELD = SdkField
            .<List<ChannelMembershipSummary>> builder(MarshallingType.LIST)
            .memberName("ChannelMemberships")
            .getter(getter(ListChannelMembershipsResponse::channelMemberships))
            .setter(setter(Builder::channelMemberships))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelMemberships").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChannelMembershipSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChannelMembershipSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListChannelMembershipsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD,
            CHANNEL_MEMBERSHIPS_FIELD, NEXT_TOKEN_FIELD));

    private final String channelArn;

    private final List<ChannelMembershipSummary> channelMemberships;

    private final String nextToken;

    private ListChannelMembershipsResponse(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.channelMemberships = builder.channelMemberships;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ARN of the channel.
     * </p>
     * 
     * @return The ARN of the channel.
     */
    public final String channelArn() {
        return channelArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChannelMemberships property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasChannelMemberships() {
        return channelMemberships != null && !(channelMemberships instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The information for the requested channel memberships.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannelMemberships} method.
     * </p>
     * 
     * @return The information for the requested channel memberships.
     */
    public final List<ChannelMembershipSummary> channelMemberships() {
        return channelMemberships;
    }

    /**
     * <p>
     * The token passed by previous API calls until all requested channel memberships are returned.
     * </p>
     * 
     * @return The token passed by previous API calls until all requested channel memberships are returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasChannelMemberships() ? channelMemberships() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChannelMembershipsResponse)) {
            return false;
        }
        ListChannelMembershipsResponse other = (ListChannelMembershipsResponse) obj;
        return Objects.equals(channelArn(), other.channelArn()) && hasChannelMemberships() == other.hasChannelMemberships()
                && Objects.equals(channelMemberships(), other.channelMemberships())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListChannelMembershipsResponse").add("ChannelArn", channelArn())
                .add("ChannelMemberships", hasChannelMemberships() ? channelMemberships() : null)
                .add("NextToken", nextToken() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "ChannelMemberships":
            return Optional.ofNullable(clazz.cast(channelMemberships()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListChannelMembershipsResponse, T> g) {
        return obj -> g.apply((ListChannelMembershipsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMessagingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListChannelMembershipsResponse> {
        /**
         * <p>
         * The ARN of the channel.
         * </p>
         * 
         * @param channelArn
         *        The ARN of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * The information for the requested channel memberships.
         * </p>
         * 
         * @param channelMemberships
         *        The information for the requested channel memberships.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelMemberships(Collection<ChannelMembershipSummary> channelMemberships);

        /**
         * <p>
         * The information for the requested channel memberships.
         * </p>
         * 
         * @param channelMemberships
         *        The information for the requested channel memberships.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelMemberships(ChannelMembershipSummary... channelMemberships);

        /**
         * <p>
         * The information for the requested channel memberships.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ChannelMembershipSummary>.Builder}
         * avoiding the need to create one manually via {@link List<ChannelMembershipSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ChannelMembershipSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #channelMemberships(List<ChannelMembershipSummary>)}.
         * 
         * @param channelMemberships
         *        a consumer that will call methods on {@link List<ChannelMembershipSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelMemberships(List<ChannelMembershipSummary>)
         */
        Builder channelMemberships(Consumer<ChannelMembershipSummary.Builder>... channelMemberships);

        /**
         * <p>
         * The token passed by previous API calls until all requested channel memberships are returned.
         * </p>
         * 
         * @param nextToken
         *        The token passed by previous API calls until all requested channel memberships are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ChimeSdkMessagingResponse.BuilderImpl implements Builder {
        private String channelArn;

        private List<ChannelMembershipSummary> channelMemberships = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChannelMembershipsResponse model) {
            super(model);
            channelArn(model.channelArn);
            channelMemberships(model.channelMemberships);
            nextToken(model.nextToken);
        }

        public final String getChannelArn() {
            return channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final List<ChannelMembershipSummary.Builder> getChannelMemberships() {
            List<ChannelMembershipSummary.Builder> result = ChannelMembershipSummaryListCopier
                    .copyToBuilder(this.channelMemberships);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannelMemberships(Collection<ChannelMembershipSummary.BuilderImpl> channelMemberships) {
            this.channelMemberships = ChannelMembershipSummaryListCopier.copyFromBuilder(channelMemberships);
        }

        @Override
        public final Builder channelMemberships(Collection<ChannelMembershipSummary> channelMemberships) {
            this.channelMemberships = ChannelMembershipSummaryListCopier.copy(channelMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelMemberships(ChannelMembershipSummary... channelMemberships) {
            channelMemberships(Arrays.asList(channelMemberships));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelMemberships(Consumer<ChannelMembershipSummary.Builder>... channelMemberships) {
            channelMemberships(Stream.of(channelMemberships)
                    .map(c -> ChannelMembershipSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListChannelMembershipsResponse build() {
            return new ListChannelMembershipsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
