/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary of details of a channel flow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChannelFlowSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ChannelFlowSummary.Builder, ChannelFlowSummary> {
    private static final SdkField<String> CHANNEL_FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelFlowArn").getter(getter(ChannelFlowSummary::channelFlowArn))
            .setter(setter(Builder::channelFlowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelFlowArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ChannelFlowSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<Processor>> PROCESSORS_FIELD = SdkField
            .<List<Processor>> builder(MarshallingType.LIST)
            .memberName("Processors")
            .getter(getter(ChannelFlowSummary::processors))
            .setter(setter(Builder::processors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Processors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Processor> builder(MarshallingType.SDK_POJO)
                                            .constructor(Processor::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_FLOW_ARN_FIELD,
            NAME_FIELD, PROCESSORS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String channelFlowArn;

    private final String name;

    private final List<Processor> processors;

    private ChannelFlowSummary(BuilderImpl builder) {
        this.channelFlowArn = builder.channelFlowArn;
        this.name = builder.name;
        this.processors = builder.processors;
    }

    /**
     * <p>
     * The ARN of the channel flow.
     * </p>
     * 
     * @return The ARN of the channel flow.
     */
    public final String channelFlowArn() {
        return channelFlowArn;
    }

    /**
     * <p>
     * The name of the channel flow.
     * </p>
     * 
     * @return The name of the channel flow.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Processors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProcessors() {
        return processors != null && !(processors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the processor Lambda functions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProcessors} method.
     * </p>
     * 
     * @return Information about the processor Lambda functions.
     */
    public final List<Processor> processors() {
        return processors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelFlowArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasProcessors() ? processors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelFlowSummary)) {
            return false;
        }
        ChannelFlowSummary other = (ChannelFlowSummary) obj;
        return Objects.equals(channelFlowArn(), other.channelFlowArn()) && Objects.equals(name(), other.name())
                && hasProcessors() == other.hasProcessors() && Objects.equals(processors(), other.processors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChannelFlowSummary").add("ChannelFlowArn", channelFlowArn())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Processors", hasProcessors() ? processors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelFlowArn":
            return Optional.ofNullable(clazz.cast(channelFlowArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Processors":
            return Optional.ofNullable(clazz.cast(processors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChannelFlowSummary, T> g) {
        return obj -> g.apply((ChannelFlowSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChannelFlowSummary> {
        /**
         * <p>
         * The ARN of the channel flow.
         * </p>
         * 
         * @param channelFlowArn
         *        The ARN of the channel flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelFlowArn(String channelFlowArn);

        /**
         * <p>
         * The name of the channel flow.
         * </p>
         * 
         * @param name
         *        The name of the channel flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Information about the processor Lambda functions.
         * </p>
         * 
         * @param processors
         *        Information about the processor Lambda functions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processors(Collection<Processor> processors);

        /**
         * <p>
         * Information about the processor Lambda functions.
         * </p>
         * 
         * @param processors
         *        Information about the processor Lambda functions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processors(Processor... processors);

        /**
         * <p>
         * Information about the processor Lambda functions.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Processor>.Builder} avoiding the
         * need to create one manually via {@link List<Processor>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Processor>.Builder#build()} is called immediately and its
         * result is passed to {@link #processors(List<Processor>)}.
         * 
         * @param processors
         *        a consumer that will call methods on {@link List<Processor>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processors(List<Processor>)
         */
        Builder processors(Consumer<Processor.Builder>... processors);
    }

    static final class BuilderImpl implements Builder {
        private String channelFlowArn;

        private String name;

        private List<Processor> processors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelFlowSummary model) {
            channelFlowArn(model.channelFlowArn);
            name(model.name);
            processors(model.processors);
        }

        public final String getChannelFlowArn() {
            return channelFlowArn;
        }

        public final void setChannelFlowArn(String channelFlowArn) {
            this.channelFlowArn = channelFlowArn;
        }

        @Override
        public final Builder channelFlowArn(String channelFlowArn) {
            this.channelFlowArn = channelFlowArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<Processor.Builder> getProcessors() {
            List<Processor.Builder> result = ProcessorListCopier.copyToBuilder(this.processors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProcessors(Collection<Processor.BuilderImpl> processors) {
            this.processors = ProcessorListCopier.copyFromBuilder(processors);
        }

        @Override
        public final Builder processors(Collection<Processor> processors) {
            this.processors = ProcessorListCopier.copy(processors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processors(Processor... processors) {
            processors(Arrays.asList(processors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processors(Consumer<Processor.Builder>... processors) {
            processors(Stream.of(processors).map(c -> Processor.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ChannelFlowSummary build() {
            return new ChannelFlowSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
