/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary of the details of a moderated channel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChannelModeratedByAppInstanceUserSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ChannelModeratedByAppInstanceUserSummary.Builder, ChannelModeratedByAppInstanceUserSummary> {
    private static final SdkField<ChannelSummary> CHANNEL_SUMMARY_FIELD = SdkField
            .<ChannelSummary> builder(MarshallingType.SDK_POJO).memberName("ChannelSummary")
            .getter(getter(ChannelModeratedByAppInstanceUserSummary::channelSummary)).setter(setter(Builder::channelSummary))
            .constructor(ChannelSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelSummary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_SUMMARY_FIELD));

    private static final long serialVersionUID = 1L;

    private final ChannelSummary channelSummary;

    private ChannelModeratedByAppInstanceUserSummary(BuilderImpl builder) {
        this.channelSummary = builder.channelSummary;
    }

    /**
     * <p>
     * Summary of the details of a <code>Channel</code>.
     * </p>
     * 
     * @return Summary of the details of a <code>Channel</code>.
     */
    public final ChannelSummary channelSummary() {
        return channelSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelModeratedByAppInstanceUserSummary)) {
            return false;
        }
        ChannelModeratedByAppInstanceUserSummary other = (ChannelModeratedByAppInstanceUserSummary) obj;
        return Objects.equals(channelSummary(), other.channelSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChannelModeratedByAppInstanceUserSummary").add("ChannelSummary", channelSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelSummary":
            return Optional.ofNullable(clazz.cast(channelSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChannelModeratedByAppInstanceUserSummary, T> g) {
        return obj -> g.apply((ChannelModeratedByAppInstanceUserSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChannelModeratedByAppInstanceUserSummary> {
        /**
         * <p>
         * Summary of the details of a <code>Channel</code>.
         * </p>
         * 
         * @param channelSummary
         *        Summary of the details of a <code>Channel</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelSummary(ChannelSummary channelSummary);

        /**
         * <p>
         * Summary of the details of a <code>Channel</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChannelSummary.Builder} avoiding the need
         * to create one manually via {@link ChannelSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link ChannelSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #channelSummary(ChannelSummary)}.
         * 
         * @param channelSummary
         *        a consumer that will call methods on {@link ChannelSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelSummary(ChannelSummary)
         */
        default Builder channelSummary(Consumer<ChannelSummary.Builder> channelSummary) {
            return channelSummary(ChannelSummary.builder().applyMutation(channelSummary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ChannelSummary channelSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelModeratedByAppInstanceUserSummary model) {
            channelSummary(model.channelSummary);
        }

        public final ChannelSummary.Builder getChannelSummary() {
            return channelSummary != null ? channelSummary.toBuilder() : null;
        }

        public final void setChannelSummary(ChannelSummary.BuilderImpl channelSummary) {
            this.channelSummary = channelSummary != null ? channelSummary.build() : null;
        }

        @Override
        public final Builder channelSummary(ChannelSummary channelSummary) {
            this.channelSummary = channelSummary;
            return this;
        }

        @Override
        public ChannelModeratedByAppInstanceUserSummary build() {
            return new ChannelModeratedByAppInstanceUserSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
