/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeChannelFlowResponse extends ChimeSdkMessagingResponse implements
        ToCopyableBuilder<DescribeChannelFlowResponse.Builder, DescribeChannelFlowResponse> {
    private static final SdkField<ChannelFlow> CHANNEL_FLOW_FIELD = SdkField.<ChannelFlow> builder(MarshallingType.SDK_POJO)
            .memberName("ChannelFlow").getter(getter(DescribeChannelFlowResponse::channelFlow))
            .setter(setter(Builder::channelFlow)).constructor(ChannelFlow::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelFlow").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_FLOW_FIELD));

    private final ChannelFlow channelFlow;

    private DescribeChannelFlowResponse(BuilderImpl builder) {
        super(builder);
        this.channelFlow = builder.channelFlow;
    }

    /**
     * <p>
     * The channel flow details.
     * </p>
     * 
     * @return The channel flow details.
     */
    public final ChannelFlow channelFlow() {
        return channelFlow;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelFlow());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeChannelFlowResponse)) {
            return false;
        }
        DescribeChannelFlowResponse other = (DescribeChannelFlowResponse) obj;
        return Objects.equals(channelFlow(), other.channelFlow());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeChannelFlowResponse").add("ChannelFlow", channelFlow()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelFlow":
            return Optional.ofNullable(clazz.cast(channelFlow()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeChannelFlowResponse, T> g) {
        return obj -> g.apply((DescribeChannelFlowResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMessagingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeChannelFlowResponse> {
        /**
         * <p>
         * The channel flow details.
         * </p>
         * 
         * @param channelFlow
         *        The channel flow details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelFlow(ChannelFlow channelFlow);

        /**
         * <p>
         * The channel flow details.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChannelFlow.Builder} avoiding the need to
         * create one manually via {@link ChannelFlow#builder()}.
         *
         * When the {@link Consumer} completes, {@link ChannelFlow.Builder#build()} is called immediately and its result
         * is passed to {@link #channelFlow(ChannelFlow)}.
         * 
         * @param channelFlow
         *        a consumer that will call methods on {@link ChannelFlow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelFlow(ChannelFlow)
         */
        default Builder channelFlow(Consumer<ChannelFlow.Builder> channelFlow) {
            return channelFlow(ChannelFlow.builder().applyMutation(channelFlow).build());
        }
    }

    static final class BuilderImpl extends ChimeSdkMessagingResponse.BuilderImpl implements Builder {
        private ChannelFlow channelFlow;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeChannelFlowResponse model) {
            super(model);
            channelFlow(model.channelFlow);
        }

        public final ChannelFlow.Builder getChannelFlow() {
            return channelFlow != null ? channelFlow.toBuilder() : null;
        }

        public final void setChannelFlow(ChannelFlow.BuilderImpl channelFlow) {
            this.channelFlow = channelFlow != null ? channelFlow.build() : null;
        }

        @Override
        public final Builder channelFlow(ChannelFlow channelFlow) {
            this.channelFlow = channelFlow;
            return this;
        }

        @Override
        public DescribeChannelFlowResponse build() {
            return new DescribeChannelFlowResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
