/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListChannelMessagesResponse extends ChimeSdkMessagingResponse implements
        ToCopyableBuilder<ListChannelMessagesResponse.Builder, ListChannelMessagesResponse> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelArn").getter(getter(ListChannelMessagesResponse::channelArn)).setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelArn").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListChannelMessagesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ChannelMessageSummary>> CHANNEL_MESSAGES_FIELD = SdkField
            .<List<ChannelMessageSummary>> builder(MarshallingType.LIST)
            .memberName("ChannelMessages")
            .getter(getter(ListChannelMessagesResponse::channelMessages))
            .setter(setter(Builder::channelMessages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelMessages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChannelMessageSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChannelMessageSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SUB_CHANNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubChannelId").getter(getter(ListChannelMessagesResponse::subChannelId))
            .setter(setter(Builder::subChannelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubChannelId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD,
            NEXT_TOKEN_FIELD, CHANNEL_MESSAGES_FIELD, SUB_CHANNEL_ID_FIELD));

    private final String channelArn;

    private final String nextToken;

    private final List<ChannelMessageSummary> channelMessages;

    private final String subChannelId;

    private ListChannelMessagesResponse(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.nextToken = builder.nextToken;
        this.channelMessages = builder.channelMessages;
        this.subChannelId = builder.subChannelId;
    }

    /**
     * <p>
     * The ARN of the channel containing the requested messages.
     * </p>
     * 
     * @return The ARN of the channel containing the requested messages.
     */
    public final String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * The token passed by previous API calls until all requested messages are returned.
     * </p>
     * 
     * @return The token passed by previous API calls until all requested messages are returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChannelMessages property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasChannelMessages() {
        return channelMessages != null && !(channelMessages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The information about, and content of, each requested message.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannelMessages} method.
     * </p>
     * 
     * @return The information about, and content of, each requested message.
     */
    public final List<ChannelMessageSummary> channelMessages() {
        return channelMessages;
    }

    /**
     * <p>
     * The ID of the SubChannel in the response.
     * </p>
     * 
     * @return The ID of the SubChannel in the response.
     */
    public final String subChannelId() {
        return subChannelId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasChannelMessages() ? channelMessages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(subChannelId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChannelMessagesResponse)) {
            return false;
        }
        ListChannelMessagesResponse other = (ListChannelMessagesResponse) obj;
        return Objects.equals(channelArn(), other.channelArn()) && Objects.equals(nextToken(), other.nextToken())
                && hasChannelMessages() == other.hasChannelMessages()
                && Objects.equals(channelMessages(), other.channelMessages())
                && Objects.equals(subChannelId(), other.subChannelId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListChannelMessagesResponse").add("ChannelArn", channelArn())
                .add("NextToken", nextToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ChannelMessages", hasChannelMessages() ? channelMessages() : null).add("SubChannelId", subChannelId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ChannelMessages":
            return Optional.ofNullable(clazz.cast(channelMessages()));
        case "SubChannelId":
            return Optional.ofNullable(clazz.cast(subChannelId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListChannelMessagesResponse, T> g) {
        return obj -> g.apply((ListChannelMessagesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMessagingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListChannelMessagesResponse> {
        /**
         * <p>
         * The ARN of the channel containing the requested messages.
         * </p>
         * 
         * @param channelArn
         *        The ARN of the channel containing the requested messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * The token passed by previous API calls until all requested messages are returned.
         * </p>
         * 
         * @param nextToken
         *        The token passed by previous API calls until all requested messages are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The information about, and content of, each requested message.
         * </p>
         * 
         * @param channelMessages
         *        The information about, and content of, each requested message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelMessages(Collection<ChannelMessageSummary> channelMessages);

        /**
         * <p>
         * The information about, and content of, each requested message.
         * </p>
         * 
         * @param channelMessages
         *        The information about, and content of, each requested message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelMessages(ChannelMessageSummary... channelMessages);

        /**
         * <p>
         * The information about, and content of, each requested message.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ChannelMessageSummary>.Builder}
         * avoiding the need to create one manually via {@link List<ChannelMessageSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ChannelMessageSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #channelMessages(List<ChannelMessageSummary>)}.
         * 
         * @param channelMessages
         *        a consumer that will call methods on {@link List<ChannelMessageSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelMessages(List<ChannelMessageSummary>)
         */
        Builder channelMessages(Consumer<ChannelMessageSummary.Builder>... channelMessages);

        /**
         * <p>
         * The ID of the SubChannel in the response.
         * </p>
         * 
         * @param subChannelId
         *        The ID of the SubChannel in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subChannelId(String subChannelId);
    }

    static final class BuilderImpl extends ChimeSdkMessagingResponse.BuilderImpl implements Builder {
        private String channelArn;

        private String nextToken;

        private List<ChannelMessageSummary> channelMessages = DefaultSdkAutoConstructList.getInstance();

        private String subChannelId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChannelMessagesResponse model) {
            super(model);
            channelArn(model.channelArn);
            nextToken(model.nextToken);
            channelMessages(model.channelMessages);
            subChannelId(model.subChannelId);
        }

        public final String getChannelArn() {
            return channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ChannelMessageSummary.Builder> getChannelMessages() {
            List<ChannelMessageSummary.Builder> result = ChannelMessageSummaryListCopier.copyToBuilder(this.channelMessages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannelMessages(Collection<ChannelMessageSummary.BuilderImpl> channelMessages) {
            this.channelMessages = ChannelMessageSummaryListCopier.copyFromBuilder(channelMessages);
        }

        @Override
        public final Builder channelMessages(Collection<ChannelMessageSummary> channelMessages) {
            this.channelMessages = ChannelMessageSummaryListCopier.copy(channelMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelMessages(ChannelMessageSummary... channelMessages) {
            channelMessages(Arrays.asList(channelMessages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelMessages(Consumer<ChannelMessageSummary.Builder>... channelMessages) {
            channelMessages(Stream.of(channelMessages).map(c -> ChannelMessageSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSubChannelId() {
            return subChannelId;
        }

        public final void setSubChannelId(String subChannelId) {
            this.subChannelId = subChannelId;
        }

        @Override
        public final Builder subChannelId(String subChannelId) {
            this.subChannelId = subChannelId;
            return this;
        }

        @Override
        public ListChannelMessagesResponse build() {
            return new ListChannelMessagesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
