/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateChannelMembershipRequest extends ChimeSdkMessagingRequest implements
        ToCopyableBuilder<CreateChannelMembershipRequest.Builder, CreateChannelMembershipRequest> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelArn").getter(getter(CreateChannelMembershipRequest::channelArn))
            .setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelArn").build()).build();

    private static final SdkField<String> MEMBER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MemberArn").getter(getter(CreateChannelMembershipRequest::memberArn)).setter(setter(Builder::memberArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberArn").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(CreateChannelMembershipRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> CHIME_BEARER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChimeBearer").getter(getter(CreateChannelMembershipRequest::chimeBearer))
            .setter(setter(Builder::chimeBearer))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-chime-bearer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD,
            MEMBER_ARN_FIELD, TYPE_FIELD, CHIME_BEARER_FIELD));

    private final String channelArn;

    private final String memberArn;

    private final String type;

    private final String chimeBearer;

    private CreateChannelMembershipRequest(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.memberArn = builder.memberArn;
        this.type = builder.type;
        this.chimeBearer = builder.chimeBearer;
    }

    /**
     * <p>
     * The ARN of the channel to which you're adding users.
     * </p>
     * 
     * @return The ARN of the channel to which you're adding users.
     */
    public final String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * The ARN of the member you want to add to the channel.
     * </p>
     * 
     * @return The ARN of the member you want to add to the channel.
     */
    public final String memberArn() {
        return memberArn;
    }

    /**
     * <p>
     * The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned
     * as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in
     * <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This
     * is only supported by moderators.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChannelMembershipType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always
     *         returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type
     *         filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are
     *         not returned. This is only supported by moderators.
     * @see ChannelMembershipType
     */
    public final ChannelMembershipType type() {
        return ChannelMembershipType.fromValue(type);
    }

    /**
     * <p>
     * The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned
     * as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in
     * <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This
     * is only supported by moderators.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChannelMembershipType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always
     *         returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type
     *         filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are
     *         not returned. This is only supported by moderators.
     * @see ChannelMembershipType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The <code>AppInstanceUserArn</code> of the user that makes the API call.
     * </p>
     * 
     * @return The <code>AppInstanceUserArn</code> of the user that makes the API call.
     */
    public final String chimeBearer() {
        return chimeBearer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(memberArn());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(chimeBearer());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChannelMembershipRequest)) {
            return false;
        }
        CreateChannelMembershipRequest other = (CreateChannelMembershipRequest) obj;
        return Objects.equals(channelArn(), other.channelArn()) && Objects.equals(memberArn(), other.memberArn())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(chimeBearer(), other.chimeBearer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateChannelMembershipRequest").add("ChannelArn", channelArn()).add("MemberArn", memberArn())
                .add("Type", typeAsString()).add("ChimeBearer", chimeBearer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "MemberArn":
            return Optional.ofNullable(clazz.cast(memberArn()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ChimeBearer":
            return Optional.ofNullable(clazz.cast(chimeBearer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateChannelMembershipRequest, T> g) {
        return obj -> g.apply((CreateChannelMembershipRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMessagingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateChannelMembershipRequest> {
        /**
         * <p>
         * The ARN of the channel to which you're adding users.
         * </p>
         * 
         * @param channelArn
         *        The ARN of the channel to which you're adding users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * The ARN of the member you want to add to the channel.
         * </p>
         * 
         * @param memberArn
         *        The ARN of the member you want to add to the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberArn(String memberArn);

        /**
         * <p>
         * The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always
         * returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter
         * in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned.
         * This is only supported by moderators.
         * </p>
         * 
         * @param type
         *        The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always
         *        returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type
         *        filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are
         *        not returned. This is only supported by moderators.
         * @see ChannelMembershipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelMembershipType
         */
        Builder type(String type);

        /**
         * <p>
         * The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always
         * returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter
         * in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned.
         * This is only supported by moderators.
         * </p>
         * 
         * @param type
         *        The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always
         *        returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type
         *        filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are
         *        not returned. This is only supported by moderators.
         * @see ChannelMembershipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelMembershipType
         */
        Builder type(ChannelMembershipType type);

        /**
         * <p>
         * The <code>AppInstanceUserArn</code> of the user that makes the API call.
         * </p>
         * 
         * @param chimeBearer
         *        The <code>AppInstanceUserArn</code> of the user that makes the API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chimeBearer(String chimeBearer);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkMessagingRequest.BuilderImpl implements Builder {
        private String channelArn;

        private String memberArn;

        private String type;

        private String chimeBearer;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChannelMembershipRequest model) {
            super(model);
            channelArn(model.channelArn);
            memberArn(model.memberArn);
            type(model.type);
            chimeBearer(model.chimeBearer);
        }

        public final String getChannelArn() {
            return channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        @Transient
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getMemberArn() {
            return memberArn;
        }

        public final void setMemberArn(String memberArn) {
            this.memberArn = memberArn;
        }

        @Override
        @Transient
        public final Builder memberArn(String memberArn) {
            this.memberArn = memberArn;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(ChannelMembershipType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getChimeBearer() {
            return chimeBearer;
        }

        public final void setChimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
        }

        @Override
        @Transient
        public final Builder chimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateChannelMembershipRequest build() {
            return new CreateChannelMembershipRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
