/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateChannelModeratorResponse extends ChimeSdkMessagingResponse implements
        ToCopyableBuilder<CreateChannelModeratorResponse.Builder, CreateChannelModeratorResponse> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelArn").getter(getter(CreateChannelModeratorResponse::channelArn))
            .setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelArn").build()).build();

    private static final SdkField<Identity> CHANNEL_MODERATOR_FIELD = SdkField.<Identity> builder(MarshallingType.SDK_POJO)
            .memberName("ChannelModerator").getter(getter(CreateChannelModeratorResponse::channelModerator))
            .setter(setter(Builder::channelModerator)).constructor(Identity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelModerator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD,
            CHANNEL_MODERATOR_FIELD));

    private final String channelArn;

    private final Identity channelModerator;

    private CreateChannelModeratorResponse(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.channelModerator = builder.channelModerator;
    }

    /**
     * <p>
     * The ARN of the channel.
     * </p>
     * 
     * @return The ARN of the channel.
     */
    public final String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * The ARNs of the channel and the moderator.
     * </p>
     * 
     * @return The ARNs of the channel and the moderator.
     */
    public final Identity channelModerator() {
        return channelModerator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(channelModerator());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChannelModeratorResponse)) {
            return false;
        }
        CreateChannelModeratorResponse other = (CreateChannelModeratorResponse) obj;
        return Objects.equals(channelArn(), other.channelArn()) && Objects.equals(channelModerator(), other.channelModerator());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateChannelModeratorResponse").add("ChannelArn", channelArn())
                .add("ChannelModerator", channelModerator()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "ChannelModerator":
            return Optional.ofNullable(clazz.cast(channelModerator()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateChannelModeratorResponse, T> g) {
        return obj -> g.apply((CreateChannelModeratorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMessagingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateChannelModeratorResponse> {
        /**
         * <p>
         * The ARN of the channel.
         * </p>
         * 
         * @param channelArn
         *        The ARN of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * The ARNs of the channel and the moderator.
         * </p>
         * 
         * @param channelModerator
         *        The ARNs of the channel and the moderator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelModerator(Identity channelModerator);

        /**
         * <p>
         * The ARNs of the channel and the moderator.
         * </p>
         * This is a convenience that creates an instance of the {@link Identity.Builder} avoiding the need to create
         * one manually via {@link Identity#builder()}.
         *
         * When the {@link Consumer} completes, {@link Identity.Builder#build()} is called immediately and its result is
         * passed to {@link #channelModerator(Identity)}.
         * 
         * @param channelModerator
         *        a consumer that will call methods on {@link Identity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelModerator(Identity)
         */
        default Builder channelModerator(Consumer<Identity.Builder> channelModerator) {
            return channelModerator(Identity.builder().applyMutation(channelModerator).build());
        }
    }

    static final class BuilderImpl extends ChimeSdkMessagingResponse.BuilderImpl implements Builder {
        private String channelArn;

        private Identity channelModerator;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChannelModeratorResponse model) {
            super(model);
            channelArn(model.channelArn);
            channelModerator(model.channelModerator);
        }

        public final String getChannelArn() {
            return channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        @Transient
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final Identity.Builder getChannelModerator() {
            return channelModerator != null ? channelModerator.toBuilder() : null;
        }

        public final void setChannelModerator(Identity.BuilderImpl channelModerator) {
            this.channelModerator = channelModerator != null ? channelModerator.build() : null;
        }

        @Override
        @Transient
        public final Builder channelModerator(Identity channelModerator) {
            this.channelModerator = channelModerator;
            return this;
        }

        @Override
        public CreateChannelModeratorResponse build() {
            return new CreateChannelModeratorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
