/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListChannelBansResponse extends ChimeSdkMessagingResponse implements
        ToCopyableBuilder<ListChannelBansResponse.Builder, ListChannelBansResponse> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelArn").getter(getter(ListChannelBansResponse::channelArn)).setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelArn").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListChannelBansResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ChannelBanSummary>> CHANNEL_BANS_FIELD = SdkField
            .<List<ChannelBanSummary>> builder(MarshallingType.LIST)
            .memberName("ChannelBans")
            .getter(getter(ListChannelBansResponse::channelBans))
            .setter(setter(Builder::channelBans))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelBans").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChannelBanSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChannelBanSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD,
            NEXT_TOKEN_FIELD, CHANNEL_BANS_FIELD));

    private final String channelArn;

    private final String nextToken;

    private final List<ChannelBanSummary> channelBans;

    private ListChannelBansResponse(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.nextToken = builder.nextToken;
        this.channelBans = builder.channelBans;
    }

    /**
     * <p>
     * The ARN of the channel.
     * </p>
     * 
     * @return The ARN of the channel.
     */
    public final String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * The token passed by previous API calls until all requested bans are returned.
     * </p>
     * 
     * @return The token passed by previous API calls until all requested bans are returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChannelBans property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasChannelBans() {
        return channelBans != null && !(channelBans instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The information for each requested ban.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannelBans} method.
     * </p>
     * 
     * @return The information for each requested ban.
     */
    public final List<ChannelBanSummary> channelBans() {
        return channelBans;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasChannelBans() ? channelBans() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChannelBansResponse)) {
            return false;
        }
        ListChannelBansResponse other = (ListChannelBansResponse) obj;
        return Objects.equals(channelArn(), other.channelArn()) && Objects.equals(nextToken(), other.nextToken())
                && hasChannelBans() == other.hasChannelBans() && Objects.equals(channelBans(), other.channelBans());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListChannelBansResponse").add("ChannelArn", channelArn())
                .add("NextToken", nextToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ChannelBans", hasChannelBans() ? channelBans() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ChannelBans":
            return Optional.ofNullable(clazz.cast(channelBans()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListChannelBansResponse, T> g) {
        return obj -> g.apply((ListChannelBansResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMessagingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListChannelBansResponse> {
        /**
         * <p>
         * The ARN of the channel.
         * </p>
         * 
         * @param channelArn
         *        The ARN of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * The token passed by previous API calls until all requested bans are returned.
         * </p>
         * 
         * @param nextToken
         *        The token passed by previous API calls until all requested bans are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The information for each requested ban.
         * </p>
         * 
         * @param channelBans
         *        The information for each requested ban.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelBans(Collection<ChannelBanSummary> channelBans);

        /**
         * <p>
         * The information for each requested ban.
         * </p>
         * 
         * @param channelBans
         *        The information for each requested ban.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelBans(ChannelBanSummary... channelBans);

        /**
         * <p>
         * The information for each requested ban.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ChannelBanSummary>.Builder} avoiding the
         * need to create one manually via {@link List<ChannelBanSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ChannelBanSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #channelBans(List<ChannelBanSummary>)}.
         * 
         * @param channelBans
         *        a consumer that will call methods on {@link List<ChannelBanSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelBans(List<ChannelBanSummary>)
         */
        Builder channelBans(Consumer<ChannelBanSummary.Builder>... channelBans);
    }

    static final class BuilderImpl extends ChimeSdkMessagingResponse.BuilderImpl implements Builder {
        private String channelArn;

        private String nextToken;

        private List<ChannelBanSummary> channelBans = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListChannelBansResponse model) {
            super(model);
            channelArn(model.channelArn);
            nextToken(model.nextToken);
            channelBans(model.channelBans);
        }

        public final String getChannelArn() {
            return channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        @Transient
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ChannelBanSummary.Builder> getChannelBans() {
            List<ChannelBanSummary.Builder> result = ChannelBanSummaryListCopier.copyToBuilder(this.channelBans);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannelBans(Collection<ChannelBanSummary.BuilderImpl> channelBans) {
            this.channelBans = ChannelBanSummaryListCopier.copyFromBuilder(channelBans);
        }

        @Override
        @Transient
        public final Builder channelBans(Collection<ChannelBanSummary> channelBans) {
            this.channelBans = ChannelBanSummaryListCopier.copy(channelBans);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder channelBans(ChannelBanSummary... channelBans) {
            channelBans(Arrays.asList(channelBans));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder channelBans(Consumer<ChannelBanSummary.Builder>... channelBans) {
            channelBans(Stream.of(channelBans).map(c -> ChannelBanSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListChannelBansResponse build() {
            return new ListChannelBansResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
