/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateChannelMessageResponse extends ChimeSdkMessagingResponse implements
        ToCopyableBuilder<UpdateChannelMessageResponse.Builder, UpdateChannelMessageResponse> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelArn").getter(getter(UpdateChannelMessageResponse::channelArn))
            .setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelArn").build()).build();

    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageId").getter(getter(UpdateChannelMessageResponse::messageId)).setter(setter(Builder::messageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageId").build()).build();

    private static final SdkField<ChannelMessageStatusStructure> STATUS_FIELD = SdkField
            .<ChannelMessageStatusStructure> builder(MarshallingType.SDK_POJO).memberName("Status")
            .getter(getter(UpdateChannelMessageResponse::status)).setter(setter(Builder::status))
            .constructor(ChannelMessageStatusStructure::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD,
            MESSAGE_ID_FIELD, STATUS_FIELD));

    private final String channelArn;

    private final String messageId;

    private final ChannelMessageStatusStructure status;

    private UpdateChannelMessageResponse(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.messageId = builder.messageId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ARN of the channel.
     * </p>
     * 
     * @return The ARN of the channel.
     */
    public final String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * The ID string of the message being updated.
     * </p>
     * 
     * @return The ID string of the message being updated.
     */
    public final String messageId() {
        return messageId;
    }

    /**
     * <p>
     * The status of the message update.
     * </p>
     * 
     * @return The status of the message update.
     */
    public final ChannelMessageStatusStructure status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(messageId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateChannelMessageResponse)) {
            return false;
        }
        UpdateChannelMessageResponse other = (UpdateChannelMessageResponse) obj;
        return Objects.equals(channelArn(), other.channelArn()) && Objects.equals(messageId(), other.messageId())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateChannelMessageResponse").add("ChannelArn", channelArn()).add("MessageId", messageId())
                .add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "MessageId":
            return Optional.ofNullable(clazz.cast(messageId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateChannelMessageResponse, T> g) {
        return obj -> g.apply((UpdateChannelMessageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMessagingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateChannelMessageResponse> {
        /**
         * <p>
         * The ARN of the channel.
         * </p>
         * 
         * @param channelArn
         *        The ARN of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * The ID string of the message being updated.
         * </p>
         * 
         * @param messageId
         *        The ID string of the message being updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageId(String messageId);

        /**
         * <p>
         * The status of the message update.
         * </p>
         * 
         * @param status
         *        The status of the message update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(ChannelMessageStatusStructure status);

        /**
         * <p>
         * The status of the message update.
         * </p>
         * This is a convenience that creates an instance of the {@link ChannelMessageStatusStructure.Builder} avoiding
         * the need to create one manually via {@link ChannelMessageStatusStructure#builder()}.
         *
         * When the {@link Consumer} completes, {@link ChannelMessageStatusStructure.Builder#build()} is called
         * immediately and its result is passed to {@link #status(ChannelMessageStatusStructure)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link ChannelMessageStatusStructure.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(ChannelMessageStatusStructure)
         */
        default Builder status(Consumer<ChannelMessageStatusStructure.Builder> status) {
            return status(ChannelMessageStatusStructure.builder().applyMutation(status).build());
        }
    }

    static final class BuilderImpl extends ChimeSdkMessagingResponse.BuilderImpl implements Builder {
        private String channelArn;

        private String messageId;

        private ChannelMessageStatusStructure status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateChannelMessageResponse model) {
            super(model);
            channelArn(model.channelArn);
            messageId(model.messageId);
            status(model.status);
        }

        public final String getChannelArn() {
            return channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        @Transient
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getMessageId() {
            return messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        @Transient
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final ChannelMessageStatusStructure.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(ChannelMessageStatusStructure.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        @Transient
        public final Builder status(ChannelMessageStatusStructure status) {
            this.status = status;
            return this;
        }

        @Override
        public UpdateChannelMessageResponse build() {
            return new UpdateChannelMessageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
