/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChannelFlowCallbackResponse extends ChimeSdkMessagingResponse implements
        ToCopyableBuilder<ChannelFlowCallbackResponse.Builder, ChannelFlowCallbackResponse> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelArn").getter(getter(ChannelFlowCallbackResponse::channelArn)).setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelArn").build()).build();

    private static final SdkField<String> CALLBACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CallbackId").getter(getter(ChannelFlowCallbackResponse::callbackId)).setter(setter(Builder::callbackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallbackId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD,
            CALLBACK_ID_FIELD));

    private final String channelArn;

    private final String callbackId;

    private ChannelFlowCallbackResponse(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.callbackId = builder.callbackId;
    }

    /**
     * <p>
     * The ARN of the channel.
     * </p>
     * 
     * @return The ARN of the channel.
     */
    public final String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * The call back ID passed in the request.
     * </p>
     * 
     * @return The call back ID passed in the request.
     */
    public final String callbackId() {
        return callbackId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(callbackId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelFlowCallbackResponse)) {
            return false;
        }
        ChannelFlowCallbackResponse other = (ChannelFlowCallbackResponse) obj;
        return Objects.equals(channelArn(), other.channelArn()) && Objects.equals(callbackId(), other.callbackId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChannelFlowCallbackResponse").add("ChannelArn", channelArn()).add("CallbackId", callbackId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "CallbackId":
            return Optional.ofNullable(clazz.cast(callbackId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChannelFlowCallbackResponse, T> g) {
        return obj -> g.apply((ChannelFlowCallbackResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMessagingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ChannelFlowCallbackResponse> {
        /**
         * <p>
         * The ARN of the channel.
         * </p>
         * 
         * @param channelArn
         *        The ARN of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * The call back ID passed in the request.
         * </p>
         * 
         * @param callbackId
         *        The call back ID passed in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callbackId(String callbackId);
    }

    static final class BuilderImpl extends ChimeSdkMessagingResponse.BuilderImpl implements Builder {
        private String channelArn;

        private String callbackId;

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelFlowCallbackResponse model) {
            super(model);
            channelArn(model.channelArn);
            callbackId(model.callbackId);
        }

        public final String getChannelArn() {
            return channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        @Transient
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getCallbackId() {
            return callbackId;
        }

        public final void setCallbackId(String callbackId) {
            this.callbackId = callbackId;
        }

        @Override
        @Transient
        public final Builder callbackId(String callbackId) {
            this.callbackId = callbackId;
            return this;
        }

        @Override
        public ChannelFlowCallbackResponse build() {
            return new ChannelFlowCallbackResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
