/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The channel membership preferences for an <code>AppInstanceUser</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChannelMembershipPreferences implements SdkPojo, Serializable,
        ToCopyableBuilder<ChannelMembershipPreferences.Builder, ChannelMembershipPreferences> {
    private static final SdkField<PushNotificationPreferences> PUSH_NOTIFICATIONS_FIELD = SdkField
            .<PushNotificationPreferences> builder(MarshallingType.SDK_POJO).memberName("PushNotifications")
            .getter(getter(ChannelMembershipPreferences::pushNotifications)).setter(setter(Builder::pushNotifications))
            .constructor(PushNotificationPreferences::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PushNotifications").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUSH_NOTIFICATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final PushNotificationPreferences pushNotifications;

    private ChannelMembershipPreferences(BuilderImpl builder) {
        this.pushNotifications = builder.pushNotifications;
    }

    /**
     * <p>
     * The push notification configuration of a message.
     * </p>
     * 
     * @return The push notification configuration of a message.
     */
    public final PushNotificationPreferences pushNotifications() {
        return pushNotifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pushNotifications());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelMembershipPreferences)) {
            return false;
        }
        ChannelMembershipPreferences other = (ChannelMembershipPreferences) obj;
        return Objects.equals(pushNotifications(), other.pushNotifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChannelMembershipPreferences").add("PushNotifications", pushNotifications()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PushNotifications":
            return Optional.ofNullable(clazz.cast(pushNotifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChannelMembershipPreferences, T> g) {
        return obj -> g.apply((ChannelMembershipPreferences) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChannelMembershipPreferences> {
        /**
         * <p>
         * The push notification configuration of a message.
         * </p>
         * 
         * @param pushNotifications
         *        The push notification configuration of a message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pushNotifications(PushNotificationPreferences pushNotifications);

        /**
         * <p>
         * The push notification configuration of a message.
         * </p>
         * This is a convenience that creates an instance of the {@link PushNotificationPreferences.Builder} avoiding
         * the need to create one manually via {@link PushNotificationPreferences#builder()}.
         *
         * When the {@link Consumer} completes, {@link PushNotificationPreferences.Builder#build()} is called
         * immediately and its result is passed to {@link #pushNotifications(PushNotificationPreferences)}.
         * 
         * @param pushNotifications
         *        a consumer that will call methods on {@link PushNotificationPreferences.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pushNotifications(PushNotificationPreferences)
         */
        default Builder pushNotifications(Consumer<PushNotificationPreferences.Builder> pushNotifications) {
            return pushNotifications(PushNotificationPreferences.builder().applyMutation(pushNotifications).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PushNotificationPreferences pushNotifications;

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelMembershipPreferences model) {
            pushNotifications(model.pushNotifications);
        }

        public final PushNotificationPreferences.Builder getPushNotifications() {
            return pushNotifications != null ? pushNotifications.toBuilder() : null;
        }

        public final void setPushNotifications(PushNotificationPreferences.BuilderImpl pushNotifications) {
            this.pushNotifications = pushNotifications != null ? pushNotifications.build() : null;
        }

        @Override
        @Transient
        public final Builder pushNotifications(PushNotificationPreferences pushNotifications) {
            this.pushNotifications = pushNotifications;
            return this;
        }

        @Override
        public ChannelMembershipPreferences build() {
            return new ChannelMembershipPreferences(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
