/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The channel membership preferences for push notification.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PushNotificationPreferences implements SdkPojo, Serializable,
        ToCopyableBuilder<PushNotificationPreferences.Builder, PushNotificationPreferences> {
    private static final SdkField<String> ALLOW_NOTIFICATIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AllowNotifications").getter(getter(PushNotificationPreferences::allowNotificationsAsString))
            .setter(setter(Builder::allowNotifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowNotifications").build())
            .build();

    private static final SdkField<String> FILTER_RULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterRule").getter(getter(PushNotificationPreferences::filterRule)).setter(setter(Builder::filterRule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterRule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_NOTIFICATIONS_FIELD,
            FILTER_RULE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String allowNotifications;

    private final String filterRule;

    private PushNotificationPreferences(BuilderImpl builder) {
        this.allowNotifications = builder.allowNotifications;
        this.filterRule = builder.filterRule;
    }

    /**
     * <p>
     * Enum value that indicates which push notifications to send to the requested member of a channel. <code>ALL</code>
     * sends all push notifications, <code>NONE</code> sends no push notifications, <code>FILTERED</code> sends only
     * filtered push notifications.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #allowNotifications} will return {@link AllowNotifications#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #allowNotificationsAsString}.
     * </p>
     * 
     * @return Enum value that indicates which push notifications to send to the requested member of a channel.
     *         <code>ALL</code> sends all push notifications, <code>NONE</code> sends no push notifications,
     *         <code>FILTERED</code> sends only filtered push notifications.
     * @see AllowNotifications
     */
    public final AllowNotifications allowNotifications() {
        return AllowNotifications.fromValue(allowNotifications);
    }

    /**
     * <p>
     * Enum value that indicates which push notifications to send to the requested member of a channel. <code>ALL</code>
     * sends all push notifications, <code>NONE</code> sends no push notifications, <code>FILTERED</code> sends only
     * filtered push notifications.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #allowNotifications} will return {@link AllowNotifications#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #allowNotificationsAsString}.
     * </p>
     * 
     * @return Enum value that indicates which push notifications to send to the requested member of a channel.
     *         <code>ALL</code> sends all push notifications, <code>NONE</code> sends no push notifications,
     *         <code>FILTERED</code> sends only filtered push notifications.
     * @see AllowNotifications
     */
    public final String allowNotificationsAsString() {
        return allowNotifications;
    }

    /**
     * <p>
     * The simple JSON object used to send a subset of a push notification to the requsted member.
     * </p>
     * 
     * @return The simple JSON object used to send a subset of a push notification to the requsted member.
     */
    public final String filterRule() {
        return filterRule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowNotificationsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filterRule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PushNotificationPreferences)) {
            return false;
        }
        PushNotificationPreferences other = (PushNotificationPreferences) obj;
        return Objects.equals(allowNotificationsAsString(), other.allowNotificationsAsString())
                && Objects.equals(filterRule(), other.filterRule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PushNotificationPreferences").add("AllowNotifications", allowNotificationsAsString())
                .add("FilterRule", filterRule() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllowNotifications":
            return Optional.ofNullable(clazz.cast(allowNotificationsAsString()));
        case "FilterRule":
            return Optional.ofNullable(clazz.cast(filterRule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PushNotificationPreferences, T> g) {
        return obj -> g.apply((PushNotificationPreferences) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PushNotificationPreferences> {
        /**
         * <p>
         * Enum value that indicates which push notifications to send to the requested member of a channel.
         * <code>ALL</code> sends all push notifications, <code>NONE</code> sends no push notifications,
         * <code>FILTERED</code> sends only filtered push notifications.
         * </p>
         * 
         * @param allowNotifications
         *        Enum value that indicates which push notifications to send to the requested member of a channel.
         *        <code>ALL</code> sends all push notifications, <code>NONE</code> sends no push notifications,
         *        <code>FILTERED</code> sends only filtered push notifications.
         * @see AllowNotifications
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllowNotifications
         */
        Builder allowNotifications(String allowNotifications);

        /**
         * <p>
         * Enum value that indicates which push notifications to send to the requested member of a channel.
         * <code>ALL</code> sends all push notifications, <code>NONE</code> sends no push notifications,
         * <code>FILTERED</code> sends only filtered push notifications.
         * </p>
         * 
         * @param allowNotifications
         *        Enum value that indicates which push notifications to send to the requested member of a channel.
         *        <code>ALL</code> sends all push notifications, <code>NONE</code> sends no push notifications,
         *        <code>FILTERED</code> sends only filtered push notifications.
         * @see AllowNotifications
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllowNotifications
         */
        Builder allowNotifications(AllowNotifications allowNotifications);

        /**
         * <p>
         * The simple JSON object used to send a subset of a push notification to the requsted member.
         * </p>
         * 
         * @param filterRule
         *        The simple JSON object used to send a subset of a push notification to the requsted member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterRule(String filterRule);
    }

    static final class BuilderImpl implements Builder {
        private String allowNotifications;

        private String filterRule;

        private BuilderImpl() {
        }

        private BuilderImpl(PushNotificationPreferences model) {
            allowNotifications(model.allowNotifications);
            filterRule(model.filterRule);
        }

        public final String getAllowNotifications() {
            return allowNotifications;
        }

        public final void setAllowNotifications(String allowNotifications) {
            this.allowNotifications = allowNotifications;
        }

        @Override
        @Transient
        public final Builder allowNotifications(String allowNotifications) {
            this.allowNotifications = allowNotifications;
            return this;
        }

        @Override
        @Transient
        public final Builder allowNotifications(AllowNotifications allowNotifications) {
            this.allowNotifications(allowNotifications == null ? null : allowNotifications.toString());
            return this;
        }

        public final String getFilterRule() {
            return filterRule;
        }

        public final void setFilterRule(String filterRule) {
            this.filterRule = filterRule;
        }

        @Override
        @Transient
        public final Builder filterRule(String filterRule) {
            this.filterRule = filterRule;
            return this;
        }

        @Override
        public PushNotificationPreferences build() {
            return new PushNotificationPreferences(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
