/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendChannelMessageRequest extends ChimeSdkMessagingRequest implements
        ToCopyableBuilder<SendChannelMessageRequest.Builder, SendChannelMessageRequest> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelArn").getter(getter(SendChannelMessageRequest::channelArn)).setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelArn").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(SendChannelMessageRequest::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(SendChannelMessageRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> PERSISTENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Persistence").getter(getter(SendChannelMessageRequest::persistenceAsString))
            .setter(setter(Builder::persistence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Persistence").build()).build();

    private static final SdkField<String> METADATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Metadata").getter(getter(SendChannelMessageRequest::metadata)).setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(SendChannelMessageRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> CHIME_BEARER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChimeBearer").getter(getter(SendChannelMessageRequest::chimeBearer))
            .setter(setter(Builder::chimeBearer))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-chime-bearer").build()).build();

    private static final SdkField<PushNotificationConfiguration> PUSH_NOTIFICATION_FIELD = SdkField
            .<PushNotificationConfiguration> builder(MarshallingType.SDK_POJO).memberName("PushNotification")
            .getter(getter(SendChannelMessageRequest::pushNotification)).setter(setter(Builder::pushNotification))
            .constructor(PushNotificationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PushNotification").build()).build();

    private static final SdkField<Map<String, MessageAttributeValue>> MESSAGE_ATTRIBUTES_FIELD = SdkField
            .<Map<String, MessageAttributeValue>> builder(MarshallingType.MAP)
            .memberName("MessageAttributes")
            .getter(getter(SendChannelMessageRequest::messageAttributes))
            .setter(setter(Builder::messageAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<MessageAttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(MessageAttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD,
            CONTENT_FIELD, TYPE_FIELD, PERSISTENCE_FIELD, METADATA_FIELD, CLIENT_REQUEST_TOKEN_FIELD, CHIME_BEARER_FIELD,
            PUSH_NOTIFICATION_FIELD, MESSAGE_ATTRIBUTES_FIELD));

    private final String channelArn;

    private final String content;

    private final String type;

    private final String persistence;

    private final String metadata;

    private final String clientRequestToken;

    private final String chimeBearer;

    private final PushNotificationConfiguration pushNotification;

    private final Map<String, MessageAttributeValue> messageAttributes;

    private SendChannelMessageRequest(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.content = builder.content;
        this.type = builder.type;
        this.persistence = builder.persistence;
        this.metadata = builder.metadata;
        this.clientRequestToken = builder.clientRequestToken;
        this.chimeBearer = builder.chimeBearer;
        this.pushNotification = builder.pushNotification;
        this.messageAttributes = builder.messageAttributes;
    }

    /**
     * <p>
     * The ARN of the channel.
     * </p>
     * 
     * @return The ARN of the channel.
     */
    public final String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * The content of the message.
     * </p>
     * 
     * @return The content of the message.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * The type of message, <code>STANDARD</code> or <code>CONTROL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChannelMessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of message, <code>STANDARD</code> or <code>CONTROL</code>.
     * @see ChannelMessageType
     */
    public final ChannelMessageType type() {
        return ChannelMessageType.fromValue(type);
    }

    /**
     * <p>
     * The type of message, <code>STANDARD</code> or <code>CONTROL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChannelMessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of message, <code>STANDARD</code> or <code>CONTROL</code>.
     * @see ChannelMessageType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Boolean that controls whether the message is persisted on the back end. Required.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #persistence} will
     * return {@link ChannelMessagePersistenceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #persistenceAsString}.
     * </p>
     * 
     * @return Boolean that controls whether the message is persisted on the back end. Required.
     * @see ChannelMessagePersistenceType
     */
    public final ChannelMessagePersistenceType persistence() {
        return ChannelMessagePersistenceType.fromValue(persistence);
    }

    /**
     * <p>
     * Boolean that controls whether the message is persisted on the back end. Required.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #persistence} will
     * return {@link ChannelMessagePersistenceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #persistenceAsString}.
     * </p>
     * 
     * @return Boolean that controls whether the message is persisted on the back end. Required.
     * @see ChannelMessagePersistenceType
     */
    public final String persistenceAsString() {
        return persistence;
    }

    /**
     * <p>
     * The optional metadata for each message.
     * </p>
     * 
     * @return The optional metadata for each message.
     */
    public final String metadata() {
        return metadata;
    }

    /**
     * <p>
     * The <code>Idempotency</code> token for each client request.
     * </p>
     * 
     * @return The <code>Idempotency</code> token for each client request.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The <code>AppInstanceUserArn</code> of the user that makes the API call.
     * </p>
     * 
     * @return The <code>AppInstanceUserArn</code> of the user that makes the API call.
     */
    public final String chimeBearer() {
        return chimeBearer;
    }

    /**
     * <p>
     * The push notification configuration of the message.
     * </p>
     * 
     * @return The push notification configuration of the message.
     */
    public final PushNotificationConfiguration pushNotification() {
        return pushNotification;
    }

    /**
     * For responses, this returns true if the service returned a value for the MessageAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMessageAttributes() {
        return messageAttributes != null && !(messageAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The attributes for the message, used for message filtering along with a <code>FilterRule</code> defined in the
     * <code>PushNotificationPreferences</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMessageAttributes} method.
     * </p>
     * 
     * @return The attributes for the message, used for message filtering along with a <code>FilterRule</code> defined
     *         in the <code>PushNotificationPreferences</code>.
     */
    public final Map<String, MessageAttributeValue> messageAttributes() {
        return messageAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(persistenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(chimeBearer());
        hashCode = 31 * hashCode + Objects.hashCode(pushNotification());
        hashCode = 31 * hashCode + Objects.hashCode(hasMessageAttributes() ? messageAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendChannelMessageRequest)) {
            return false;
        }
        SendChannelMessageRequest other = (SendChannelMessageRequest) obj;
        return Objects.equals(channelArn(), other.channelArn()) && Objects.equals(content(), other.content())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(persistenceAsString(), other.persistenceAsString())
                && Objects.equals(metadata(), other.metadata())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(chimeBearer(), other.chimeBearer())
                && Objects.equals(pushNotification(), other.pushNotification())
                && hasMessageAttributes() == other.hasMessageAttributes()
                && Objects.equals(messageAttributes(), other.messageAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendChannelMessageRequest").add("ChannelArn", channelArn())
                .add("Content", content() == null ? null : "*** Sensitive Data Redacted ***").add("Type", typeAsString())
                .add("Persistence", persistenceAsString())
                .add("Metadata", metadata() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ClientRequestToken", clientRequestToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ChimeBearer", chimeBearer()).add("PushNotification", pushNotification())
                .add("MessageAttributes", messageAttributes() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Persistence":
            return Optional.ofNullable(clazz.cast(persistenceAsString()));
        case "Metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "ChimeBearer":
            return Optional.ofNullable(clazz.cast(chimeBearer()));
        case "PushNotification":
            return Optional.ofNullable(clazz.cast(pushNotification()));
        case "MessageAttributes":
            return Optional.ofNullable(clazz.cast(messageAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendChannelMessageRequest, T> g) {
        return obj -> g.apply((SendChannelMessageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMessagingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SendChannelMessageRequest> {
        /**
         * <p>
         * The ARN of the channel.
         * </p>
         * 
         * @param channelArn
         *        The ARN of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * The content of the message.
         * </p>
         * 
         * @param content
         *        The content of the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * The type of message, <code>STANDARD</code> or <code>CONTROL</code>.
         * </p>
         * 
         * @param type
         *        The type of message, <code>STANDARD</code> or <code>CONTROL</code>.
         * @see ChannelMessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelMessageType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of message, <code>STANDARD</code> or <code>CONTROL</code>.
         * </p>
         * 
         * @param type
         *        The type of message, <code>STANDARD</code> or <code>CONTROL</code>.
         * @see ChannelMessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelMessageType
         */
        Builder type(ChannelMessageType type);

        /**
         * <p>
         * Boolean that controls whether the message is persisted on the back end. Required.
         * </p>
         * 
         * @param persistence
         *        Boolean that controls whether the message is persisted on the back end. Required.
         * @see ChannelMessagePersistenceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelMessagePersistenceType
         */
        Builder persistence(String persistence);

        /**
         * <p>
         * Boolean that controls whether the message is persisted on the back end. Required.
         * </p>
         * 
         * @param persistence
         *        Boolean that controls whether the message is persisted on the back end. Required.
         * @see ChannelMessagePersistenceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelMessagePersistenceType
         */
        Builder persistence(ChannelMessagePersistenceType persistence);

        /**
         * <p>
         * The optional metadata for each message.
         * </p>
         * 
         * @param metadata
         *        The optional metadata for each message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(String metadata);

        /**
         * <p>
         * The <code>Idempotency</code> token for each client request.
         * </p>
         * 
         * @param clientRequestToken
         *        The <code>Idempotency</code> token for each client request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The <code>AppInstanceUserArn</code> of the user that makes the API call.
         * </p>
         * 
         * @param chimeBearer
         *        The <code>AppInstanceUserArn</code> of the user that makes the API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chimeBearer(String chimeBearer);

        /**
         * <p>
         * The push notification configuration of the message.
         * </p>
         * 
         * @param pushNotification
         *        The push notification configuration of the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pushNotification(PushNotificationConfiguration pushNotification);

        /**
         * <p>
         * The push notification configuration of the message.
         * </p>
         * This is a convenience that creates an instance of the {@link PushNotificationConfiguration.Builder} avoiding
         * the need to create one manually via {@link PushNotificationConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link PushNotificationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #pushNotification(PushNotificationConfiguration)}.
         * 
         * @param pushNotification
         *        a consumer that will call methods on {@link PushNotificationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pushNotification(PushNotificationConfiguration)
         */
        default Builder pushNotification(Consumer<PushNotificationConfiguration.Builder> pushNotification) {
            return pushNotification(PushNotificationConfiguration.builder().applyMutation(pushNotification).build());
        }

        /**
         * <p>
         * The attributes for the message, used for message filtering along with a <code>FilterRule</code> defined in
         * the <code>PushNotificationPreferences</code>.
         * </p>
         * 
         * @param messageAttributes
         *        The attributes for the message, used for message filtering along with a <code>FilterRule</code>
         *        defined in the <code>PushNotificationPreferences</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageAttributes(Map<String, MessageAttributeValue> messageAttributes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkMessagingRequest.BuilderImpl implements Builder {
        private String channelArn;

        private String content;

        private String type;

        private String persistence;

        private String metadata;

        private String clientRequestToken;

        private String chimeBearer;

        private PushNotificationConfiguration pushNotification;

        private Map<String, MessageAttributeValue> messageAttributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SendChannelMessageRequest model) {
            super(model);
            channelArn(model.channelArn);
            content(model.content);
            type(model.type);
            persistence(model.persistence);
            metadata(model.metadata);
            clientRequestToken(model.clientRequestToken);
            chimeBearer(model.chimeBearer);
            pushNotification(model.pushNotification);
            messageAttributes(model.messageAttributes);
        }

        public final String getChannelArn() {
            return channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        @Transient
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        @Transient
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(ChannelMessageType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getPersistence() {
            return persistence;
        }

        public final void setPersistence(String persistence) {
            this.persistence = persistence;
        }

        @Override
        @Transient
        public final Builder persistence(String persistence) {
            this.persistence = persistence;
            return this;
        }

        @Override
        @Transient
        public final Builder persistence(ChannelMessagePersistenceType persistence) {
            this.persistence(persistence == null ? null : persistence.toString());
            return this;
        }

        public final String getMetadata() {
            return metadata;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        @Override
        @Transient
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getChimeBearer() {
            return chimeBearer;
        }

        public final void setChimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
        }

        @Override
        @Transient
        public final Builder chimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
            return this;
        }

        public final PushNotificationConfiguration.Builder getPushNotification() {
            return pushNotification != null ? pushNotification.toBuilder() : null;
        }

        public final void setPushNotification(PushNotificationConfiguration.BuilderImpl pushNotification) {
            this.pushNotification = pushNotification != null ? pushNotification.build() : null;
        }

        @Override
        @Transient
        public final Builder pushNotification(PushNotificationConfiguration pushNotification) {
            this.pushNotification = pushNotification;
            return this;
        }

        public final Map<String, MessageAttributeValue.Builder> getMessageAttributes() {
            Map<String, MessageAttributeValue.Builder> result = MessageAttributeMapCopier.copyToBuilder(this.messageAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setMessageAttributes(Map<String, MessageAttributeValue.BuilderImpl> messageAttributes) {
            this.messageAttributes = MessageAttributeMapCopier.copyFromBuilder(messageAttributes);
        }

        @Override
        @Transient
        public final Builder messageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
            this.messageAttributes = MessageAttributeMapCopier.copy(messageAttributes);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendChannelMessageRequest build() {
            return new SendChannelMessageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
