/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateChannelFlowRequest extends ChimeSdkMessagingRequest implements
        ToCopyableBuilder<UpdateChannelFlowRequest.Builder, UpdateChannelFlowRequest> {
    private static final SdkField<String> CHANNEL_FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelFlowArn").getter(getter(UpdateChannelFlowRequest::channelFlowArn))
            .setter(setter(Builder::channelFlowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelFlowArn").build()).build();

    private static final SdkField<List<Processor>> PROCESSORS_FIELD = SdkField
            .<List<Processor>> builder(MarshallingType.LIST)
            .memberName("Processors")
            .getter(getter(UpdateChannelFlowRequest::processors))
            .setter(setter(Builder::processors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Processors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Processor> builder(MarshallingType.SDK_POJO)
                                            .constructor(Processor::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateChannelFlowRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_FLOW_ARN_FIELD,
            PROCESSORS_FIELD, NAME_FIELD));

    private final String channelFlowArn;

    private final List<Processor> processors;

    private final String name;

    private UpdateChannelFlowRequest(BuilderImpl builder) {
        super(builder);
        this.channelFlowArn = builder.channelFlowArn;
        this.processors = builder.processors;
        this.name = builder.name;
    }

    /**
     * <p>
     * The ARN of the channel flow.
     * </p>
     * 
     * @return The ARN of the channel flow.
     */
    public final String channelFlowArn() {
        return channelFlowArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Processors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProcessors() {
        return processors != null && !(processors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the processor Lambda functions
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProcessors} method.
     * </p>
     * 
     * @return Information about the processor Lambda functions
     */
    public final List<Processor> processors() {
        return processors;
    }

    /**
     * <p>
     * The name of the channel flow.
     * </p>
     * 
     * @return The name of the channel flow.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelFlowArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasProcessors() ? processors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateChannelFlowRequest)) {
            return false;
        }
        UpdateChannelFlowRequest other = (UpdateChannelFlowRequest) obj;
        return Objects.equals(channelFlowArn(), other.channelFlowArn()) && hasProcessors() == other.hasProcessors()
                && Objects.equals(processors(), other.processors()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateChannelFlowRequest").add("ChannelFlowArn", channelFlowArn())
                .add("Processors", hasProcessors() ? processors() : null)
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelFlowArn":
            return Optional.ofNullable(clazz.cast(channelFlowArn()));
        case "Processors":
            return Optional.ofNullable(clazz.cast(processors()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateChannelFlowRequest, T> g) {
        return obj -> g.apply((UpdateChannelFlowRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMessagingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateChannelFlowRequest> {
        /**
         * <p>
         * The ARN of the channel flow.
         * </p>
         * 
         * @param channelFlowArn
         *        The ARN of the channel flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelFlowArn(String channelFlowArn);

        /**
         * <p>
         * Information about the processor Lambda functions
         * </p>
         * 
         * @param processors
         *        Information about the processor Lambda functions
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processors(Collection<Processor> processors);

        /**
         * <p>
         * Information about the processor Lambda functions
         * </p>
         * 
         * @param processors
         *        Information about the processor Lambda functions
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processors(Processor... processors);

        /**
         * <p>
         * Information about the processor Lambda functions
         * </p>
         * This is a convenience that creates an instance of the {@link List<Processor>.Builder} avoiding the need to
         * create one manually via {@link List<Processor>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Processor>.Builder#build()} is called immediately and its
         * result is passed to {@link #processors(List<Processor>)}.
         * 
         * @param processors
         *        a consumer that will call methods on {@link List<Processor>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processors(List<Processor>)
         */
        Builder processors(Consumer<Processor.Builder>... processors);

        /**
         * <p>
         * The name of the channel flow.
         * </p>
         * 
         * @param name
         *        The name of the channel flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkMessagingRequest.BuilderImpl implements Builder {
        private String channelFlowArn;

        private List<Processor> processors = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateChannelFlowRequest model) {
            super(model);
            channelFlowArn(model.channelFlowArn);
            processors(model.processors);
            name(model.name);
        }

        public final String getChannelFlowArn() {
            return channelFlowArn;
        }

        public final void setChannelFlowArn(String channelFlowArn) {
            this.channelFlowArn = channelFlowArn;
        }

        @Override
        @Transient
        public final Builder channelFlowArn(String channelFlowArn) {
            this.channelFlowArn = channelFlowArn;
            return this;
        }

        public final List<Processor.Builder> getProcessors() {
            List<Processor.Builder> result = ProcessorListCopier.copyToBuilder(this.processors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProcessors(Collection<Processor.BuilderImpl> processors) {
            this.processors = ProcessorListCopier.copyFromBuilder(processors);
        }

        @Override
        @Transient
        public final Builder processors(Collection<Processor> processors) {
            this.processors = ProcessorListCopier.copy(processors);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder processors(Processor... processors) {
            processors(Arrays.asList(processors));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder processors(Consumer<Processor.Builder>... processors) {
            processors(Stream.of(processors).map(c -> Processor.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateChannelFlowRequest build() {
            return new UpdateChannelFlowRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
