/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessageStatusStructure;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessageType;
import software.amazon.awssdk.services.chimesdkmessaging.model.Identity;
import software.amazon.awssdk.services.chimesdkmessaging.model.MessageAttributeMapCopier;
import software.amazon.awssdk.services.chimesdkmessaging.model.MessageAttributeValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChannelMessageSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChannelMessageSummary> {
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageId").getter(ChannelMessageSummary.getter(ChannelMessageSummary::messageId)).setter(ChannelMessageSummary.setter(Builder::messageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageId").build()}).build();
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Content").getter(ChannelMessageSummary.getter(ChannelMessageSummary::content)).setter(ChannelMessageSummary.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<String> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Metadata").getter(ChannelMessageSummary.getter(ChannelMessageSummary::metadata)).setter(ChannelMessageSummary.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ChannelMessageSummary.getter(ChannelMessageSummary::typeAsString)).setter(ChannelMessageSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(ChannelMessageSummary.getter(ChannelMessageSummary::createdTimestamp)).setter(ChannelMessageSummary.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTimestamp").getter(ChannelMessageSummary.getter(ChannelMessageSummary::lastUpdatedTimestamp)).setter(ChannelMessageSummary.setter(Builder::lastUpdatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_EDITED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastEditedTimestamp").getter(ChannelMessageSummary.getter(ChannelMessageSummary::lastEditedTimestamp)).setter(ChannelMessageSummary.setter(Builder::lastEditedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastEditedTimestamp").build()}).build();
    private static final SdkField<Identity> SENDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Sender").getter(ChannelMessageSummary.getter(ChannelMessageSummary::sender)).setter(ChannelMessageSummary.setter(Builder::sender)).constructor(Identity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sender").build()}).build();
    private static final SdkField<Boolean> REDACTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Redacted").getter(ChannelMessageSummary.getter(ChannelMessageSummary::redacted)).setter(ChannelMessageSummary.setter(Builder::redacted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Redacted").build()}).build();
    private static final SdkField<ChannelMessageStatusStructure> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(ChannelMessageSummary.getter(ChannelMessageSummary::status)).setter(ChannelMessageSummary.setter(Builder::status)).constructor(ChannelMessageStatusStructure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Map<String, MessageAttributeValue>> MESSAGE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("MessageAttributes").getter(ChannelMessageSummary.getter(ChannelMessageSummary::messageAttributes)).setter(ChannelMessageSummary.setter(Builder::messageAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageAttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_ID_FIELD, CONTENT_FIELD, METADATA_FIELD, TYPE_FIELD, CREATED_TIMESTAMP_FIELD, LAST_UPDATED_TIMESTAMP_FIELD, LAST_EDITED_TIMESTAMP_FIELD, SENDER_FIELD, REDACTED_FIELD, STATUS_FIELD, MESSAGE_ATTRIBUTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String messageId;
    private final String content;
    private final String metadata;
    private final String type;
    private final Instant createdTimestamp;
    private final Instant lastUpdatedTimestamp;
    private final Instant lastEditedTimestamp;
    private final Identity sender;
    private final Boolean redacted;
    private final ChannelMessageStatusStructure status;
    private final Map<String, MessageAttributeValue> messageAttributes;

    private ChannelMessageSummary(BuilderImpl builder) {
        this.messageId = builder.messageId;
        this.content = builder.content;
        this.metadata = builder.metadata;
        this.type = builder.type;
        this.createdTimestamp = builder.createdTimestamp;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.lastEditedTimestamp = builder.lastEditedTimestamp;
        this.sender = builder.sender;
        this.redacted = builder.redacted;
        this.status = builder.status;
        this.messageAttributes = builder.messageAttributes;
    }

    public final String messageId() {
        return this.messageId;
    }

    public final String content() {
        return this.content;
    }

    public final String metadata() {
        return this.metadata;
    }

    public final ChannelMessageType type() {
        return ChannelMessageType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant lastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public final Instant lastEditedTimestamp() {
        return this.lastEditedTimestamp;
    }

    public final Identity sender() {
        return this.sender;
    }

    public final Boolean redacted() {
        return this.redacted;
    }

    public final ChannelMessageStatusStructure status() {
        return this.status;
    }

    public final boolean hasMessageAttributes() {
        return this.messageAttributes != null && !(this.messageAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, MessageAttributeValue> messageAttributes() {
        return this.messageAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.messageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastEditedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.sender());
        hashCode = 31 * hashCode + Objects.hashCode(this.redacted());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMessageAttributes() ? this.messageAttributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelMessageSummary)) {
            return false;
        }
        ChannelMessageSummary other = (ChannelMessageSummary)obj;
        return Objects.equals(this.messageId(), other.messageId()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.lastUpdatedTimestamp(), other.lastUpdatedTimestamp()) && Objects.equals(this.lastEditedTimestamp(), other.lastEditedTimestamp()) && Objects.equals(this.sender(), other.sender()) && Objects.equals(this.redacted(), other.redacted()) && Objects.equals(this.status(), other.status()) && this.hasMessageAttributes() == other.hasMessageAttributes() && Objects.equals(this.messageAttributes(), other.messageAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"ChannelMessageSummary").add("MessageId", (Object)this.messageId()).add("Content", (Object)(this.content() == null ? null : "*** Sensitive Data Redacted ***")).add("Metadata", (Object)(this.metadata() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)this.typeAsString()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("LastUpdatedTimestamp", (Object)this.lastUpdatedTimestamp()).add("LastEditedTimestamp", (Object)this.lastEditedTimestamp()).add("Sender", (Object)this.sender()).add("Redacted", (Object)this.redacted()).add("Status", (Object)this.status()).add("MessageAttributes", (Object)(this.messageAttributes() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MessageId": {
                return Optional.ofNullable(clazz.cast(this.messageId()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "Metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "LastUpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTimestamp()));
            }
            case "LastEditedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastEditedTimestamp()));
            }
            case "Sender": {
                return Optional.ofNullable(clazz.cast(this.sender()));
            }
            case "Redacted": {
                return Optional.ofNullable(clazz.cast(this.redacted()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "MessageAttributes": {
                return Optional.ofNullable(clazz.cast(this.messageAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChannelMessageSummary, T> g) {
        return obj -> g.apply((ChannelMessageSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String messageId;
        private String content;
        private String metadata;
        private String type;
        private Instant createdTimestamp;
        private Instant lastUpdatedTimestamp;
        private Instant lastEditedTimestamp;
        private Identity sender;
        private Boolean redacted;
        private ChannelMessageStatusStructure status;
        private Map<String, MessageAttributeValue> messageAttributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelMessageSummary model) {
            this.messageId(model.messageId);
            this.content(model.content);
            this.metadata(model.metadata);
            this.type(model.type);
            this.createdTimestamp(model.createdTimestamp);
            this.lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            this.lastEditedTimestamp(model.lastEditedTimestamp);
            this.sender(model.sender);
            this.redacted(model.redacted);
            this.status(model.status);
            this.messageAttributes(model.messageAttributes);
        }

        public final String getMessageId() {
            return this.messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        @Transient
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final String getContent() {
            return this.content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        @Transient
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getMetadata() {
            return this.metadata;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        @Override
        @Transient
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(ChannelMessageType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        @Transient
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return this.lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        @Transient
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final Instant getLastEditedTimestamp() {
            return this.lastEditedTimestamp;
        }

        public final void setLastEditedTimestamp(Instant lastEditedTimestamp) {
            this.lastEditedTimestamp = lastEditedTimestamp;
        }

        @Override
        @Transient
        public final Builder lastEditedTimestamp(Instant lastEditedTimestamp) {
            this.lastEditedTimestamp = lastEditedTimestamp;
            return this;
        }

        public final Identity.Builder getSender() {
            return this.sender != null ? this.sender.toBuilder() : null;
        }

        public final void setSender(Identity.BuilderImpl sender) {
            this.sender = sender != null ? sender.build() : null;
        }

        @Override
        @Transient
        public final Builder sender(Identity sender) {
            this.sender = sender;
            return this;
        }

        public final Boolean getRedacted() {
            return this.redacted;
        }

        public final void setRedacted(Boolean redacted) {
            this.redacted = redacted;
        }

        @Override
        @Transient
        public final Builder redacted(Boolean redacted) {
            this.redacted = redacted;
            return this;
        }

        public final ChannelMessageStatusStructure.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(ChannelMessageStatusStructure.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        @Transient
        public final Builder status(ChannelMessageStatusStructure status) {
            this.status = status;
            return this;
        }

        public final Map<String, MessageAttributeValue.Builder> getMessageAttributes() {
            Map<String, MessageAttributeValue.Builder> result = MessageAttributeMapCopier.copyToBuilder(this.messageAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setMessageAttributes(Map<String, MessageAttributeValue.BuilderImpl> messageAttributes) {
            this.messageAttributes = MessageAttributeMapCopier.copyFromBuilder(messageAttributes);
        }

        @Override
        @Transient
        public final Builder messageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
            this.messageAttributes = MessageAttributeMapCopier.copy(messageAttributes);
            return this;
        }

        public ChannelMessageSummary build() {
            return new ChannelMessageSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChannelMessageSummary> {
        public Builder messageId(String var1);

        public Builder content(String var1);

        public Builder metadata(String var1);

        public Builder type(String var1);

        public Builder type(ChannelMessageType var1);

        public Builder createdTimestamp(Instant var1);

        public Builder lastUpdatedTimestamp(Instant var1);

        public Builder lastEditedTimestamp(Instant var1);

        public Builder sender(Identity var1);

        default public Builder sender(Consumer<Identity.Builder> sender) {
            return this.sender((Identity)((Identity.Builder)Identity.builder().applyMutation(sender)).build());
        }

        public Builder redacted(Boolean var1);

        public Builder status(ChannelMessageStatusStructure var1);

        default public Builder status(Consumer<ChannelMessageStatusStructure.Builder> status) {
            return this.status((ChannelMessageStatusStructure)((ChannelMessageStatusStructure.Builder)ChannelMessageStatusStructure.builder().applyMutation(status)).build());
        }

        public Builder messageAttributes(Map<String, MessageAttributeValue> var1);
    }
}

