/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListChannelMembershipsRequest extends ChimeSdkMessagingRequest implements
        ToCopyableBuilder<ListChannelMembershipsRequest.Builder, ListChannelMembershipsRequest> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelArn").getter(getter(ListChannelMembershipsRequest::channelArn))
            .setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelArn").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ListChannelMembershipsRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("type").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListChannelMembershipsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("max-results").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListChannelMembershipsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next-token").build()).build();

    private static final SdkField<String> CHIME_BEARER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChimeBearer").getter(getter(ListChannelMembershipsRequest::chimeBearer))
            .setter(setter(Builder::chimeBearer))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-chime-bearer").build()).build();

    private static final SdkField<String> SUB_CHANNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubChannelId").getter(getter(ListChannelMembershipsRequest::subChannelId))
            .setter(setter(Builder::subChannelId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sub-channel-id").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD, TYPE_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, CHIME_BEARER_FIELD, SUB_CHANNEL_ID_FIELD));

    private final String channelArn;

    private final String type;

    private final Integer maxResults;

    private final String nextToken;

    private final String chimeBearer;

    private final String subChannelId;

    private ListChannelMembershipsRequest(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.type = builder.type;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.chimeBearer = builder.chimeBearer;
        this.subChannelId = builder.subChannelId;
    }

    /**
     * <p>
     * The maximum number of channel memberships that you want returned.
     * </p>
     * 
     * @return The maximum number of channel memberships that you want returned.
     */
    public final String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are returned as part
     * of <code>ListChannelMemberships</code> if no type is specified. Hidden members are only returned if the type
     * filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChannelMembershipType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are returned
     *         as part of <code>ListChannelMemberships</code> if no type is specified. Hidden members are only returned
     *         if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>.
     * @see ChannelMembershipType
     */
    public final ChannelMembershipType type() {
        return ChannelMembershipType.fromValue(type);
    }

    /**
     * <p>
     * The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are returned as part
     * of <code>ListChannelMemberships</code> if no type is specified. Hidden members are only returned if the type
     * filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChannelMembershipType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are returned
     *         as part of <code>ListChannelMemberships</code> if no type is specified. Hidden members are only returned
     *         if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>.
     * @see ChannelMembershipType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The maximum number of channel memberships that you want returned.
     * </p>
     * 
     * @return The maximum number of channel memberships that you want returned.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token passed by previous API calls until all requested channel memberships are returned.
     * </p>
     * 
     * @return The token passed by previous API calls until all requested channel memberships are returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The <code>AppInstanceUserArn</code> of the user that makes the API call.
     * </p>
     * 
     * @return The <code>AppInstanceUserArn</code> of the user that makes the API call.
     */
    public final String chimeBearer() {
        return chimeBearer;
    }

    /**
     * <p>
     * The ID of the SubChannel in the request.
     * </p>
     * <note>
     * <p>
     * Only required when listing a user's memberships in a particular sub-channel of an elastic channel.
     * </p>
     * </note>
     * 
     * @return The ID of the SubChannel in the request.</p> <note>
     *         <p>
     *         Only required when listing a user's memberships in a particular sub-channel of an elastic channel.
     *         </p>
     */
    public final String subChannelId() {
        return subChannelId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(chimeBearer());
        hashCode = 31 * hashCode + Objects.hashCode(subChannelId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChannelMembershipsRequest)) {
            return false;
        }
        ListChannelMembershipsRequest other = (ListChannelMembershipsRequest) obj;
        return Objects.equals(channelArn(), other.channelArn()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(chimeBearer(), other.chimeBearer()) && Objects.equals(subChannelId(), other.subChannelId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListChannelMembershipsRequest").add("ChannelArn", channelArn()).add("Type", typeAsString())
                .add("MaxResults", maxResults()).add("NextToken", nextToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ChimeBearer", chimeBearer()).add("SubChannelId", subChannelId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ChimeBearer":
            return Optional.ofNullable(clazz.cast(chimeBearer()));
        case "SubChannelId":
            return Optional.ofNullable(clazz.cast(subChannelId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListChannelMembershipsRequest, T> g) {
        return obj -> g.apply((ListChannelMembershipsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMessagingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListChannelMembershipsRequest> {
        /**
         * <p>
         * The maximum number of channel memberships that you want returned.
         * </p>
         * 
         * @param channelArn
         *        The maximum number of channel memberships that you want returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are returned as
         * part of <code>ListChannelMemberships</code> if no type is specified. Hidden members are only returned if the
         * type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>.
         * </p>
         * 
         * @param type
         *        The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are
         *        returned as part of <code>ListChannelMemberships</code> if no type is specified. Hidden members are
         *        only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>.
         * @see ChannelMembershipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelMembershipType
         */
        Builder type(String type);

        /**
         * <p>
         * The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are returned as
         * part of <code>ListChannelMemberships</code> if no type is specified. Hidden members are only returned if the
         * type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>.
         * </p>
         * 
         * @param type
         *        The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are
         *        returned as part of <code>ListChannelMemberships</code> if no type is specified. Hidden members are
         *        only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>.
         * @see ChannelMembershipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelMembershipType
         */
        Builder type(ChannelMembershipType type);

        /**
         * <p>
         * The maximum number of channel memberships that you want returned.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of channel memberships that you want returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token passed by previous API calls until all requested channel memberships are returned.
         * </p>
         * 
         * @param nextToken
         *        The token passed by previous API calls until all requested channel memberships are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The <code>AppInstanceUserArn</code> of the user that makes the API call.
         * </p>
         * 
         * @param chimeBearer
         *        The <code>AppInstanceUserArn</code> of the user that makes the API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chimeBearer(String chimeBearer);

        /**
         * <p>
         * The ID of the SubChannel in the request.
         * </p>
         * <note>
         * <p>
         * Only required when listing a user's memberships in a particular sub-channel of an elastic channel.
         * </p>
         * </note>
         * 
         * @param subChannelId
         *        The ID of the SubChannel in the request.</p> <note>
         *        <p>
         *        Only required when listing a user's memberships in a particular sub-channel of an elastic channel.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subChannelId(String subChannelId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkMessagingRequest.BuilderImpl implements Builder {
        private String channelArn;

        private String type;

        private Integer maxResults;

        private String nextToken;

        private String chimeBearer;

        private String subChannelId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChannelMembershipsRequest model) {
            super(model);
            channelArn(model.channelArn);
            type(model.type);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            chimeBearer(model.chimeBearer);
            subChannelId(model.subChannelId);
        }

        public final String getChannelArn() {
            return channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChannelMembershipType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getChimeBearer() {
            return chimeBearer;
        }

        public final void setChimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
        }

        @Override
        public final Builder chimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
            return this;
        }

        public final String getSubChannelId() {
            return subChannelId;
        }

        public final void setSubChannelId(String subChannelId) {
            this.subChannelId = subChannelId;
        }

        @Override
        public final Builder subChannelId(String subChannelId) {
            this.subChannelId = subChannelId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListChannelMembershipsRequest build() {
            return new ListChannelMembershipsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
