/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Stores information about a callback.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChannelMessageCallback implements SdkPojo, Serializable,
        ToCopyableBuilder<ChannelMessageCallback.Builder, ChannelMessageCallback> {
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageId").getter(getter(ChannelMessageCallback::messageId)).setter(setter(Builder::messageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageId").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(ChannelMessageCallback::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<String> METADATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Metadata").getter(getter(ChannelMessageCallback::metadata)).setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()).build();

    private static final SdkField<PushNotificationConfiguration> PUSH_NOTIFICATION_FIELD = SdkField
            .<PushNotificationConfiguration> builder(MarshallingType.SDK_POJO).memberName("PushNotification")
            .getter(getter(ChannelMessageCallback::pushNotification)).setter(setter(Builder::pushNotification))
            .constructor(PushNotificationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PushNotification").build()).build();

    private static final SdkField<Map<String, MessageAttributeValue>> MESSAGE_ATTRIBUTES_FIELD = SdkField
            .<Map<String, MessageAttributeValue>> builder(MarshallingType.MAP)
            .memberName("MessageAttributes")
            .getter(getter(ChannelMessageCallback::messageAttributes))
            .setter(setter(Builder::messageAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<MessageAttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(MessageAttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> SUB_CHANNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubChannelId").getter(getter(ChannelMessageCallback::subChannelId))
            .setter(setter(Builder::subChannelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubChannelId").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentType").getter(getter(ChannelMessageCallback::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_ID_FIELD,
            CONTENT_FIELD, METADATA_FIELD, PUSH_NOTIFICATION_FIELD, MESSAGE_ATTRIBUTES_FIELD, SUB_CHANNEL_ID_FIELD,
            CONTENT_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String messageId;

    private final String content;

    private final String metadata;

    private final PushNotificationConfiguration pushNotification;

    private final Map<String, MessageAttributeValue> messageAttributes;

    private final String subChannelId;

    private final String contentType;

    private ChannelMessageCallback(BuilderImpl builder) {
        this.messageId = builder.messageId;
        this.content = builder.content;
        this.metadata = builder.metadata;
        this.pushNotification = builder.pushNotification;
        this.messageAttributes = builder.messageAttributes;
        this.subChannelId = builder.subChannelId;
        this.contentType = builder.contentType;
    }

    /**
     * <p>
     * The message ID.
     * </p>
     * 
     * @return The message ID.
     */
    public final String messageId() {
        return messageId;
    }

    /**
     * <p>
     * The message content.
     * </p>
     * 
     * @return The message content.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * The message metadata.
     * </p>
     * 
     * @return The message metadata.
     */
    public final String metadata() {
        return metadata;
    }

    /**
     * <p>
     * The push notification configuration of the message.
     * </p>
     * 
     * @return The push notification configuration of the message.
     */
    public final PushNotificationConfiguration pushNotification() {
        return pushNotification;
    }

    /**
     * For responses, this returns true if the service returned a value for the MessageAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMessageAttributes() {
        return messageAttributes != null && !(messageAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The attributes for the message, used for message filtering along with a <code>FilterRule</code> defined in the
     * <code>PushNotificationPreferences</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMessageAttributes} method.
     * </p>
     * 
     * @return The attributes for the message, used for message filtering along with a <code>FilterRule</code> defined
     *         in the <code>PushNotificationPreferences</code>.
     */
    public final Map<String, MessageAttributeValue> messageAttributes() {
        return messageAttributes;
    }

    /**
     * <p>
     * The ID of the SubChannel.
     * </p>
     * 
     * @return The ID of the SubChannel.
     */
    public final String subChannelId() {
        return subChannelId;
    }

    /**
     * <p>
     * The content type of the call-back message.
     * </p>
     * 
     * @return The content type of the call-back message.
     */
    public final String contentType() {
        return contentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(messageId());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(pushNotification());
        hashCode = 31 * hashCode + Objects.hashCode(hasMessageAttributes() ? messageAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(subChannelId());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelMessageCallback)) {
            return false;
        }
        ChannelMessageCallback other = (ChannelMessageCallback) obj;
        return Objects.equals(messageId(), other.messageId()) && Objects.equals(content(), other.content())
                && Objects.equals(metadata(), other.metadata()) && Objects.equals(pushNotification(), other.pushNotification())
                && hasMessageAttributes() == other.hasMessageAttributes()
                && Objects.equals(messageAttributes(), other.messageAttributes())
                && Objects.equals(subChannelId(), other.subChannelId()) && Objects.equals(contentType(), other.contentType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChannelMessageCallback").add("MessageId", messageId())
                .add("Content", content() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Metadata", metadata() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PushNotification", pushNotification())
                .add("MessageAttributes", messageAttributes() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SubChannelId", subChannelId())
                .add("ContentType", contentType() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MessageId":
            return Optional.ofNullable(clazz.cast(messageId()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "Metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "PushNotification":
            return Optional.ofNullable(clazz.cast(pushNotification()));
        case "MessageAttributes":
            return Optional.ofNullable(clazz.cast(messageAttributes()));
        case "SubChannelId":
            return Optional.ofNullable(clazz.cast(subChannelId()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChannelMessageCallback, T> g) {
        return obj -> g.apply((ChannelMessageCallback) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChannelMessageCallback> {
        /**
         * <p>
         * The message ID.
         * </p>
         * 
         * @param messageId
         *        The message ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageId(String messageId);

        /**
         * <p>
         * The message content.
         * </p>
         * 
         * @param content
         *        The message content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * The message metadata.
         * </p>
         * 
         * @param metadata
         *        The message metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(String metadata);

        /**
         * <p>
         * The push notification configuration of the message.
         * </p>
         * 
         * @param pushNotification
         *        The push notification configuration of the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pushNotification(PushNotificationConfiguration pushNotification);

        /**
         * <p>
         * The push notification configuration of the message.
         * </p>
         * This is a convenience method that creates an instance of the {@link PushNotificationConfiguration.Builder}
         * avoiding the need to create one manually via {@link PushNotificationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PushNotificationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #pushNotification(PushNotificationConfiguration)}.
         * 
         * @param pushNotification
         *        a consumer that will call methods on {@link PushNotificationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pushNotification(PushNotificationConfiguration)
         */
        default Builder pushNotification(Consumer<PushNotificationConfiguration.Builder> pushNotification) {
            return pushNotification(PushNotificationConfiguration.builder().applyMutation(pushNotification).build());
        }

        /**
         * <p>
         * The attributes for the message, used for message filtering along with a <code>FilterRule</code> defined in
         * the <code>PushNotificationPreferences</code>.
         * </p>
         * 
         * @param messageAttributes
         *        The attributes for the message, used for message filtering along with a <code>FilterRule</code>
         *        defined in the <code>PushNotificationPreferences</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageAttributes(Map<String, MessageAttributeValue> messageAttributes);

        /**
         * <p>
         * The ID of the SubChannel.
         * </p>
         * 
         * @param subChannelId
         *        The ID of the SubChannel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subChannelId(String subChannelId);

        /**
         * <p>
         * The content type of the call-back message.
         * </p>
         * 
         * @param contentType
         *        The content type of the call-back message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);
    }

    static final class BuilderImpl implements Builder {
        private String messageId;

        private String content;

        private String metadata;

        private PushNotificationConfiguration pushNotification;

        private Map<String, MessageAttributeValue> messageAttributes = DefaultSdkAutoConstructMap.getInstance();

        private String subChannelId;

        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelMessageCallback model) {
            messageId(model.messageId);
            content(model.content);
            metadata(model.metadata);
            pushNotification(model.pushNotification);
            messageAttributes(model.messageAttributes);
            subChannelId(model.subChannelId);
            contentType(model.contentType);
        }

        public final String getMessageId() {
            return messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getMetadata() {
            return metadata;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final PushNotificationConfiguration.Builder getPushNotification() {
            return pushNotification != null ? pushNotification.toBuilder() : null;
        }

        public final void setPushNotification(PushNotificationConfiguration.BuilderImpl pushNotification) {
            this.pushNotification = pushNotification != null ? pushNotification.build() : null;
        }

        @Override
        public final Builder pushNotification(PushNotificationConfiguration pushNotification) {
            this.pushNotification = pushNotification;
            return this;
        }

        public final Map<String, MessageAttributeValue.Builder> getMessageAttributes() {
            Map<String, MessageAttributeValue.Builder> result = MessageAttributeMapCopier.copyToBuilder(this.messageAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setMessageAttributes(Map<String, MessageAttributeValue.BuilderImpl> messageAttributes) {
            this.messageAttributes = MessageAttributeMapCopier.copyFromBuilder(messageAttributes);
        }

        @Override
        public final Builder messageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
            this.messageAttributes = MessageAttributeMapCopier.copy(messageAttributes);
            return this;
        }

        public final String getSubChannelId() {
            return subChannelId;
        }

        public final void setSubChannelId(String subChannelId) {
            this.subChannelId = subChannelId;
        }

        @Override
        public final Builder subChannelId(String subChannelId) {
            this.subChannelId = subChannelId;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public ChannelMessageCallback build() {
            return new ChannelMessageCallback(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
