/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChimeSdkMessagingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetChannelMembershipPreferencesRequest
extends ChimeSdkMessagingRequest
implements ToCopyableBuilder<Builder, GetChannelMembershipPreferencesRequest> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelArn").getter(GetChannelMembershipPreferencesRequest.getter(GetChannelMembershipPreferencesRequest::channelArn)).setter(GetChannelMembershipPreferencesRequest.setter(Builder::channelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelArn").build()}).build();
    private static final SdkField<String> MEMBER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MemberArn").getter(GetChannelMembershipPreferencesRequest.getter(GetChannelMembershipPreferencesRequest::memberArn)).setter(GetChannelMembershipPreferencesRequest.setter(Builder::memberArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("memberArn").build()}).build();
    private static final SdkField<String> CHIME_BEARER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChimeBearer").getter(GetChannelMembershipPreferencesRequest.getter(GetChannelMembershipPreferencesRequest::chimeBearer)).setter(GetChannelMembershipPreferencesRequest.setter(Builder::chimeBearer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-chime-bearer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD, MEMBER_ARN_FIELD, CHIME_BEARER_FIELD));
    private final String channelArn;
    private final String memberArn;
    private final String chimeBearer;

    private GetChannelMembershipPreferencesRequest(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.memberArn = builder.memberArn;
        this.chimeBearer = builder.chimeBearer;
    }

    public final String channelArn() {
        return this.channelArn;
    }

    public final String memberArn() {
        return this.memberArn;
    }

    public final String chimeBearer() {
        return this.chimeBearer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.chimeBearer());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetChannelMembershipPreferencesRequest)) {
            return false;
        }
        GetChannelMembershipPreferencesRequest other = (GetChannelMembershipPreferencesRequest)((Object)obj);
        return Objects.equals(this.channelArn(), other.channelArn()) && Objects.equals(this.memberArn(), other.memberArn()) && Objects.equals(this.chimeBearer(), other.chimeBearer());
    }

    public final String toString() {
        return ToString.builder((String)"GetChannelMembershipPreferencesRequest").add("ChannelArn", (Object)this.channelArn()).add("MemberArn", (Object)this.memberArn()).add("ChimeBearer", (Object)this.chimeBearer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelArn": {
                return Optional.ofNullable(clazz.cast(this.channelArn()));
            }
            case "MemberArn": {
                return Optional.ofNullable(clazz.cast(this.memberArn()));
            }
            case "ChimeBearer": {
                return Optional.ofNullable(clazz.cast(this.chimeBearer()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetChannelMembershipPreferencesRequest, T> g) {
        return obj -> g.apply((GetChannelMembershipPreferencesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkMessagingRequest.BuilderImpl
    implements Builder {
        private String channelArn;
        private String memberArn;
        private String chimeBearer;

        private BuilderImpl() {
        }

        private BuilderImpl(GetChannelMembershipPreferencesRequest model) {
            super(model);
            this.channelArn(model.channelArn);
            this.memberArn(model.memberArn);
            this.chimeBearer(model.chimeBearer);
        }

        public final String getChannelArn() {
            return this.channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getMemberArn() {
            return this.memberArn;
        }

        public final void setMemberArn(String memberArn) {
            this.memberArn = memberArn;
        }

        @Override
        public final Builder memberArn(String memberArn) {
            this.memberArn = memberArn;
            return this;
        }

        public final String getChimeBearer() {
            return this.chimeBearer;
        }

        public final void setChimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
        }

        @Override
        public final Builder chimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetChannelMembershipPreferencesRequest build() {
            return new GetChannelMembershipPreferencesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeSdkMessagingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetChannelMembershipPreferencesRequest> {
        public Builder channelArn(String var1);

        public Builder memberArn(String var1);

        public Builder chimeBearer(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

