/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a channel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Channel implements SdkPojo, Serializable, ToCopyableBuilder<Channel.Builder, Channel> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Channel::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelArn").getter(getter(Channel::channelArn)).setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelArn").build()).build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mode")
            .getter(getter(Channel::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()).build();

    private static final SdkField<String> PRIVACY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Privacy")
            .getter(getter(Channel::privacyAsString)).setter(setter(Builder::privacy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Privacy").build()).build();

    private static final SdkField<String> METADATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Metadata").getter(getter(Channel::metadata)).setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()).build();

    private static final SdkField<Identity> CREATED_BY_FIELD = SdkField.<Identity> builder(MarshallingType.SDK_POJO)
            .memberName("CreatedBy").getter(getter(Channel::createdBy)).setter(setter(Builder::createdBy))
            .constructor(Identity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(Channel::createdTimestamp)).setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<Instant> LAST_MESSAGE_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastMessageTimestamp").getter(getter(Channel::lastMessageTimestamp))
            .setter(setter(Builder::lastMessageTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastMessageTimestamp").build())
            .build();

    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTimestamp").getter(getter(Channel::lastUpdatedTimestamp))
            .setter(setter(Builder::lastUpdatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build())
            .build();

    private static final SdkField<String> CHANNEL_FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelFlowArn").getter(getter(Channel::channelFlowArn)).setter(setter(Builder::channelFlowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelFlowArn").build()).build();

    private static final SdkField<ElasticChannelConfiguration> ELASTIC_CHANNEL_CONFIGURATION_FIELD = SdkField
            .<ElasticChannelConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ElasticChannelConfiguration")
            .getter(getter(Channel::elasticChannelConfiguration))
            .setter(setter(Builder::elasticChannelConfiguration))
            .constructor(ElasticChannelConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticChannelConfiguration")
                    .build()).build();

    private static final SdkField<ExpirationSettings> EXPIRATION_SETTINGS_FIELD = SdkField
            .<ExpirationSettings> builder(MarshallingType.SDK_POJO).memberName("ExpirationSettings")
            .getter(getter(Channel::expirationSettings)).setter(setter(Builder::expirationSettings))
            .constructor(ExpirationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(NAME_FIELD, CHANNEL_ARN_FIELD, MODE_FIELD, PRIVACY_FIELD, METADATA_FIELD,
                    CREATED_BY_FIELD, CREATED_TIMESTAMP_FIELD, LAST_MESSAGE_TIMESTAMP_FIELD, LAST_UPDATED_TIMESTAMP_FIELD,
                    CHANNEL_FLOW_ARN_FIELD, ELASTIC_CHANNEL_CONFIGURATION_FIELD, EXPIRATION_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String channelArn;

    private final String mode;

    private final String privacy;

    private final String metadata;

    private final Identity createdBy;

    private final Instant createdTimestamp;

    private final Instant lastMessageTimestamp;

    private final Instant lastUpdatedTimestamp;

    private final String channelFlowArn;

    private final ElasticChannelConfiguration elasticChannelConfiguration;

    private final ExpirationSettings expirationSettings;

    private Channel(BuilderImpl builder) {
        this.name = builder.name;
        this.channelArn = builder.channelArn;
        this.mode = builder.mode;
        this.privacy = builder.privacy;
        this.metadata = builder.metadata;
        this.createdBy = builder.createdBy;
        this.createdTimestamp = builder.createdTimestamp;
        this.lastMessageTimestamp = builder.lastMessageTimestamp;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.channelFlowArn = builder.channelFlowArn;
        this.elasticChannelConfiguration = builder.elasticChannelConfiguration;
        this.expirationSettings = builder.expirationSettings;
    }

    /**
     * <p>
     * The name of a channel.
     * </p>
     * 
     * @return The name of a channel.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ARN of a channel.
     * </p>
     * 
     * @return The ARN of a channel.
     */
    public final String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * The mode of the channel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ChannelMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The mode of the channel.
     * @see ChannelMode
     */
    public final ChannelMode mode() {
        return ChannelMode.fromValue(mode);
    }

    /**
     * <p>
     * The mode of the channel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ChannelMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The mode of the channel.
     * @see ChannelMode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * The channel's privacy setting.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #privacy} will
     * return {@link ChannelPrivacy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #privacyAsString}.
     * </p>
     * 
     * @return The channel's privacy setting.
     * @see ChannelPrivacy
     */
    public final ChannelPrivacy privacy() {
        return ChannelPrivacy.fromValue(privacy);
    }

    /**
     * <p>
     * The channel's privacy setting.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #privacy} will
     * return {@link ChannelPrivacy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #privacyAsString}.
     * </p>
     * 
     * @return The channel's privacy setting.
     * @see ChannelPrivacy
     */
    public final String privacyAsString() {
        return privacy;
    }

    /**
     * <p>
     * The channel's metadata.
     * </p>
     * 
     * @return The channel's metadata.
     */
    public final String metadata() {
        return metadata;
    }

    /**
     * <p>
     * The <code>AppInstanceUser</code> who created the channel.
     * </p>
     * 
     * @return The <code>AppInstanceUser</code> who created the channel.
     */
    public final Identity createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The time at which the <code>AppInstanceUser</code> created the channel.
     * </p>
     * 
     * @return The time at which the <code>AppInstanceUser</code> created the channel.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The time at which a member sent the last message in the channel.
     * </p>
     * 
     * @return The time at which a member sent the last message in the channel.
     */
    public final Instant lastMessageTimestamp() {
        return lastMessageTimestamp;
    }

    /**
     * <p>
     * The time at which a channel was last updated.
     * </p>
     * 
     * @return The time at which a channel was last updated.
     */
    public final Instant lastUpdatedTimestamp() {
        return lastUpdatedTimestamp;
    }

    /**
     * <p>
     * The ARN of the channel flow.
     * </p>
     * 
     * @return The ARN of the channel flow.
     */
    public final String channelFlowArn() {
        return channelFlowArn;
    }

    /**
     * <p>
     * The attributes required to configure and create an elastic channel. An elastic channel can support a maximum of
     * 1-million members.
     * </p>
     * 
     * @return The attributes required to configure and create an elastic channel. An elastic channel can support a
     *         maximum of 1-million members.
     */
    public final ElasticChannelConfiguration elasticChannelConfiguration() {
        return elasticChannelConfiguration;
    }

    /**
     * <p>
     * Settings that control when a channel expires.
     * </p>
     * 
     * @return Settings that control when a channel expires.
     */
    public final ExpirationSettings expirationSettings() {
        return expirationSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(privacyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastMessageTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(channelFlowArn());
        hashCode = 31 * hashCode + Objects.hashCode(elasticChannelConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(expirationSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Channel)) {
            return false;
        }
        Channel other = (Channel) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(channelArn(), other.channelArn())
                && Objects.equals(modeAsString(), other.modeAsString())
                && Objects.equals(privacyAsString(), other.privacyAsString()) && Objects.equals(metadata(), other.metadata())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(lastMessageTimestamp(), other.lastMessageTimestamp())
                && Objects.equals(lastUpdatedTimestamp(), other.lastUpdatedTimestamp())
                && Objects.equals(channelFlowArn(), other.channelFlowArn())
                && Objects.equals(elasticChannelConfiguration(), other.elasticChannelConfiguration())
                && Objects.equals(expirationSettings(), other.expirationSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Channel").add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ChannelArn", channelArn()).add("Mode", modeAsString()).add("Privacy", privacyAsString())
                .add("Metadata", metadata() == null ? null : "*** Sensitive Data Redacted ***").add("CreatedBy", createdBy())
                .add("CreatedTimestamp", createdTimestamp()).add("LastMessageTimestamp", lastMessageTimestamp())
                .add("LastUpdatedTimestamp", lastUpdatedTimestamp()).add("ChannelFlowArn", channelFlowArn())
                .add("ElasticChannelConfiguration", elasticChannelConfiguration())
                .add("ExpirationSettings", expirationSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ChannelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "Privacy":
            return Optional.ofNullable(clazz.cast(privacyAsString()));
        case "Metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "LastMessageTimestamp":
            return Optional.ofNullable(clazz.cast(lastMessageTimestamp()));
        case "LastUpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(lastUpdatedTimestamp()));
        case "ChannelFlowArn":
            return Optional.ofNullable(clazz.cast(channelFlowArn()));
        case "ElasticChannelConfiguration":
            return Optional.ofNullable(clazz.cast(elasticChannelConfiguration()));
        case "ExpirationSettings":
            return Optional.ofNullable(clazz.cast(expirationSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Channel, T> g) {
        return obj -> g.apply((Channel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Channel> {
        /**
         * <p>
         * The name of a channel.
         * </p>
         * 
         * @param name
         *        The name of a channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN of a channel.
         * </p>
         * 
         * @param channelArn
         *        The ARN of a channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * The mode of the channel.
         * </p>
         * 
         * @param mode
         *        The mode of the channel.
         * @see ChannelMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * The mode of the channel.
         * </p>
         * 
         * @param mode
         *        The mode of the channel.
         * @see ChannelMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelMode
         */
        Builder mode(ChannelMode mode);

        /**
         * <p>
         * The channel's privacy setting.
         * </p>
         * 
         * @param privacy
         *        The channel's privacy setting.
         * @see ChannelPrivacy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelPrivacy
         */
        Builder privacy(String privacy);

        /**
         * <p>
         * The channel's privacy setting.
         * </p>
         * 
         * @param privacy
         *        The channel's privacy setting.
         * @see ChannelPrivacy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelPrivacy
         */
        Builder privacy(ChannelPrivacy privacy);

        /**
         * <p>
         * The channel's metadata.
         * </p>
         * 
         * @param metadata
         *        The channel's metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(String metadata);

        /**
         * <p>
         * The <code>AppInstanceUser</code> who created the channel.
         * </p>
         * 
         * @param createdBy
         *        The <code>AppInstanceUser</code> who created the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(Identity createdBy);

        /**
         * <p>
         * The <code>AppInstanceUser</code> who created the channel.
         * </p>
         * This is a convenience method that creates an instance of the {@link Identity.Builder} avoiding the need to
         * create one manually via {@link Identity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Identity.Builder#build()} is called immediately and its result is
         * passed to {@link #createdBy(Identity)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link Identity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(Identity)
         */
        default Builder createdBy(Consumer<Identity.Builder> createdBy) {
            return createdBy(Identity.builder().applyMutation(createdBy).build());
        }

        /**
         * <p>
         * The time at which the <code>AppInstanceUser</code> created the channel.
         * </p>
         * 
         * @param createdTimestamp
         *        The time at which the <code>AppInstanceUser</code> created the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The time at which a member sent the last message in the channel.
         * </p>
         * 
         * @param lastMessageTimestamp
         *        The time at which a member sent the last message in the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastMessageTimestamp(Instant lastMessageTimestamp);

        /**
         * <p>
         * The time at which a channel was last updated.
         * </p>
         * 
         * @param lastUpdatedTimestamp
         *        The time at which a channel was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp);

        /**
         * <p>
         * The ARN of the channel flow.
         * </p>
         * 
         * @param channelFlowArn
         *        The ARN of the channel flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelFlowArn(String channelFlowArn);

        /**
         * <p>
         * The attributes required to configure and create an elastic channel. An elastic channel can support a maximum
         * of 1-million members.
         * </p>
         * 
         * @param elasticChannelConfiguration
         *        The attributes required to configure and create an elastic channel. An elastic channel can support a
         *        maximum of 1-million members.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticChannelConfiguration(ElasticChannelConfiguration elasticChannelConfiguration);

        /**
         * <p>
         * The attributes required to configure and create an elastic channel. An elastic channel can support a maximum
         * of 1-million members.
         * </p>
         * This is a convenience method that creates an instance of the {@link ElasticChannelConfiguration.Builder}
         * avoiding the need to create one manually via {@link ElasticChannelConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ElasticChannelConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #elasticChannelConfiguration(ElasticChannelConfiguration)}.
         * 
         * @param elasticChannelConfiguration
         *        a consumer that will call methods on {@link ElasticChannelConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticChannelConfiguration(ElasticChannelConfiguration)
         */
        default Builder elasticChannelConfiguration(Consumer<ElasticChannelConfiguration.Builder> elasticChannelConfiguration) {
            return elasticChannelConfiguration(ElasticChannelConfiguration.builder().applyMutation(elasticChannelConfiguration)
                    .build());
        }

        /**
         * <p>
         * Settings that control when a channel expires.
         * </p>
         * 
         * @param expirationSettings
         *        Settings that control when a channel expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationSettings(ExpirationSettings expirationSettings);

        /**
         * <p>
         * Settings that control when a channel expires.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExpirationSettings.Builder} avoiding the
         * need to create one manually via {@link ExpirationSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExpirationSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #expirationSettings(ExpirationSettings)}.
         * 
         * @param expirationSettings
         *        a consumer that will call methods on {@link ExpirationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expirationSettings(ExpirationSettings)
         */
        default Builder expirationSettings(Consumer<ExpirationSettings.Builder> expirationSettings) {
            return expirationSettings(ExpirationSettings.builder().applyMutation(expirationSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String channelArn;

        private String mode;

        private String privacy;

        private String metadata;

        private Identity createdBy;

        private Instant createdTimestamp;

        private Instant lastMessageTimestamp;

        private Instant lastUpdatedTimestamp;

        private String channelFlowArn;

        private ElasticChannelConfiguration elasticChannelConfiguration;

        private ExpirationSettings expirationSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(Channel model) {
            name(model.name);
            channelArn(model.channelArn);
            mode(model.mode);
            privacy(model.privacy);
            metadata(model.metadata);
            createdBy(model.createdBy);
            createdTimestamp(model.createdTimestamp);
            lastMessageTimestamp(model.lastMessageTimestamp);
            lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            channelFlowArn(model.channelFlowArn);
            elasticChannelConfiguration(model.elasticChannelConfiguration);
            expirationSettings(model.expirationSettings);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getChannelArn() {
            return channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ChannelMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getPrivacy() {
            return privacy;
        }

        public final void setPrivacy(String privacy) {
            this.privacy = privacy;
        }

        @Override
        public final Builder privacy(String privacy) {
            this.privacy = privacy;
            return this;
        }

        @Override
        public final Builder privacy(ChannelPrivacy privacy) {
            this.privacy(privacy == null ? null : privacy.toString());
            return this;
        }

        public final String getMetadata() {
            return metadata;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final Identity.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(Identity.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(Identity createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getLastMessageTimestamp() {
            return lastMessageTimestamp;
        }

        public final void setLastMessageTimestamp(Instant lastMessageTimestamp) {
            this.lastMessageTimestamp = lastMessageTimestamp;
        }

        @Override
        public final Builder lastMessageTimestamp(Instant lastMessageTimestamp) {
            this.lastMessageTimestamp = lastMessageTimestamp;
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final String getChannelFlowArn() {
            return channelFlowArn;
        }

        public final void setChannelFlowArn(String channelFlowArn) {
            this.channelFlowArn = channelFlowArn;
        }

        @Override
        public final Builder channelFlowArn(String channelFlowArn) {
            this.channelFlowArn = channelFlowArn;
            return this;
        }

        public final ElasticChannelConfiguration.Builder getElasticChannelConfiguration() {
            return elasticChannelConfiguration != null ? elasticChannelConfiguration.toBuilder() : null;
        }

        public final void setElasticChannelConfiguration(ElasticChannelConfiguration.BuilderImpl elasticChannelConfiguration) {
            this.elasticChannelConfiguration = elasticChannelConfiguration != null ? elasticChannelConfiguration.build() : null;
        }

        @Override
        public final Builder elasticChannelConfiguration(ElasticChannelConfiguration elasticChannelConfiguration) {
            this.elasticChannelConfiguration = elasticChannelConfiguration;
            return this;
        }

        public final ExpirationSettings.Builder getExpirationSettings() {
            return expirationSettings != null ? expirationSettings.toBuilder() : null;
        }

        public final void setExpirationSettings(ExpirationSettings.BuilderImpl expirationSettings) {
            this.expirationSettings = expirationSettings != null ? expirationSettings.build() : null;
        }

        @Override
        public final Builder expirationSettings(ExpirationSettings expirationSettings) {
            this.expirationSettings = expirationSettings;
            return this;
        }

        @Override
        public Channel build() {
            return new Channel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
