/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateChannelFlowRequest extends ChimeSdkMessagingRequest implements
        ToCopyableBuilder<AssociateChannelFlowRequest.Builder, AssociateChannelFlowRequest> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelArn").getter(getter(AssociateChannelFlowRequest::channelArn)).setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelArn").build()).build();

    private static final SdkField<String> CHANNEL_FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelFlowArn").getter(getter(AssociateChannelFlowRequest::channelFlowArn))
            .setter(setter(Builder::channelFlowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelFlowArn").build()).build();

    private static final SdkField<String> CHIME_BEARER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChimeBearer").getter(getter(AssociateChannelFlowRequest::chimeBearer))
            .setter(setter(Builder::chimeBearer))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-chime-bearer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD,
            CHANNEL_FLOW_ARN_FIELD, CHIME_BEARER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String channelArn;

    private final String channelFlowArn;

    private final String chimeBearer;

    private AssociateChannelFlowRequest(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.channelFlowArn = builder.channelFlowArn;
        this.chimeBearer = builder.chimeBearer;
    }

    /**
     * <p>
     * The ARN of the channel.
     * </p>
     * 
     * @return The ARN of the channel.
     */
    public final String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * The ARN of the channel flow.
     * </p>
     * 
     * @return The ARN of the channel flow.
     */
    public final String channelFlowArn() {
        return channelFlowArn;
    }

    /**
     * <p>
     * The <code>AppInstanceUserArn</code> of the user making the API call.
     * </p>
     * 
     * @return The <code>AppInstanceUserArn</code> of the user making the API call.
     */
    public final String chimeBearer() {
        return chimeBearer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(channelFlowArn());
        hashCode = 31 * hashCode + Objects.hashCode(chimeBearer());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateChannelFlowRequest)) {
            return false;
        }
        AssociateChannelFlowRequest other = (AssociateChannelFlowRequest) obj;
        return Objects.equals(channelArn(), other.channelArn()) && Objects.equals(channelFlowArn(), other.channelFlowArn())
                && Objects.equals(chimeBearer(), other.chimeBearer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateChannelFlowRequest").add("ChannelArn", channelArn())
                .add("ChannelFlowArn", channelFlowArn()).add("ChimeBearer", chimeBearer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "ChannelFlowArn":
            return Optional.ofNullable(clazz.cast(channelFlowArn()));
        case "ChimeBearer":
            return Optional.ofNullable(clazz.cast(chimeBearer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("channelArn", CHANNEL_ARN_FIELD);
        map.put("ChannelFlowArn", CHANNEL_FLOW_ARN_FIELD);
        map.put("x-amz-chime-bearer", CHIME_BEARER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateChannelFlowRequest, T> g) {
        return obj -> g.apply((AssociateChannelFlowRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMessagingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateChannelFlowRequest> {
        /**
         * <p>
         * The ARN of the channel.
         * </p>
         * 
         * @param channelArn
         *        The ARN of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * The ARN of the channel flow.
         * </p>
         * 
         * @param channelFlowArn
         *        The ARN of the channel flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelFlowArn(String channelFlowArn);

        /**
         * <p>
         * The <code>AppInstanceUserArn</code> of the user making the API call.
         * </p>
         * 
         * @param chimeBearer
         *        The <code>AppInstanceUserArn</code> of the user making the API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chimeBearer(String chimeBearer);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkMessagingRequest.BuilderImpl implements Builder {
        private String channelArn;

        private String channelFlowArn;

        private String chimeBearer;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateChannelFlowRequest model) {
            super(model);
            channelArn(model.channelArn);
            channelFlowArn(model.channelFlowArn);
            chimeBearer(model.chimeBearer);
        }

        public final String getChannelArn() {
            return channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getChannelFlowArn() {
            return channelFlowArn;
        }

        public final void setChannelFlowArn(String channelFlowArn) {
            this.channelFlowArn = channelFlowArn;
        }

        @Override
        public final Builder channelFlowArn(String channelFlowArn) {
            this.channelFlowArn = channelFlowArn;
            return this;
        }

        public final String getChimeBearer() {
            return chimeBearer;
        }

        public final void setChimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
        }

        @Override
        public final Builder chimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateChannelFlowRequest build() {
            return new AssociateChannelFlowRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
