/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary of details of a channel associated with channel flow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChannelAssociatedWithFlowSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ChannelAssociatedWithFlowSummary.Builder, ChannelAssociatedWithFlowSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ChannelAssociatedWithFlowSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelArn").getter(getter(ChannelAssociatedWithFlowSummary::channelArn))
            .setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelArn").build()).build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mode")
            .getter(getter(ChannelAssociatedWithFlowSummary::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()).build();

    private static final SdkField<String> PRIVACY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Privacy")
            .getter(getter(ChannelAssociatedWithFlowSummary::privacyAsString)).setter(setter(Builder::privacy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Privacy").build()).build();

    private static final SdkField<String> METADATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Metadata").getter(getter(ChannelAssociatedWithFlowSummary::metadata)).setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CHANNEL_ARN_FIELD,
            MODE_FIELD, PRIVACY_FIELD, METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String channelArn;

    private final String mode;

    private final String privacy;

    private final String metadata;

    private ChannelAssociatedWithFlowSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.channelArn = builder.channelArn;
        this.mode = builder.mode;
        this.privacy = builder.privacy;
        this.metadata = builder.metadata;
    }

    /**
     * <p>
     * The name of the channel flow.
     * </p>
     * 
     * @return The name of the channel flow.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ARN of the channel.
     * </p>
     * 
     * @return The ARN of the channel.
     */
    public final String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * The mode of the channel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ChannelMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The mode of the channel.
     * @see ChannelMode
     */
    public final ChannelMode mode() {
        return ChannelMode.fromValue(mode);
    }

    /**
     * <p>
     * The mode of the channel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ChannelMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The mode of the channel.
     * @see ChannelMode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * The channel's privacy setting.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #privacy} will
     * return {@link ChannelPrivacy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #privacyAsString}.
     * </p>
     * 
     * @return The channel's privacy setting.
     * @see ChannelPrivacy
     */
    public final ChannelPrivacy privacy() {
        return ChannelPrivacy.fromValue(privacy);
    }

    /**
     * <p>
     * The channel's privacy setting.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #privacy} will
     * return {@link ChannelPrivacy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #privacyAsString}.
     * </p>
     * 
     * @return The channel's privacy setting.
     * @see ChannelPrivacy
     */
    public final String privacyAsString() {
        return privacy;
    }

    /**
     * <p>
     * The channel's metadata.
     * </p>
     * 
     * @return The channel's metadata.
     */
    public final String metadata() {
        return metadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(privacyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelAssociatedWithFlowSummary)) {
            return false;
        }
        ChannelAssociatedWithFlowSummary other = (ChannelAssociatedWithFlowSummary) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(channelArn(), other.channelArn())
                && Objects.equals(modeAsString(), other.modeAsString())
                && Objects.equals(privacyAsString(), other.privacyAsString()) && Objects.equals(metadata(), other.metadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChannelAssociatedWithFlowSummary")
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("ChannelArn", channelArn())
                .add("Mode", modeAsString()).add("Privacy", privacyAsString())
                .add("Metadata", metadata() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ChannelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "Privacy":
            return Optional.ofNullable(clazz.cast(privacyAsString()));
        case "Metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("ChannelArn", CHANNEL_ARN_FIELD);
        map.put("Mode", MODE_FIELD);
        map.put("Privacy", PRIVACY_FIELD);
        map.put("Metadata", METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChannelAssociatedWithFlowSummary, T> g) {
        return obj -> g.apply((ChannelAssociatedWithFlowSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChannelAssociatedWithFlowSummary> {
        /**
         * <p>
         * The name of the channel flow.
         * </p>
         * 
         * @param name
         *        The name of the channel flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN of the channel.
         * </p>
         * 
         * @param channelArn
         *        The ARN of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * The mode of the channel.
         * </p>
         * 
         * @param mode
         *        The mode of the channel.
         * @see ChannelMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * The mode of the channel.
         * </p>
         * 
         * @param mode
         *        The mode of the channel.
         * @see ChannelMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelMode
         */
        Builder mode(ChannelMode mode);

        /**
         * <p>
         * The channel's privacy setting.
         * </p>
         * 
         * @param privacy
         *        The channel's privacy setting.
         * @see ChannelPrivacy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelPrivacy
         */
        Builder privacy(String privacy);

        /**
         * <p>
         * The channel's privacy setting.
         * </p>
         * 
         * @param privacy
         *        The channel's privacy setting.
         * @see ChannelPrivacy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelPrivacy
         */
        Builder privacy(ChannelPrivacy privacy);

        /**
         * <p>
         * The channel's metadata.
         * </p>
         * 
         * @param metadata
         *        The channel's metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(String metadata);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String channelArn;

        private String mode;

        private String privacy;

        private String metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelAssociatedWithFlowSummary model) {
            name(model.name);
            channelArn(model.channelArn);
            mode(model.mode);
            privacy(model.privacy);
            metadata(model.metadata);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getChannelArn() {
            return channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ChannelMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getPrivacy() {
            return privacy;
        }

        public final void setPrivacy(String privacy) {
            this.privacy = privacy;
        }

        @Override
        public final Builder privacy(String privacy) {
            this.privacy = privacy;
            return this;
        }

        @Override
        public final Builder privacy(ChannelPrivacy privacy) {
            this.privacy(privacy == null ? null : privacy.toString());
            return this;
        }

        public final String getMetadata() {
            return metadata;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public ChannelAssociatedWithFlowSummary build() {
            return new ChannelAssociatedWithFlowSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
