/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateChannelRequest extends ChimeSdkMessagingRequest implements
        ToCopyableBuilder<CreateChannelRequest.Builder, CreateChannelRequest> {
    private static final SdkField<String> APP_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppInstanceArn").getter(getter(CreateChannelRequest::appInstanceArn))
            .setter(setter(Builder::appInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstanceArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateChannelRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mode")
            .getter(getter(CreateChannelRequest::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()).build();

    private static final SdkField<String> PRIVACY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Privacy")
            .getter(getter(CreateChannelRequest::privacyAsString)).setter(setter(Builder::privacy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Privacy").build()).build();

    private static final SdkField<String> METADATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Metadata").getter(getter(CreateChannelRequest::metadata)).setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateChannelRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateChannelRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CHIME_BEARER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChimeBearer").getter(getter(CreateChannelRequest::chimeBearer)).setter(setter(Builder::chimeBearer))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-chime-bearer").build()).build();

    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelId").getter(getter(CreateChannelRequest::channelId)).setter(setter(Builder::channelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelId").build()).build();

    private static final SdkField<List<String>> MEMBER_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MemberArns")
            .getter(getter(CreateChannelRequest::memberArns))
            .setter(setter(Builder::memberArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> MODERATOR_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ModeratorArns")
            .getter(getter(CreateChannelRequest::moderatorArns))
            .setter(setter(Builder::moderatorArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModeratorArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ElasticChannelConfiguration> ELASTIC_CHANNEL_CONFIGURATION_FIELD = SdkField
            .<ElasticChannelConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ElasticChannelConfiguration")
            .getter(getter(CreateChannelRequest::elasticChannelConfiguration))
            .setter(setter(Builder::elasticChannelConfiguration))
            .constructor(ElasticChannelConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticChannelConfiguration")
                    .build()).build();

    private static final SdkField<ExpirationSettings> EXPIRATION_SETTINGS_FIELD = SdkField
            .<ExpirationSettings> builder(MarshallingType.SDK_POJO).memberName("ExpirationSettings")
            .getter(getter(CreateChannelRequest::expirationSettings)).setter(setter(Builder::expirationSettings))
            .constructor(ExpirationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_ARN_FIELD,
            NAME_FIELD, MODE_FIELD, PRIVACY_FIELD, METADATA_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD, CHIME_BEARER_FIELD,
            CHANNEL_ID_FIELD, MEMBER_ARNS_FIELD, MODERATOR_ARNS_FIELD, ELASTIC_CHANNEL_CONFIGURATION_FIELD,
            EXPIRATION_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String appInstanceArn;

    private final String name;

    private final String mode;

    private final String privacy;

    private final String metadata;

    private final String clientRequestToken;

    private final List<Tag> tags;

    private final String chimeBearer;

    private final String channelId;

    private final List<String> memberArns;

    private final List<String> moderatorArns;

    private final ElasticChannelConfiguration elasticChannelConfiguration;

    private final ExpirationSettings expirationSettings;

    private CreateChannelRequest(BuilderImpl builder) {
        super(builder);
        this.appInstanceArn = builder.appInstanceArn;
        this.name = builder.name;
        this.mode = builder.mode;
        this.privacy = builder.privacy;
        this.metadata = builder.metadata;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
        this.chimeBearer = builder.chimeBearer;
        this.channelId = builder.channelId;
        this.memberArns = builder.memberArns;
        this.moderatorArns = builder.moderatorArns;
        this.elasticChannelConfiguration = builder.elasticChannelConfiguration;
        this.expirationSettings = builder.expirationSettings;
    }

    /**
     * <p>
     * The ARN of the channel request.
     * </p>
     * 
     * @return The ARN of the channel request.
     */
    public final String appInstanceArn() {
        return appInstanceArn;
    }

    /**
     * <p>
     * The name of the channel.
     * </p>
     * 
     * @return The name of the channel.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The channel mode: <code>UNRESTRICTED</code> or <code>RESTRICTED</code>. Administrators, moderators, and channel
     * members can add themselves and other members to unrestricted channels. Only administrators and moderators can add
     * members to restricted channels.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ChannelMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The channel mode: <code>UNRESTRICTED</code> or <code>RESTRICTED</code>. Administrators, moderators, and
     *         channel members can add themselves and other members to unrestricted channels. Only administrators and
     *         moderators can add members to restricted channels.
     * @see ChannelMode
     */
    public final ChannelMode mode() {
        return ChannelMode.fromValue(mode);
    }

    /**
     * <p>
     * The channel mode: <code>UNRESTRICTED</code> or <code>RESTRICTED</code>. Administrators, moderators, and channel
     * members can add themselves and other members to unrestricted channels. Only administrators and moderators can add
     * members to restricted channels.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ChannelMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The channel mode: <code>UNRESTRICTED</code> or <code>RESTRICTED</code>. Administrators, moderators, and
     *         channel members can add themselves and other members to unrestricted channels. Only administrators and
     *         moderators can add members to restricted channels.
     * @see ChannelMode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * The channel's privacy level: <code>PUBLIC</code> or <code>PRIVATE</code>. Private channels aren't discoverable by
     * users outside the channel. Public channels are discoverable by anyone in the <code>AppInstance</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #privacy} will
     * return {@link ChannelPrivacy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #privacyAsString}.
     * </p>
     * 
     * @return The channel's privacy level: <code>PUBLIC</code> or <code>PRIVATE</code>. Private channels aren't
     *         discoverable by users outside the channel. Public channels are discoverable by anyone in the
     *         <code>AppInstance</code>.
     * @see ChannelPrivacy
     */
    public final ChannelPrivacy privacy() {
        return ChannelPrivacy.fromValue(privacy);
    }

    /**
     * <p>
     * The channel's privacy level: <code>PUBLIC</code> or <code>PRIVATE</code>. Private channels aren't discoverable by
     * users outside the channel. Public channels are discoverable by anyone in the <code>AppInstance</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #privacy} will
     * return {@link ChannelPrivacy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #privacyAsString}.
     * </p>
     * 
     * @return The channel's privacy level: <code>PUBLIC</code> or <code>PRIVATE</code>. Private channels aren't
     *         discoverable by users outside the channel. Public channels are discoverable by anyone in the
     *         <code>AppInstance</code>.
     * @see ChannelPrivacy
     */
    public final String privacyAsString() {
        return privacy;
    }

    /**
     * <p>
     * The metadata of the creation request. Limited to 1KB and UTF-8.
     * </p>
     * 
     * @return The metadata of the creation request. Limited to 1KB and UTF-8.
     */
    public final String metadata() {
        return metadata;
    }

    /**
     * <p>
     * The client token for the request. An <code>Idempotency</code> token.
     * </p>
     * 
     * @return The client token for the request. An <code>Idempotency</code> token.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags for the creation request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags for the creation request.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.
     * </p>
     * 
     * @return The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.
     */
    public final String chimeBearer() {
        return chimeBearer;
    }

    /**
     * <p>
     * The ID of the channel in the request.
     * </p>
     * 
     * @return The ID of the channel in the request.
     */
    public final String channelId() {
        return channelId;
    }

    /**
     * For responses, this returns true if the service returned a value for the MemberArns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMemberArns() {
        return memberArns != null && !(memberArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARNs of the channel members in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMemberArns} method.
     * </p>
     * 
     * @return The ARNs of the channel members in the request.
     */
    public final List<String> memberArns() {
        return memberArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the ModeratorArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasModeratorArns() {
        return moderatorArns != null && !(moderatorArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARNs of the channel moderators in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModeratorArns} method.
     * </p>
     * 
     * @return The ARNs of the channel moderators in the request.
     */
    public final List<String> moderatorArns() {
        return moderatorArns;
    }

    /**
     * <p>
     * The attributes required to configure and create an elastic channel. An elastic channel can support a maximum of
     * 1-million users, excluding moderators.
     * </p>
     * 
     * @return The attributes required to configure and create an elastic channel. An elastic channel can support a
     *         maximum of 1-million users, excluding moderators.
     */
    public final ElasticChannelConfiguration elasticChannelConfiguration() {
        return elasticChannelConfiguration;
    }

    /**
     * <p>
     * Settings that control the interval after which the channel is automatically deleted.
     * </p>
     * 
     * @return Settings that control the interval after which the channel is automatically deleted.
     */
    public final ExpirationSettings expirationSettings() {
        return expirationSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(privacyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(chimeBearer());
        hashCode = 31 * hashCode + Objects.hashCode(channelId());
        hashCode = 31 * hashCode + Objects.hashCode(hasMemberArns() ? memberArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasModeratorArns() ? moderatorArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(elasticChannelConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(expirationSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChannelRequest)) {
            return false;
        }
        CreateChannelRequest other = (CreateChannelRequest) obj;
        return Objects.equals(appInstanceArn(), other.appInstanceArn()) && Objects.equals(name(), other.name())
                && Objects.equals(modeAsString(), other.modeAsString())
                && Objects.equals(privacyAsString(), other.privacyAsString()) && Objects.equals(metadata(), other.metadata())
                && Objects.equals(clientRequestToken(), other.clientRequestToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(chimeBearer(), other.chimeBearer())
                && Objects.equals(channelId(), other.channelId()) && hasMemberArns() == other.hasMemberArns()
                && Objects.equals(memberArns(), other.memberArns()) && hasModeratorArns() == other.hasModeratorArns()
                && Objects.equals(moderatorArns(), other.moderatorArns())
                && Objects.equals(elasticChannelConfiguration(), other.elasticChannelConfiguration())
                && Objects.equals(expirationSettings(), other.expirationSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateChannelRequest").add("AppInstanceArn", appInstanceArn())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("Mode", modeAsString())
                .add("Privacy", privacyAsString()).add("Metadata", metadata() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ClientRequestToken", clientRequestToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Tags", hasTags() ? tags() : null).add("ChimeBearer", chimeBearer())
                .add("ChannelId", channelId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MemberArns", hasMemberArns() ? memberArns() : null)
                .add("ModeratorArns", hasModeratorArns() ? moderatorArns() : null)
                .add("ElasticChannelConfiguration", elasticChannelConfiguration())
                .add("ExpirationSettings", expirationSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppInstanceArn":
            return Optional.ofNullable(clazz.cast(appInstanceArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "Privacy":
            return Optional.ofNullable(clazz.cast(privacyAsString()));
        case "Metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ChimeBearer":
            return Optional.ofNullable(clazz.cast(chimeBearer()));
        case "ChannelId":
            return Optional.ofNullable(clazz.cast(channelId()));
        case "MemberArns":
            return Optional.ofNullable(clazz.cast(memberArns()));
        case "ModeratorArns":
            return Optional.ofNullable(clazz.cast(moderatorArns()));
        case "ElasticChannelConfiguration":
            return Optional.ofNullable(clazz.cast(elasticChannelConfiguration()));
        case "ExpirationSettings":
            return Optional.ofNullable(clazz.cast(expirationSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AppInstanceArn", APP_INSTANCE_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Mode", MODE_FIELD);
        map.put("Privacy", PRIVACY_FIELD);
        map.put("Metadata", METADATA_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("x-amz-chime-bearer", CHIME_BEARER_FIELD);
        map.put("ChannelId", CHANNEL_ID_FIELD);
        map.put("MemberArns", MEMBER_ARNS_FIELD);
        map.put("ModeratorArns", MODERATOR_ARNS_FIELD);
        map.put("ElasticChannelConfiguration", ELASTIC_CHANNEL_CONFIGURATION_FIELD);
        map.put("ExpirationSettings", EXPIRATION_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateChannelRequest, T> g) {
        return obj -> g.apply((CreateChannelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMessagingRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateChannelRequest> {
        /**
         * <p>
         * The ARN of the channel request.
         * </p>
         * 
         * @param appInstanceArn
         *        The ARN of the channel request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstanceArn(String appInstanceArn);

        /**
         * <p>
         * The name of the channel.
         * </p>
         * 
         * @param name
         *        The name of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The channel mode: <code>UNRESTRICTED</code> or <code>RESTRICTED</code>. Administrators, moderators, and
         * channel members can add themselves and other members to unrestricted channels. Only administrators and
         * moderators can add members to restricted channels.
         * </p>
         * 
         * @param mode
         *        The channel mode: <code>UNRESTRICTED</code> or <code>RESTRICTED</code>. Administrators, moderators,
         *        and channel members can add themselves and other members to unrestricted channels. Only administrators
         *        and moderators can add members to restricted channels.
         * @see ChannelMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * The channel mode: <code>UNRESTRICTED</code> or <code>RESTRICTED</code>. Administrators, moderators, and
         * channel members can add themselves and other members to unrestricted channels. Only administrators and
         * moderators can add members to restricted channels.
         * </p>
         * 
         * @param mode
         *        The channel mode: <code>UNRESTRICTED</code> or <code>RESTRICTED</code>. Administrators, moderators,
         *        and channel members can add themselves and other members to unrestricted channels. Only administrators
         *        and moderators can add members to restricted channels.
         * @see ChannelMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelMode
         */
        Builder mode(ChannelMode mode);

        /**
         * <p>
         * The channel's privacy level: <code>PUBLIC</code> or <code>PRIVATE</code>. Private channels aren't
         * discoverable by users outside the channel. Public channels are discoverable by anyone in the
         * <code>AppInstance</code>.
         * </p>
         * 
         * @param privacy
         *        The channel's privacy level: <code>PUBLIC</code> or <code>PRIVATE</code>. Private channels aren't
         *        discoverable by users outside the channel. Public channels are discoverable by anyone in the
         *        <code>AppInstance</code>.
         * @see ChannelPrivacy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelPrivacy
         */
        Builder privacy(String privacy);

        /**
         * <p>
         * The channel's privacy level: <code>PUBLIC</code> or <code>PRIVATE</code>. Private channels aren't
         * discoverable by users outside the channel. Public channels are discoverable by anyone in the
         * <code>AppInstance</code>.
         * </p>
         * 
         * @param privacy
         *        The channel's privacy level: <code>PUBLIC</code> or <code>PRIVATE</code>. Private channels aren't
         *        discoverable by users outside the channel. Public channels are discoverable by anyone in the
         *        <code>AppInstance</code>.
         * @see ChannelPrivacy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelPrivacy
         */
        Builder privacy(ChannelPrivacy privacy);

        /**
         * <p>
         * The metadata of the creation request. Limited to 1KB and UTF-8.
         * </p>
         * 
         * @param metadata
         *        The metadata of the creation request. Limited to 1KB and UTF-8.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(String metadata);

        /**
         * <p>
         * The client token for the request. An <code>Idempotency</code> token.
         * </p>
         * 
         * @param clientRequestToken
         *        The client token for the request. An <code>Idempotency</code> token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The tags for the creation request.
         * </p>
         * 
         * @param tags
         *        The tags for the creation request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags for the creation request.
         * </p>
         * 
         * @param tags
         *        The tags for the creation request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags for the creation request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkmessaging.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.chimesdkmessaging.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkmessaging.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkmessaging.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.
         * </p>
         * 
         * @param chimeBearer
         *        The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chimeBearer(String chimeBearer);

        /**
         * <p>
         * The ID of the channel in the request.
         * </p>
         * 
         * @param channelId
         *        The ID of the channel in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelId(String channelId);

        /**
         * <p>
         * The ARNs of the channel members in the request.
         * </p>
         * 
         * @param memberArns
         *        The ARNs of the channel members in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberArns(Collection<String> memberArns);

        /**
         * <p>
         * The ARNs of the channel members in the request.
         * </p>
         * 
         * @param memberArns
         *        The ARNs of the channel members in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberArns(String... memberArns);

        /**
         * <p>
         * The ARNs of the channel moderators in the request.
         * </p>
         * 
         * @param moderatorArns
         *        The ARNs of the channel moderators in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder moderatorArns(Collection<String> moderatorArns);

        /**
         * <p>
         * The ARNs of the channel moderators in the request.
         * </p>
         * 
         * @param moderatorArns
         *        The ARNs of the channel moderators in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder moderatorArns(String... moderatorArns);

        /**
         * <p>
         * The attributes required to configure and create an elastic channel. An elastic channel can support a maximum
         * of 1-million users, excluding moderators.
         * </p>
         * 
         * @param elasticChannelConfiguration
         *        The attributes required to configure and create an elastic channel. An elastic channel can support a
         *        maximum of 1-million users, excluding moderators.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticChannelConfiguration(ElasticChannelConfiguration elasticChannelConfiguration);

        /**
         * <p>
         * The attributes required to configure and create an elastic channel. An elastic channel can support a maximum
         * of 1-million users, excluding moderators.
         * </p>
         * This is a convenience method that creates an instance of the {@link ElasticChannelConfiguration.Builder}
         * avoiding the need to create one manually via {@link ElasticChannelConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ElasticChannelConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #elasticChannelConfiguration(ElasticChannelConfiguration)}.
         * 
         * @param elasticChannelConfiguration
         *        a consumer that will call methods on {@link ElasticChannelConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticChannelConfiguration(ElasticChannelConfiguration)
         */
        default Builder elasticChannelConfiguration(Consumer<ElasticChannelConfiguration.Builder> elasticChannelConfiguration) {
            return elasticChannelConfiguration(ElasticChannelConfiguration.builder().applyMutation(elasticChannelConfiguration)
                    .build());
        }

        /**
         * <p>
         * Settings that control the interval after which the channel is automatically deleted.
         * </p>
         * 
         * @param expirationSettings
         *        Settings that control the interval after which the channel is automatically deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationSettings(ExpirationSettings expirationSettings);

        /**
         * <p>
         * Settings that control the interval after which the channel is automatically deleted.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExpirationSettings.Builder} avoiding the
         * need to create one manually via {@link ExpirationSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExpirationSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #expirationSettings(ExpirationSettings)}.
         * 
         * @param expirationSettings
         *        a consumer that will call methods on {@link ExpirationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expirationSettings(ExpirationSettings)
         */
        default Builder expirationSettings(Consumer<ExpirationSettings.Builder> expirationSettings) {
            return expirationSettings(ExpirationSettings.builder().applyMutation(expirationSettings).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkMessagingRequest.BuilderImpl implements Builder {
        private String appInstanceArn;

        private String name;

        private String mode;

        private String privacy;

        private String metadata;

        private String clientRequestToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String chimeBearer;

        private String channelId;

        private List<String> memberArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> moderatorArns = DefaultSdkAutoConstructList.getInstance();

        private ElasticChannelConfiguration elasticChannelConfiguration;

        private ExpirationSettings expirationSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChannelRequest model) {
            super(model);
            appInstanceArn(model.appInstanceArn);
            name(model.name);
            mode(model.mode);
            privacy(model.privacy);
            metadata(model.metadata);
            clientRequestToken(model.clientRequestToken);
            tags(model.tags);
            chimeBearer(model.chimeBearer);
            channelId(model.channelId);
            memberArns(model.memberArns);
            moderatorArns(model.moderatorArns);
            elasticChannelConfiguration(model.elasticChannelConfiguration);
            expirationSettings(model.expirationSettings);
        }

        public final String getAppInstanceArn() {
            return appInstanceArn;
        }

        public final void setAppInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
        }

        @Override
        public final Builder appInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ChannelMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getPrivacy() {
            return privacy;
        }

        public final void setPrivacy(String privacy) {
            this.privacy = privacy;
        }

        @Override
        public final Builder privacy(String privacy) {
            this.privacy = privacy;
            return this;
        }

        @Override
        public final Builder privacy(ChannelPrivacy privacy) {
            this.privacy(privacy == null ? null : privacy.toString());
            return this;
        }

        public final String getMetadata() {
            return metadata;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getChimeBearer() {
            return chimeBearer;
        }

        public final void setChimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
        }

        @Override
        public final Builder chimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
            return this;
        }

        public final String getChannelId() {
            return channelId;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final Collection<String> getMemberArns() {
            if (memberArns instanceof SdkAutoConstructList) {
                return null;
            }
            return memberArns;
        }

        public final void setMemberArns(Collection<String> memberArns) {
            this.memberArns = ChannelMemberArnsCopier.copy(memberArns);
        }

        @Override
        public final Builder memberArns(Collection<String> memberArns) {
            this.memberArns = ChannelMemberArnsCopier.copy(memberArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberArns(String... memberArns) {
            memberArns(Arrays.asList(memberArns));
            return this;
        }

        public final Collection<String> getModeratorArns() {
            if (moderatorArns instanceof SdkAutoConstructList) {
                return null;
            }
            return moderatorArns;
        }

        public final void setModeratorArns(Collection<String> moderatorArns) {
            this.moderatorArns = ChannelModeratorArnsCopier.copy(moderatorArns);
        }

        @Override
        public final Builder moderatorArns(Collection<String> moderatorArns) {
            this.moderatorArns = ChannelModeratorArnsCopier.copy(moderatorArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder moderatorArns(String... moderatorArns) {
            moderatorArns(Arrays.asList(moderatorArns));
            return this;
        }

        public final ElasticChannelConfiguration.Builder getElasticChannelConfiguration() {
            return elasticChannelConfiguration != null ? elasticChannelConfiguration.toBuilder() : null;
        }

        public final void setElasticChannelConfiguration(ElasticChannelConfiguration.BuilderImpl elasticChannelConfiguration) {
            this.elasticChannelConfiguration = elasticChannelConfiguration != null ? elasticChannelConfiguration.build() : null;
        }

        @Override
        public final Builder elasticChannelConfiguration(ElasticChannelConfiguration elasticChannelConfiguration) {
            this.elasticChannelConfiguration = elasticChannelConfiguration;
            return this;
        }

        public final ExpirationSettings.Builder getExpirationSettings() {
            return expirationSettings != null ? expirationSettings.toBuilder() : null;
        }

        public final void setExpirationSettings(ExpirationSettings.BuilderImpl expirationSettings) {
            this.expirationSettings = expirationSettings != null ? expirationSettings.build() : null;
        }

        @Override
        public final Builder expirationSettings(ExpirationSettings expirationSettings) {
            this.expirationSettings = expirationSettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateChannelRequest build() {
            return new CreateChannelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
