/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeChannelBanResponse extends ChimeSdkMessagingResponse implements
        ToCopyableBuilder<DescribeChannelBanResponse.Builder, DescribeChannelBanResponse> {
    private static final SdkField<ChannelBan> CHANNEL_BAN_FIELD = SdkField.<ChannelBan> builder(MarshallingType.SDK_POJO)
            .memberName("ChannelBan").getter(getter(DescribeChannelBanResponse::channelBan)).setter(setter(Builder::channelBan))
            .constructor(ChannelBan::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelBan").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_BAN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ChannelBan channelBan;

    private DescribeChannelBanResponse(BuilderImpl builder) {
        super(builder);
        this.channelBan = builder.channelBan;
    }

    /**
     * <p>
     * The details of the ban.
     * </p>
     * 
     * @return The details of the ban.
     */
    public final ChannelBan channelBan() {
        return channelBan;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelBan());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeChannelBanResponse)) {
            return false;
        }
        DescribeChannelBanResponse other = (DescribeChannelBanResponse) obj;
        return Objects.equals(channelBan(), other.channelBan());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeChannelBanResponse").add("ChannelBan", channelBan()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelBan":
            return Optional.ofNullable(clazz.cast(channelBan()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ChannelBan", CHANNEL_BAN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeChannelBanResponse, T> g) {
        return obj -> g.apply((DescribeChannelBanResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMessagingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeChannelBanResponse> {
        /**
         * <p>
         * The details of the ban.
         * </p>
         * 
         * @param channelBan
         *        The details of the ban.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelBan(ChannelBan channelBan);

        /**
         * <p>
         * The details of the ban.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChannelBan.Builder} avoiding the need to
         * create one manually via {@link ChannelBan#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChannelBan.Builder#build()} is called immediately and its result
         * is passed to {@link #channelBan(ChannelBan)}.
         * 
         * @param channelBan
         *        a consumer that will call methods on {@link ChannelBan.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelBan(ChannelBan)
         */
        default Builder channelBan(Consumer<ChannelBan.Builder> channelBan) {
            return channelBan(ChannelBan.builder().applyMutation(channelBan).build());
        }
    }

    static final class BuilderImpl extends ChimeSdkMessagingResponse.BuilderImpl implements Builder {
        private ChannelBan channelBan;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeChannelBanResponse model) {
            super(model);
            channelBan(model.channelBan);
        }

        public final ChannelBan.Builder getChannelBan() {
            return channelBan != null ? channelBan.toBuilder() : null;
        }

        public final void setChannelBan(ChannelBan.BuilderImpl channelBan) {
            this.channelBan = channelBan != null ? channelBan.build() : null;
        }

        @Override
        public final Builder channelBan(ChannelBan channelBan) {
            this.channelBan = channelBan;
            return this;
        }

        @Override
        public DescribeChannelBanResponse build() {
            return new DescribeChannelBanResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
