/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeChannelMembershipResponse extends ChimeSdkMessagingResponse implements
        ToCopyableBuilder<DescribeChannelMembershipResponse.Builder, DescribeChannelMembershipResponse> {
    private static final SdkField<ChannelMembership> CHANNEL_MEMBERSHIP_FIELD = SdkField
            .<ChannelMembership> builder(MarshallingType.SDK_POJO).memberName("ChannelMembership")
            .getter(getter(DescribeChannelMembershipResponse::channelMembership)).setter(setter(Builder::channelMembership))
            .constructor(ChannelMembership::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelMembership").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_MEMBERSHIP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ChannelMembership channelMembership;

    private DescribeChannelMembershipResponse(BuilderImpl builder) {
        super(builder);
        this.channelMembership = builder.channelMembership;
    }

    /**
     * <p>
     * The details of the membership.
     * </p>
     * 
     * @return The details of the membership.
     */
    public final ChannelMembership channelMembership() {
        return channelMembership;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelMembership());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeChannelMembershipResponse)) {
            return false;
        }
        DescribeChannelMembershipResponse other = (DescribeChannelMembershipResponse) obj;
        return Objects.equals(channelMembership(), other.channelMembership());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeChannelMembershipResponse").add("ChannelMembership", channelMembership()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelMembership":
            return Optional.ofNullable(clazz.cast(channelMembership()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ChannelMembership", CHANNEL_MEMBERSHIP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeChannelMembershipResponse, T> g) {
        return obj -> g.apply((DescribeChannelMembershipResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMessagingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeChannelMembershipResponse> {
        /**
         * <p>
         * The details of the membership.
         * </p>
         * 
         * @param channelMembership
         *        The details of the membership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelMembership(ChannelMembership channelMembership);

        /**
         * <p>
         * The details of the membership.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChannelMembership.Builder} avoiding the
         * need to create one manually via {@link ChannelMembership#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChannelMembership.Builder#build()} is called immediately and its
         * result is passed to {@link #channelMembership(ChannelMembership)}.
         * 
         * @param channelMembership
         *        a consumer that will call methods on {@link ChannelMembership.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelMembership(ChannelMembership)
         */
        default Builder channelMembership(Consumer<ChannelMembership.Builder> channelMembership) {
            return channelMembership(ChannelMembership.builder().applyMutation(channelMembership).build());
        }
    }

    static final class BuilderImpl extends ChimeSdkMessagingResponse.BuilderImpl implements Builder {
        private ChannelMembership channelMembership;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeChannelMembershipResponse model) {
            super(model);
            channelMembership(model.channelMembership);
        }

        public final ChannelMembership.Builder getChannelMembership() {
            return channelMembership != null ? channelMembership.toBuilder() : null;
        }

        public final void setChannelMembership(ChannelMembership.BuilderImpl channelMembership) {
            this.channelMembership = channelMembership != null ? channelMembership.build() : null;
        }

        @Override
        public final Builder channelMembership(ChannelMembership channelMembership) {
            this.channelMembership = channelMembership;
            return this;
        }

        @Override
        public DescribeChannelMembershipResponse build() {
            return new DescribeChannelMembershipResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
