/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The attributes required to configure and create an elastic channel. An elastic channel can support a maximum of
 * 1-million members.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ElasticChannelConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ElasticChannelConfiguration.Builder, ElasticChannelConfiguration> {
    private static final SdkField<Integer> MAXIMUM_SUB_CHANNELS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumSubChannels").getter(getter(ElasticChannelConfiguration::maximumSubChannels))
            .setter(setter(Builder::maximumSubChannels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumSubChannels").build())
            .build();

    private static final SdkField<Integer> TARGET_MEMBERSHIPS_PER_SUB_CHANNEL_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TargetMembershipsPerSubChannel")
            .getter(getter(ElasticChannelConfiguration::targetMembershipsPerSubChannel))
            .setter(setter(Builder::targetMembershipsPerSubChannel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetMembershipsPerSubChannel")
                    .build()).build();

    private static final SdkField<Integer> MINIMUM_MEMBERSHIP_PERCENTAGE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinimumMembershipPercentage")
            .getter(getter(ElasticChannelConfiguration::minimumMembershipPercentage))
            .setter(setter(Builder::minimumMembershipPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumMembershipPercentage")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_SUB_CHANNELS_FIELD,
            TARGET_MEMBERSHIPS_PER_SUB_CHANNEL_FIELD, MINIMUM_MEMBERSHIP_PERCENTAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer maximumSubChannels;

    private final Integer targetMembershipsPerSubChannel;

    private final Integer minimumMembershipPercentage;

    private ElasticChannelConfiguration(BuilderImpl builder) {
        this.maximumSubChannels = builder.maximumSubChannels;
        this.targetMembershipsPerSubChannel = builder.targetMembershipsPerSubChannel;
        this.minimumMembershipPercentage = builder.minimumMembershipPercentage;
    }

    /**
     * <p>
     * The maximum number of SubChannels that you want to allow in the elastic channel.
     * </p>
     * 
     * @return The maximum number of SubChannels that you want to allow in the elastic channel.
     */
    public final Integer maximumSubChannels() {
        return maximumSubChannels;
    }

    /**
     * <p>
     * The maximum number of members allowed in a SubChannel.
     * </p>
     * 
     * @return The maximum number of members allowed in a SubChannel.
     */
    public final Integer targetMembershipsPerSubChannel() {
        return targetMembershipsPerSubChannel;
    }

    /**
     * <p>
     * The minimum allowed percentage of TargetMembershipsPerSubChannel users. Ceil of the calculated value is used in
     * balancing members among SubChannels of the elastic channel.
     * </p>
     * 
     * @return The minimum allowed percentage of TargetMembershipsPerSubChannel users. Ceil of the calculated value is
     *         used in balancing members among SubChannels of the elastic channel.
     */
    public final Integer minimumMembershipPercentage() {
        return minimumMembershipPercentage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maximumSubChannels());
        hashCode = 31 * hashCode + Objects.hashCode(targetMembershipsPerSubChannel());
        hashCode = 31 * hashCode + Objects.hashCode(minimumMembershipPercentage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticChannelConfiguration)) {
            return false;
        }
        ElasticChannelConfiguration other = (ElasticChannelConfiguration) obj;
        return Objects.equals(maximumSubChannels(), other.maximumSubChannels())
                && Objects.equals(targetMembershipsPerSubChannel(), other.targetMembershipsPerSubChannel())
                && Objects.equals(minimumMembershipPercentage(), other.minimumMembershipPercentage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ElasticChannelConfiguration").add("MaximumSubChannels", maximumSubChannels())
                .add("TargetMembershipsPerSubChannel", targetMembershipsPerSubChannel())
                .add("MinimumMembershipPercentage", minimumMembershipPercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaximumSubChannels":
            return Optional.ofNullable(clazz.cast(maximumSubChannels()));
        case "TargetMembershipsPerSubChannel":
            return Optional.ofNullable(clazz.cast(targetMembershipsPerSubChannel()));
        case "MinimumMembershipPercentage":
            return Optional.ofNullable(clazz.cast(minimumMembershipPercentage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MaximumSubChannels", MAXIMUM_SUB_CHANNELS_FIELD);
        map.put("TargetMembershipsPerSubChannel", TARGET_MEMBERSHIPS_PER_SUB_CHANNEL_FIELD);
        map.put("MinimumMembershipPercentage", MINIMUM_MEMBERSHIP_PERCENTAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ElasticChannelConfiguration, T> g) {
        return obj -> g.apply((ElasticChannelConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ElasticChannelConfiguration> {
        /**
         * <p>
         * The maximum number of SubChannels that you want to allow in the elastic channel.
         * </p>
         * 
         * @param maximumSubChannels
         *        The maximum number of SubChannels that you want to allow in the elastic channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumSubChannels(Integer maximumSubChannels);

        /**
         * <p>
         * The maximum number of members allowed in a SubChannel.
         * </p>
         * 
         * @param targetMembershipsPerSubChannel
         *        The maximum number of members allowed in a SubChannel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetMembershipsPerSubChannel(Integer targetMembershipsPerSubChannel);

        /**
         * <p>
         * The minimum allowed percentage of TargetMembershipsPerSubChannel users. Ceil of the calculated value is used
         * in balancing members among SubChannels of the elastic channel.
         * </p>
         * 
         * @param minimumMembershipPercentage
         *        The minimum allowed percentage of TargetMembershipsPerSubChannel users. Ceil of the calculated value
         *        is used in balancing members among SubChannels of the elastic channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumMembershipPercentage(Integer minimumMembershipPercentage);
    }

    static final class BuilderImpl implements Builder {
        private Integer maximumSubChannels;

        private Integer targetMembershipsPerSubChannel;

        private Integer minimumMembershipPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticChannelConfiguration model) {
            maximumSubChannels(model.maximumSubChannels);
            targetMembershipsPerSubChannel(model.targetMembershipsPerSubChannel);
            minimumMembershipPercentage(model.minimumMembershipPercentage);
        }

        public final Integer getMaximumSubChannels() {
            return maximumSubChannels;
        }

        public final void setMaximumSubChannels(Integer maximumSubChannels) {
            this.maximumSubChannels = maximumSubChannels;
        }

        @Override
        public final Builder maximumSubChannels(Integer maximumSubChannels) {
            this.maximumSubChannels = maximumSubChannels;
            return this;
        }

        public final Integer getTargetMembershipsPerSubChannel() {
            return targetMembershipsPerSubChannel;
        }

        public final void setTargetMembershipsPerSubChannel(Integer targetMembershipsPerSubChannel) {
            this.targetMembershipsPerSubChannel = targetMembershipsPerSubChannel;
        }

        @Override
        public final Builder targetMembershipsPerSubChannel(Integer targetMembershipsPerSubChannel) {
            this.targetMembershipsPerSubChannel = targetMembershipsPerSubChannel;
            return this;
        }

        public final Integer getMinimumMembershipPercentage() {
            return minimumMembershipPercentage;
        }

        public final void setMinimumMembershipPercentage(Integer minimumMembershipPercentage) {
            this.minimumMembershipPercentage = minimumMembershipPercentage;
        }

        @Override
        public final Builder minimumMembershipPercentage(Integer minimumMembershipPercentage) {
            this.minimumMembershipPercentage = minimumMembershipPercentage;
            return this;
        }

        @Override
        public ElasticChannelConfiguration build() {
            return new ElasticChannelConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
