/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMessagingSessionEndpointResponse extends ChimeSdkMessagingResponse implements
        ToCopyableBuilder<GetMessagingSessionEndpointResponse.Builder, GetMessagingSessionEndpointResponse> {
    private static final SdkField<MessagingSessionEndpoint> ENDPOINT_FIELD = SdkField
            .<MessagingSessionEndpoint> builder(MarshallingType.SDK_POJO).memberName("Endpoint")
            .getter(getter(GetMessagingSessionEndpointResponse::endpoint)).setter(setter(Builder::endpoint))
            .constructor(MessagingSessionEndpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final MessagingSessionEndpoint endpoint;

    private GetMessagingSessionEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.endpoint = builder.endpoint;
    }

    /**
     * <p>
     * The endpoint returned in the response.
     * </p>
     * 
     * @return The endpoint returned in the response.
     */
    public final MessagingSessionEndpoint endpoint() {
        return endpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMessagingSessionEndpointResponse)) {
            return false;
        }
        GetMessagingSessionEndpointResponse other = (GetMessagingSessionEndpointResponse) obj;
        return Objects.equals(endpoint(), other.endpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMessagingSessionEndpointResponse").add("Endpoint", endpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Endpoint", ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMessagingSessionEndpointResponse, T> g) {
        return obj -> g.apply((GetMessagingSessionEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMessagingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetMessagingSessionEndpointResponse> {
        /**
         * <p>
         * The endpoint returned in the response.
         * </p>
         * 
         * @param endpoint
         *        The endpoint returned in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(MessagingSessionEndpoint endpoint);

        /**
         * <p>
         * The endpoint returned in the response.
         * </p>
         * This is a convenience method that creates an instance of the {@link MessagingSessionEndpoint.Builder}
         * avoiding the need to create one manually via {@link MessagingSessionEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessagingSessionEndpoint.Builder#build()} is called immediately
         * and its result is passed to {@link #endpoint(MessagingSessionEndpoint)}.
         * 
         * @param endpoint
         *        a consumer that will call methods on {@link MessagingSessionEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpoint(MessagingSessionEndpoint)
         */
        default Builder endpoint(Consumer<MessagingSessionEndpoint.Builder> endpoint) {
            return endpoint(MessagingSessionEndpoint.builder().applyMutation(endpoint).build());
        }
    }

    static final class BuilderImpl extends ChimeSdkMessagingResponse.BuilderImpl implements Builder {
        private MessagingSessionEndpoint endpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMessagingSessionEndpointResponse model) {
            super(model);
            endpoint(model.endpoint);
        }

        public final MessagingSessionEndpoint.Builder getEndpoint() {
            return endpoint != null ? endpoint.toBuilder() : null;
        }

        public final void setEndpoint(MessagingSessionEndpoint.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        @Override
        public final Builder endpoint(MessagingSessionEndpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public GetMessagingSessionEndpointResponse build() {
            return new GetMessagingSessionEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
