/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Stores metadata about a Lambda processor.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LambdaConfiguration.Builder, LambdaConfiguration> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(LambdaConfiguration::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> INVOCATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvocationType").getter(getter(LambdaConfiguration::invocationTypeAsString))
            .setter(setter(Builder::invocationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            INVOCATION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resourceArn;

    private final String invocationType;

    private LambdaConfiguration(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.invocationType = builder.invocationType;
    }

    /**
     * <p>
     * The ARN of the Lambda message processing function.
     * </p>
     * 
     * @return The ARN of the Lambda message processing function.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * Controls how the Lambda function is invoked.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invocationType}
     * will return {@link InvocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #invocationTypeAsString}.
     * </p>
     * 
     * @return Controls how the Lambda function is invoked.
     * @see InvocationType
     */
    public final InvocationType invocationType() {
        return InvocationType.fromValue(invocationType);
    }

    /**
     * <p>
     * Controls how the Lambda function is invoked.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invocationType}
     * will return {@link InvocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #invocationTypeAsString}.
     * </p>
     * 
     * @return Controls how the Lambda function is invoked.
     * @see InvocationType
     */
    public final String invocationTypeAsString() {
        return invocationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(invocationTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaConfiguration)) {
            return false;
        }
        LambdaConfiguration other = (LambdaConfiguration) obj;
        return Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(invocationTypeAsString(), other.invocationTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LambdaConfiguration").add("ResourceArn", resourceArn())
                .add("InvocationType", invocationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "InvocationType":
            return Optional.ofNullable(clazz.cast(invocationTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("InvocationType", INVOCATION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LambdaConfiguration, T> g) {
        return obj -> g.apply((LambdaConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LambdaConfiguration> {
        /**
         * <p>
         * The ARN of the Lambda message processing function.
         * </p>
         * 
         * @param resourceArn
         *        The ARN of the Lambda message processing function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * Controls how the Lambda function is invoked.
         * </p>
         * 
         * @param invocationType
         *        Controls how the Lambda function is invoked.
         * @see InvocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InvocationType
         */
        Builder invocationType(String invocationType);

        /**
         * <p>
         * Controls how the Lambda function is invoked.
         * </p>
         * 
         * @param invocationType
         *        Controls how the Lambda function is invoked.
         * @see InvocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InvocationType
         */
        Builder invocationType(InvocationType invocationType);
    }

    static final class BuilderImpl implements Builder {
        private String resourceArn;

        private String invocationType;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaConfiguration model) {
            resourceArn(model.resourceArn);
            invocationType(model.invocationType);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getInvocationType() {
            return invocationType;
        }

        public final void setInvocationType(String invocationType) {
            this.invocationType = invocationType;
        }

        @Override
        public final Builder invocationType(String invocationType) {
            this.invocationType = invocationType;
            return this;
        }

        @Override
        public final Builder invocationType(InvocationType invocationType) {
            this.invocationType(invocationType == null ? null : invocationType.toString());
            return this;
        }

        @Override
        public LambdaConfiguration build() {
            return new LambdaConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
