/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListChannelFlowsResponse extends ChimeSdkMessagingResponse implements
        ToCopyableBuilder<ListChannelFlowsResponse.Builder, ListChannelFlowsResponse> {
    private static final SdkField<List<ChannelFlowSummary>> CHANNEL_FLOWS_FIELD = SdkField
            .<List<ChannelFlowSummary>> builder(MarshallingType.LIST)
            .memberName("ChannelFlows")
            .getter(getter(ListChannelFlowsResponse::channelFlows))
            .setter(setter(Builder::channelFlows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelFlows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChannelFlowSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChannelFlowSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListChannelFlowsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_FLOWS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ChannelFlowSummary> channelFlows;

    private final String nextToken;

    private ListChannelFlowsResponse(BuilderImpl builder) {
        super(builder);
        this.channelFlows = builder.channelFlows;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChannelFlows property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasChannelFlows() {
        return channelFlows != null && !(channelFlows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The information about each channel flow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannelFlows} method.
     * </p>
     * 
     * @return The information about each channel flow.
     */
    public final List<ChannelFlowSummary> channelFlows() {
        return channelFlows;
    }

    /**
     * <p>
     * The token passed by previous API calls until all requested channels are returned.
     * </p>
     * 
     * @return The token passed by previous API calls until all requested channels are returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasChannelFlows() ? channelFlows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChannelFlowsResponse)) {
            return false;
        }
        ListChannelFlowsResponse other = (ListChannelFlowsResponse) obj;
        return hasChannelFlows() == other.hasChannelFlows() && Objects.equals(channelFlows(), other.channelFlows())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListChannelFlowsResponse").add("ChannelFlows", hasChannelFlows() ? channelFlows() : null)
                .add("NextToken", nextToken() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelFlows":
            return Optional.ofNullable(clazz.cast(channelFlows()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ChannelFlows", CHANNEL_FLOWS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListChannelFlowsResponse, T> g) {
        return obj -> g.apply((ListChannelFlowsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMessagingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListChannelFlowsResponse> {
        /**
         * <p>
         * The information about each channel flow.
         * </p>
         * 
         * @param channelFlows
         *        The information about each channel flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelFlows(Collection<ChannelFlowSummary> channelFlows);

        /**
         * <p>
         * The information about each channel flow.
         * </p>
         * 
         * @param channelFlows
         *        The information about each channel flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelFlows(ChannelFlowSummary... channelFlows);

        /**
         * <p>
         * The information about each channel flow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlowSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlowSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlowSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #channelFlows(List<ChannelFlowSummary>)}.
         * 
         * @param channelFlows
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlowSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelFlows(java.util.Collection<ChannelFlowSummary>)
         */
        Builder channelFlows(Consumer<ChannelFlowSummary.Builder>... channelFlows);

        /**
         * <p>
         * The token passed by previous API calls until all requested channels are returned.
         * </p>
         * 
         * @param nextToken
         *        The token passed by previous API calls until all requested channels are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ChimeSdkMessagingResponse.BuilderImpl implements Builder {
        private List<ChannelFlowSummary> channelFlows = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChannelFlowsResponse model) {
            super(model);
            channelFlows(model.channelFlows);
            nextToken(model.nextToken);
        }

        public final List<ChannelFlowSummary.Builder> getChannelFlows() {
            List<ChannelFlowSummary.Builder> result = ChannelFlowSummaryListCopier.copyToBuilder(this.channelFlows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannelFlows(Collection<ChannelFlowSummary.BuilderImpl> channelFlows) {
            this.channelFlows = ChannelFlowSummaryListCopier.copyFromBuilder(channelFlows);
        }

        @Override
        public final Builder channelFlows(Collection<ChannelFlowSummary> channelFlows) {
            this.channelFlows = ChannelFlowSummaryListCopier.copy(channelFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelFlows(ChannelFlowSummary... channelFlows) {
            channelFlows(Arrays.asList(channelFlows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelFlows(Consumer<ChannelFlowSummary.Builder>... channelFlows) {
            channelFlows(Stream.of(channelFlows).map(c -> ChannelFlowSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListChannelFlowsResponse build() {
            return new ListChannelFlowsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
