/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListChannelsRequest extends ChimeSdkMessagingRequest implements
        ToCopyableBuilder<ListChannelsRequest.Builder, ListChannelsRequest> {
    private static final SdkField<String> APP_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppInstanceArn").getter(getter(ListChannelsRequest::appInstanceArn))
            .setter(setter(Builder::appInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("app-instance-arn").build())
            .build();

    private static final SdkField<String> PRIVACY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Privacy")
            .getter(getter(ListChannelsRequest::privacyAsString)).setter(setter(Builder::privacy))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("privacy").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListChannelsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("max-results").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListChannelsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next-token").build()).build();

    private static final SdkField<String> CHIME_BEARER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChimeBearer").getter(getter(ListChannelsRequest::chimeBearer)).setter(setter(Builder::chimeBearer))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-chime-bearer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_ARN_FIELD,
            PRIVACY_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, CHIME_BEARER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String appInstanceArn;

    private final String privacy;

    private final Integer maxResults;

    private final String nextToken;

    private final String chimeBearer;

    private ListChannelsRequest(BuilderImpl builder) {
        super(builder);
        this.appInstanceArn = builder.appInstanceArn;
        this.privacy = builder.privacy;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.chimeBearer = builder.chimeBearer;
    }

    /**
     * <p>
     * The ARN of the <code>AppInstance</code>.
     * </p>
     * 
     * @return The ARN of the <code>AppInstance</code>.
     */
    public final String appInstanceArn() {
        return appInstanceArn;
    }

    /**
     * <p>
     * The privacy setting. <code>PUBLIC</code> retrieves all the public channels. <code>PRIVATE</code> retrieves
     * private channels. Only an <code>AppInstanceAdmin</code> can retrieve private channels.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #privacy} will
     * return {@link ChannelPrivacy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #privacyAsString}.
     * </p>
     * 
     * @return The privacy setting. <code>PUBLIC</code> retrieves all the public channels. <code>PRIVATE</code>
     *         retrieves private channels. Only an <code>AppInstanceAdmin</code> can retrieve private channels.
     * @see ChannelPrivacy
     */
    public final ChannelPrivacy privacy() {
        return ChannelPrivacy.fromValue(privacy);
    }

    /**
     * <p>
     * The privacy setting. <code>PUBLIC</code> retrieves all the public channels. <code>PRIVATE</code> retrieves
     * private channels. Only an <code>AppInstanceAdmin</code> can retrieve private channels.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #privacy} will
     * return {@link ChannelPrivacy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #privacyAsString}.
     * </p>
     * 
     * @return The privacy setting. <code>PUBLIC</code> retrieves all the public channels. <code>PRIVATE</code>
     *         retrieves private channels. Only an <code>AppInstanceAdmin</code> can retrieve private channels.
     * @see ChannelPrivacy
     */
    public final String privacyAsString() {
        return privacy;
    }

    /**
     * <p>
     * The maximum number of channels that you want to return.
     * </p>
     * 
     * @return The maximum number of channels that you want to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token passed by previous API calls until all requested channels are returned.
     * </p>
     * 
     * @return The token passed by previous API calls until all requested channels are returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.
     * </p>
     * 
     * @return The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.
     */
    public final String chimeBearer() {
        return chimeBearer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(privacyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(chimeBearer());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChannelsRequest)) {
            return false;
        }
        ListChannelsRequest other = (ListChannelsRequest) obj;
        return Objects.equals(appInstanceArn(), other.appInstanceArn())
                && Objects.equals(privacyAsString(), other.privacyAsString()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(chimeBearer(), other.chimeBearer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListChannelsRequest").add("AppInstanceArn", appInstanceArn()).add("Privacy", privacyAsString())
                .add("MaxResults", maxResults()).add("NextToken", nextToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ChimeBearer", chimeBearer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppInstanceArn":
            return Optional.ofNullable(clazz.cast(appInstanceArn()));
        case "Privacy":
            return Optional.ofNullable(clazz.cast(privacyAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ChimeBearer":
            return Optional.ofNullable(clazz.cast(chimeBearer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("app-instance-arn", APP_INSTANCE_ARN_FIELD);
        map.put("privacy", PRIVACY_FIELD);
        map.put("max-results", MAX_RESULTS_FIELD);
        map.put("next-token", NEXT_TOKEN_FIELD);
        map.put("x-amz-chime-bearer", CHIME_BEARER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListChannelsRequest, T> g) {
        return obj -> g.apply((ListChannelsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMessagingRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListChannelsRequest> {
        /**
         * <p>
         * The ARN of the <code>AppInstance</code>.
         * </p>
         * 
         * @param appInstanceArn
         *        The ARN of the <code>AppInstance</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstanceArn(String appInstanceArn);

        /**
         * <p>
         * The privacy setting. <code>PUBLIC</code> retrieves all the public channels. <code>PRIVATE</code> retrieves
         * private channels. Only an <code>AppInstanceAdmin</code> can retrieve private channels.
         * </p>
         * 
         * @param privacy
         *        The privacy setting. <code>PUBLIC</code> retrieves all the public channels. <code>PRIVATE</code>
         *        retrieves private channels. Only an <code>AppInstanceAdmin</code> can retrieve private channels.
         * @see ChannelPrivacy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelPrivacy
         */
        Builder privacy(String privacy);

        /**
         * <p>
         * The privacy setting. <code>PUBLIC</code> retrieves all the public channels. <code>PRIVATE</code> retrieves
         * private channels. Only an <code>AppInstanceAdmin</code> can retrieve private channels.
         * </p>
         * 
         * @param privacy
         *        The privacy setting. <code>PUBLIC</code> retrieves all the public channels. <code>PRIVATE</code>
         *        retrieves private channels. Only an <code>AppInstanceAdmin</code> can retrieve private channels.
         * @see ChannelPrivacy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelPrivacy
         */
        Builder privacy(ChannelPrivacy privacy);

        /**
         * <p>
         * The maximum number of channels that you want to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of channels that you want to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token passed by previous API calls until all requested channels are returned.
         * </p>
         * 
         * @param nextToken
         *        The token passed by previous API calls until all requested channels are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.
         * </p>
         * 
         * @param chimeBearer
         *        The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chimeBearer(String chimeBearer);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkMessagingRequest.BuilderImpl implements Builder {
        private String appInstanceArn;

        private String privacy;

        private Integer maxResults;

        private String nextToken;

        private String chimeBearer;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChannelsRequest model) {
            super(model);
            appInstanceArn(model.appInstanceArn);
            privacy(model.privacy);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            chimeBearer(model.chimeBearer);
        }

        public final String getAppInstanceArn() {
            return appInstanceArn;
        }

        public final void setAppInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
        }

        @Override
        public final Builder appInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
            return this;
        }

        public final String getPrivacy() {
            return privacy;
        }

        public final void setPrivacy(String privacy) {
            this.privacy = privacy;
        }

        @Override
        public final Builder privacy(String privacy) {
            this.privacy = privacy;
            return this;
        }

        @Override
        public final Builder privacy(ChannelPrivacy privacy) {
            this.privacy(privacy == null ? null : privacy.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getChimeBearer() {
            return chimeBearer;
        }

        public final void setChimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
        }

        @Override
        public final Builder chimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListChannelsRequest build() {
            return new ListChannelsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
