/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutChannelExpirationSettingsResponse extends ChimeSdkMessagingResponse implements
        ToCopyableBuilder<PutChannelExpirationSettingsResponse.Builder, PutChannelExpirationSettingsResponse> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelArn").getter(getter(PutChannelExpirationSettingsResponse::channelArn))
            .setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelArn").build()).build();

    private static final SdkField<ExpirationSettings> EXPIRATION_SETTINGS_FIELD = SdkField
            .<ExpirationSettings> builder(MarshallingType.SDK_POJO).memberName("ExpirationSettings")
            .getter(getter(PutChannelExpirationSettingsResponse::expirationSettings)).setter(setter(Builder::expirationSettings))
            .constructor(ExpirationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD,
            EXPIRATION_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String channelArn;

    private final ExpirationSettings expirationSettings;

    private PutChannelExpirationSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.expirationSettings = builder.expirationSettings;
    }

    /**
     * <p>
     * The channel ARN.
     * </p>
     * 
     * @return The channel ARN.
     */
    public final String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * Settings that control the interval after which a channel is deleted.
     * </p>
     * 
     * @return Settings that control the interval after which a channel is deleted.
     */
    public final ExpirationSettings expirationSettings() {
        return expirationSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(expirationSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutChannelExpirationSettingsResponse)) {
            return false;
        }
        PutChannelExpirationSettingsResponse other = (PutChannelExpirationSettingsResponse) obj;
        return Objects.equals(channelArn(), other.channelArn())
                && Objects.equals(expirationSettings(), other.expirationSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutChannelExpirationSettingsResponse").add("ChannelArn", channelArn())
                .add("ExpirationSettings", expirationSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "ExpirationSettings":
            return Optional.ofNullable(clazz.cast(expirationSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ChannelArn", CHANNEL_ARN_FIELD);
        map.put("ExpirationSettings", EXPIRATION_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutChannelExpirationSettingsResponse, T> g) {
        return obj -> g.apply((PutChannelExpirationSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMessagingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PutChannelExpirationSettingsResponse> {
        /**
         * <p>
         * The channel ARN.
         * </p>
         * 
         * @param channelArn
         *        The channel ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * Settings that control the interval after which a channel is deleted.
         * </p>
         * 
         * @param expirationSettings
         *        Settings that control the interval after which a channel is deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationSettings(ExpirationSettings expirationSettings);

        /**
         * <p>
         * Settings that control the interval after which a channel is deleted.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExpirationSettings.Builder} avoiding the
         * need to create one manually via {@link ExpirationSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExpirationSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #expirationSettings(ExpirationSettings)}.
         * 
         * @param expirationSettings
         *        a consumer that will call methods on {@link ExpirationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expirationSettings(ExpirationSettings)
         */
        default Builder expirationSettings(Consumer<ExpirationSettings.Builder> expirationSettings) {
            return expirationSettings(ExpirationSettings.builder().applyMutation(expirationSettings).build());
        }
    }

    static final class BuilderImpl extends ChimeSdkMessagingResponse.BuilderImpl implements Builder {
        private String channelArn;

        private ExpirationSettings expirationSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(PutChannelExpirationSettingsResponse model) {
            super(model);
            channelArn(model.channelArn);
            expirationSettings(model.expirationSettings);
        }

        public final String getChannelArn() {
            return channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final ExpirationSettings.Builder getExpirationSettings() {
            return expirationSettings != null ? expirationSettings.toBuilder() : null;
        }

        public final void setExpirationSettings(ExpirationSettings.BuilderImpl expirationSettings) {
            this.expirationSettings = expirationSettings != null ? expirationSettings.build() : null;
        }

        @Override
        public final Builder expirationSettings(ExpirationSettings expirationSettings) {
            this.expirationSettings = expirationSettings;
            return this;
        }

        @Override
        public PutChannelExpirationSettingsResponse build() {
            return new PutChannelExpirationSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
