/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedactChannelMessageResponse extends ChimeSdkMessagingResponse implements
        ToCopyableBuilder<RedactChannelMessageResponse.Builder, RedactChannelMessageResponse> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelArn").getter(getter(RedactChannelMessageResponse::channelArn))
            .setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelArn").build()).build();

    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageId").getter(getter(RedactChannelMessageResponse::messageId)).setter(setter(Builder::messageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageId").build()).build();

    private static final SdkField<String> SUB_CHANNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubChannelId").getter(getter(RedactChannelMessageResponse::subChannelId))
            .setter(setter(Builder::subChannelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubChannelId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD,
            MESSAGE_ID_FIELD, SUB_CHANNEL_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String channelArn;

    private final String messageId;

    private final String subChannelId;

    private RedactChannelMessageResponse(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.messageId = builder.messageId;
        this.subChannelId = builder.subChannelId;
    }

    /**
     * <p>
     * The ARN of the channel containing the messages that you want to redact.
     * </p>
     * 
     * @return The ARN of the channel containing the messages that you want to redact.
     */
    public final String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * The ID of the message being redacted.
     * </p>
     * 
     * @return The ID of the message being redacted.
     */
    public final String messageId() {
        return messageId;
    }

    /**
     * <p>
     * The ID of the SubChannel in the response.
     * </p>
     * <note>
     * <p>
     * Only required when redacting messages in a SubChannel that the user belongs to.
     * </p>
     * </note>
     * 
     * @return The ID of the SubChannel in the response.</p> <note>
     *         <p>
     *         Only required when redacting messages in a SubChannel that the user belongs to.
     *         </p>
     */
    public final String subChannelId() {
        return subChannelId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(messageId());
        hashCode = 31 * hashCode + Objects.hashCode(subChannelId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedactChannelMessageResponse)) {
            return false;
        }
        RedactChannelMessageResponse other = (RedactChannelMessageResponse) obj;
        return Objects.equals(channelArn(), other.channelArn()) && Objects.equals(messageId(), other.messageId())
                && Objects.equals(subChannelId(), other.subChannelId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedactChannelMessageResponse").add("ChannelArn", channelArn()).add("MessageId", messageId())
                .add("SubChannelId", subChannelId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "MessageId":
            return Optional.ofNullable(clazz.cast(messageId()));
        case "SubChannelId":
            return Optional.ofNullable(clazz.cast(subChannelId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ChannelArn", CHANNEL_ARN_FIELD);
        map.put("MessageId", MESSAGE_ID_FIELD);
        map.put("SubChannelId", SUB_CHANNEL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedactChannelMessageResponse, T> g) {
        return obj -> g.apply((RedactChannelMessageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMessagingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, RedactChannelMessageResponse> {
        /**
         * <p>
         * The ARN of the channel containing the messages that you want to redact.
         * </p>
         * 
         * @param channelArn
         *        The ARN of the channel containing the messages that you want to redact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * The ID of the message being redacted.
         * </p>
         * 
         * @param messageId
         *        The ID of the message being redacted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageId(String messageId);

        /**
         * <p>
         * The ID of the SubChannel in the response.
         * </p>
         * <note>
         * <p>
         * Only required when redacting messages in a SubChannel that the user belongs to.
         * </p>
         * </note>
         * 
         * @param subChannelId
         *        The ID of the SubChannel in the response.</p> <note>
         *        <p>
         *        Only required when redacting messages in a SubChannel that the user belongs to.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subChannelId(String subChannelId);
    }

    static final class BuilderImpl extends ChimeSdkMessagingResponse.BuilderImpl implements Builder {
        private String channelArn;

        private String messageId;

        private String subChannelId;

        private BuilderImpl() {
        }

        private BuilderImpl(RedactChannelMessageResponse model) {
            super(model);
            channelArn(model.channelArn);
            messageId(model.messageId);
            subChannelId(model.subChannelId);
        }

        public final String getChannelArn() {
            return channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getMessageId() {
            return messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final String getSubChannelId() {
            return subChannelId;
        }

        public final void setSubChannelId(String subChannelId) {
            this.subChannelId = subChannelId;
        }

        @Override
        public final Builder subChannelId(String subChannelId) {
            this.subChannelId = subChannelId;
            return this;
        }

        @Override
        public RedactChannelMessageResponse build() {
            return new RedactChannelMessageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
