/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary of the sub-channels associated with the elastic channel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubChannelSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<SubChannelSummary.Builder, SubChannelSummary> {
    private static final SdkField<String> SUB_CHANNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubChannelId").getter(getter(SubChannelSummary::subChannelId)).setter(setter(Builder::subChannelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubChannelId").build()).build();

    private static final SdkField<Integer> MEMBERSHIP_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MembershipCount").getter(getter(SubChannelSummary::membershipCount))
            .setter(setter(Builder::membershipCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MembershipCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUB_CHANNEL_ID_FIELD,
            MEMBERSHIP_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String subChannelId;

    private final Integer membershipCount;

    private SubChannelSummary(BuilderImpl builder) {
        this.subChannelId = builder.subChannelId;
        this.membershipCount = builder.membershipCount;
    }

    /**
     * <p>
     * The unique ID of a SubChannel.
     * </p>
     * 
     * @return The unique ID of a SubChannel.
     */
    public final String subChannelId() {
        return subChannelId;
    }

    /**
     * <p>
     * The number of members in a SubChannel.
     * </p>
     * 
     * @return The number of members in a SubChannel.
     */
    public final Integer membershipCount() {
        return membershipCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subChannelId());
        hashCode = 31 * hashCode + Objects.hashCode(membershipCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubChannelSummary)) {
            return false;
        }
        SubChannelSummary other = (SubChannelSummary) obj;
        return Objects.equals(subChannelId(), other.subChannelId()) && Objects.equals(membershipCount(), other.membershipCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubChannelSummary").add("SubChannelId", subChannelId())
                .add("MembershipCount", membershipCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubChannelId":
            return Optional.ofNullable(clazz.cast(subChannelId()));
        case "MembershipCount":
            return Optional.ofNullable(clazz.cast(membershipCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SubChannelId", SUB_CHANNEL_ID_FIELD);
        map.put("MembershipCount", MEMBERSHIP_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubChannelSummary, T> g) {
        return obj -> g.apply((SubChannelSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubChannelSummary> {
        /**
         * <p>
         * The unique ID of a SubChannel.
         * </p>
         * 
         * @param subChannelId
         *        The unique ID of a SubChannel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subChannelId(String subChannelId);

        /**
         * <p>
         * The number of members in a SubChannel.
         * </p>
         * 
         * @param membershipCount
         *        The number of members in a SubChannel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipCount(Integer membershipCount);
    }

    static final class BuilderImpl implements Builder {
        private String subChannelId;

        private Integer membershipCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SubChannelSummary model) {
            subChannelId(model.subChannelId);
            membershipCount(model.membershipCount);
        }

        public final String getSubChannelId() {
            return subChannelId;
        }

        public final void setSubChannelId(String subChannelId) {
            this.subChannelId = subChannelId;
        }

        @Override
        public final Builder subChannelId(String subChannelId) {
            this.subChannelId = subChannelId;
            return this;
        }

        public final Integer getMembershipCount() {
            return membershipCount;
        }

        public final void setMembershipCount(Integer membershipCount) {
            this.membershipCount = membershipCount;
        }

        @Override
        public final Builder membershipCount(Integer membershipCount) {
            this.membershipCount = membershipCount;
            return this;
        }

        @Override
        public SubChannelSummary build() {
            return new SubChannelSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
