/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlowSummary;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChannelFlowSummaryListCopier;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChimeSdkMessagingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListChannelFlowsResponse
extends ChimeSdkMessagingResponse
implements ToCopyableBuilder<Builder, ListChannelFlowsResponse> {
    private static final SdkField<List<ChannelFlowSummary>> CHANNEL_FLOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChannelFlows").getter(ListChannelFlowsResponse.getter(ListChannelFlowsResponse::channelFlows)).setter(ListChannelFlowsResponse.setter(Builder::channelFlows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelFlows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChannelFlowSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListChannelFlowsResponse.getter(ListChannelFlowsResponse::nextToken)).setter(ListChannelFlowsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_FLOWS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListChannelFlowsResponse.memberNameToFieldInitializer();
    private final List<ChannelFlowSummary> channelFlows;
    private final String nextToken;

    private ListChannelFlowsResponse(BuilderImpl builder) {
        super(builder);
        this.channelFlows = builder.channelFlows;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasChannelFlows() {
        return this.channelFlows != null && !(this.channelFlows instanceof SdkAutoConstructList);
    }

    public final List<ChannelFlowSummary> channelFlows() {
        return this.channelFlows;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannelFlows() ? this.channelFlows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChannelFlowsResponse)) {
            return false;
        }
        ListChannelFlowsResponse other = (ListChannelFlowsResponse)((Object)obj);
        return this.hasChannelFlows() == other.hasChannelFlows() && Objects.equals(this.channelFlows(), other.channelFlows()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListChannelFlowsResponse").add("ChannelFlows", this.hasChannelFlows() ? this.channelFlows() : null).add("NextToken", (Object)(this.nextToken() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelFlows": {
                return Optional.ofNullable(clazz.cast(this.channelFlows()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ChannelFlows", CHANNEL_FLOWS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListChannelFlowsResponse, T> g) {
        return obj -> g.apply((ListChannelFlowsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkMessagingResponse.BuilderImpl
    implements Builder {
        private List<ChannelFlowSummary> channelFlows = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChannelFlowsResponse model) {
            super(model);
            this.channelFlows(model.channelFlows);
            this.nextToken(model.nextToken);
        }

        public final List<ChannelFlowSummary.Builder> getChannelFlows() {
            List<ChannelFlowSummary.Builder> result = ChannelFlowSummaryListCopier.copyToBuilder(this.channelFlows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannelFlows(Collection<ChannelFlowSummary.BuilderImpl> channelFlows) {
            this.channelFlows = ChannelFlowSummaryListCopier.copyFromBuilder(channelFlows);
        }

        @Override
        public final Builder channelFlows(Collection<ChannelFlowSummary> channelFlows) {
            this.channelFlows = ChannelFlowSummaryListCopier.copy(channelFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelFlows(ChannelFlowSummary ... channelFlows) {
            this.channelFlows(Arrays.asList(channelFlows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelFlows(Consumer<ChannelFlowSummary.Builder> ... channelFlows) {
            this.channelFlows(Stream.of(channelFlows).map(c -> (ChannelFlowSummary)((ChannelFlowSummary.Builder)ChannelFlowSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListChannelFlowsResponse build() {
            return new ListChannelFlowsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeSdkMessagingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListChannelFlowsResponse> {
        public Builder channelFlows(Collection<ChannelFlowSummary> var1);

        public Builder channelFlows(ChannelFlowSummary ... var1);

        public Builder channelFlows(Consumer<ChannelFlowSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

