/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMemberArnsCopier;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMode;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChannelModeratorArnsCopier;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChannelPrivacy;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChimeSdkMessagingRequest;
import software.amazon.awssdk.services.chimesdkmessaging.model.ElasticChannelConfiguration;
import software.amazon.awssdk.services.chimesdkmessaging.model.ExpirationSettings;
import software.amazon.awssdk.services.chimesdkmessaging.model.Tag;
import software.amazon.awssdk.services.chimesdkmessaging.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateChannelRequest
extends ChimeSdkMessagingRequest
implements ToCopyableBuilder<Builder, CreateChannelRequest> {
    private static final SdkField<String> APP_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppInstanceArn").getter(CreateChannelRequest.getter(CreateChannelRequest::appInstanceArn)).setter(CreateChannelRequest.setter(Builder::appInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstanceArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateChannelRequest.getter(CreateChannelRequest::name)).setter(CreateChannelRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(CreateChannelRequest.getter(CreateChannelRequest::modeAsString)).setter(CreateChannelRequest.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final SdkField<String> PRIVACY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Privacy").getter(CreateChannelRequest.getter(CreateChannelRequest::privacyAsString)).setter(CreateChannelRequest.setter(Builder::privacy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Privacy").build()}).build();
    private static final SdkField<String> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Metadata").getter(CreateChannelRequest.getter(CreateChannelRequest::metadata)).setter(CreateChannelRequest.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateChannelRequest.getter(CreateChannelRequest::clientRequestToken)).setter(CreateChannelRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateChannelRequest.getter(CreateChannelRequest::tags)).setter(CreateChannelRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CHIME_BEARER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChimeBearer").getter(CreateChannelRequest.getter(CreateChannelRequest::chimeBearer)).setter(CreateChannelRequest.setter(Builder::chimeBearer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-chime-bearer").build()}).build();
    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelId").getter(CreateChannelRequest.getter(CreateChannelRequest::channelId)).setter(CreateChannelRequest.setter(Builder::channelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelId").build()}).build();
    private static final SdkField<List<String>> MEMBER_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MemberArns").getter(CreateChannelRequest.getter(CreateChannelRequest::memberArns)).setter(CreateChannelRequest.setter(Builder::memberArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> MODERATOR_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ModeratorArns").getter(CreateChannelRequest.getter(CreateChannelRequest::moderatorArns)).setter(CreateChannelRequest.setter(Builder::moderatorArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModeratorArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ElasticChannelConfiguration> ELASTIC_CHANNEL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ElasticChannelConfiguration").getter(CreateChannelRequest.getter(CreateChannelRequest::elasticChannelConfiguration)).setter(CreateChannelRequest.setter(Builder::elasticChannelConfiguration)).constructor(ElasticChannelConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticChannelConfiguration").build()}).build();
    private static final SdkField<ExpirationSettings> EXPIRATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExpirationSettings").getter(CreateChannelRequest.getter(CreateChannelRequest::expirationSettings)).setter(CreateChannelRequest.setter(Builder::expirationSettings)).constructor(ExpirationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_ARN_FIELD, NAME_FIELD, MODE_FIELD, PRIVACY_FIELD, METADATA_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD, CHIME_BEARER_FIELD, CHANNEL_ID_FIELD, MEMBER_ARNS_FIELD, MODERATOR_ARNS_FIELD, ELASTIC_CHANNEL_CONFIGURATION_FIELD, EXPIRATION_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateChannelRequest.memberNameToFieldInitializer();
    private final String appInstanceArn;
    private final String name;
    private final String mode;
    private final String privacy;
    private final String metadata;
    private final String clientRequestToken;
    private final List<Tag> tags;
    private final String chimeBearer;
    private final String channelId;
    private final List<String> memberArns;
    private final List<String> moderatorArns;
    private final ElasticChannelConfiguration elasticChannelConfiguration;
    private final ExpirationSettings expirationSettings;

    private CreateChannelRequest(BuilderImpl builder) {
        super(builder);
        this.appInstanceArn = builder.appInstanceArn;
        this.name = builder.name;
        this.mode = builder.mode;
        this.privacy = builder.privacy;
        this.metadata = builder.metadata;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
        this.chimeBearer = builder.chimeBearer;
        this.channelId = builder.channelId;
        this.memberArns = builder.memberArns;
        this.moderatorArns = builder.moderatorArns;
        this.elasticChannelConfiguration = builder.elasticChannelConfiguration;
        this.expirationSettings = builder.expirationSettings;
    }

    public final String appInstanceArn() {
        return this.appInstanceArn;
    }

    public final String name() {
        return this.name;
    }

    public final ChannelMode mode() {
        return ChannelMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final ChannelPrivacy privacy() {
        return ChannelPrivacy.fromValue(this.privacy);
    }

    public final String privacyAsString() {
        return this.privacy;
    }

    public final String metadata() {
        return this.metadata;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String chimeBearer() {
        return this.chimeBearer;
    }

    public final String channelId() {
        return this.channelId;
    }

    public final boolean hasMemberArns() {
        return this.memberArns != null && !(this.memberArns instanceof SdkAutoConstructList);
    }

    public final List<String> memberArns() {
        return this.memberArns;
    }

    public final boolean hasModeratorArns() {
        return this.moderatorArns != null && !(this.moderatorArns instanceof SdkAutoConstructList);
    }

    public final List<String> moderatorArns() {
        return this.moderatorArns;
    }

    public final ElasticChannelConfiguration elasticChannelConfiguration() {
        return this.elasticChannelConfiguration;
    }

    public final ExpirationSettings expirationSettings() {
        return this.expirationSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.privacyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.chimeBearer());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMemberArns() ? this.memberArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModeratorArns() ? this.moderatorArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticChannelConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChannelRequest)) {
            return false;
        }
        CreateChannelRequest other = (CreateChannelRequest)((Object)obj);
        return Objects.equals(this.appInstanceArn(), other.appInstanceArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.privacyAsString(), other.privacyAsString()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.chimeBearer(), other.chimeBearer()) && Objects.equals(this.channelId(), other.channelId()) && this.hasMemberArns() == other.hasMemberArns() && Objects.equals(this.memberArns(), other.memberArns()) && this.hasModeratorArns() == other.hasModeratorArns() && Objects.equals(this.moderatorArns(), other.moderatorArns()) && Objects.equals(this.elasticChannelConfiguration(), other.elasticChannelConfiguration()) && Objects.equals(this.expirationSettings(), other.expirationSettings());
    }

    public final String toString() {
        return ToString.builder((String)"CreateChannelRequest").add("AppInstanceArn", (Object)this.appInstanceArn()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Mode", (Object)this.modeAsString()).add("Privacy", (Object)this.privacyAsString()).add("Metadata", (Object)(this.metadata() == null ? null : "*** Sensitive Data Redacted ***")).add("ClientRequestToken", (Object)(this.clientRequestToken() == null ? null : "*** Sensitive Data Redacted ***")).add("Tags", this.hasTags() ? this.tags() : null).add("ChimeBearer", (Object)this.chimeBearer()).add("ChannelId", (Object)(this.channelId() == null ? null : "*** Sensitive Data Redacted ***")).add("MemberArns", this.hasMemberArns() ? this.memberArns() : null).add("ModeratorArns", this.hasModeratorArns() ? this.moderatorArns() : null).add("ElasticChannelConfiguration", (Object)this.elasticChannelConfiguration()).add("ExpirationSettings", (Object)this.expirationSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.appInstanceArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "Privacy": {
                return Optional.ofNullable(clazz.cast(this.privacyAsString()));
            }
            case "Metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ChimeBearer": {
                return Optional.ofNullable(clazz.cast(this.chimeBearer()));
            }
            case "ChannelId": {
                return Optional.ofNullable(clazz.cast(this.channelId()));
            }
            case "MemberArns": {
                return Optional.ofNullable(clazz.cast(this.memberArns()));
            }
            case "ModeratorArns": {
                return Optional.ofNullable(clazz.cast(this.moderatorArns()));
            }
            case "ElasticChannelConfiguration": {
                return Optional.ofNullable(clazz.cast(this.elasticChannelConfiguration()));
            }
            case "ExpirationSettings": {
                return Optional.ofNullable(clazz.cast(this.expirationSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AppInstanceArn", APP_INSTANCE_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Mode", MODE_FIELD);
        map.put("Privacy", PRIVACY_FIELD);
        map.put("Metadata", METADATA_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("x-amz-chime-bearer", CHIME_BEARER_FIELD);
        map.put("ChannelId", CHANNEL_ID_FIELD);
        map.put("MemberArns", MEMBER_ARNS_FIELD);
        map.put("ModeratorArns", MODERATOR_ARNS_FIELD);
        map.put("ElasticChannelConfiguration", ELASTIC_CHANNEL_CONFIGURATION_FIELD);
        map.put("ExpirationSettings", EXPIRATION_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateChannelRequest, T> g) {
        return obj -> g.apply((CreateChannelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkMessagingRequest.BuilderImpl
    implements Builder {
        private String appInstanceArn;
        private String name;
        private String mode;
        private String privacy;
        private String metadata;
        private String clientRequestToken;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String chimeBearer;
        private String channelId;
        private List<String> memberArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> moderatorArns = DefaultSdkAutoConstructList.getInstance();
        private ElasticChannelConfiguration elasticChannelConfiguration;
        private ExpirationSettings expirationSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChannelRequest model) {
            super(model);
            this.appInstanceArn(model.appInstanceArn);
            this.name(model.name);
            this.mode(model.mode);
            this.privacy(model.privacy);
            this.metadata(model.metadata);
            this.clientRequestToken(model.clientRequestToken);
            this.tags(model.tags);
            this.chimeBearer(model.chimeBearer);
            this.channelId(model.channelId);
            this.memberArns(model.memberArns);
            this.moderatorArns(model.moderatorArns);
            this.elasticChannelConfiguration(model.elasticChannelConfiguration);
            this.expirationSettings(model.expirationSettings);
        }

        public final String getAppInstanceArn() {
            return this.appInstanceArn;
        }

        public final void setAppInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
        }

        @Override
        public final Builder appInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ChannelMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getPrivacy() {
            return this.privacy;
        }

        public final void setPrivacy(String privacy) {
            this.privacy = privacy;
        }

        @Override
        public final Builder privacy(String privacy) {
            this.privacy = privacy;
            return this;
        }

        @Override
        public final Builder privacy(ChannelPrivacy privacy) {
            this.privacy(privacy == null ? null : privacy.toString());
            return this;
        }

        public final String getMetadata() {
            return this.metadata;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getChimeBearer() {
            return this.chimeBearer;
        }

        public final void setChimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
        }

        @Override
        public final Builder chimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
            return this;
        }

        public final String getChannelId() {
            return this.channelId;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final Collection<String> getMemberArns() {
            if (this.memberArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.memberArns;
        }

        public final void setMemberArns(Collection<String> memberArns) {
            this.memberArns = ChannelMemberArnsCopier.copy(memberArns);
        }

        @Override
        public final Builder memberArns(Collection<String> memberArns) {
            this.memberArns = ChannelMemberArnsCopier.copy(memberArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberArns(String ... memberArns) {
            this.memberArns(Arrays.asList(memberArns));
            return this;
        }

        public final Collection<String> getModeratorArns() {
            if (this.moderatorArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.moderatorArns;
        }

        public final void setModeratorArns(Collection<String> moderatorArns) {
            this.moderatorArns = ChannelModeratorArnsCopier.copy(moderatorArns);
        }

        @Override
        public final Builder moderatorArns(Collection<String> moderatorArns) {
            this.moderatorArns = ChannelModeratorArnsCopier.copy(moderatorArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder moderatorArns(String ... moderatorArns) {
            this.moderatorArns(Arrays.asList(moderatorArns));
            return this;
        }

        public final ElasticChannelConfiguration.Builder getElasticChannelConfiguration() {
            return this.elasticChannelConfiguration != null ? this.elasticChannelConfiguration.toBuilder() : null;
        }

        public final void setElasticChannelConfiguration(ElasticChannelConfiguration.BuilderImpl elasticChannelConfiguration) {
            this.elasticChannelConfiguration = elasticChannelConfiguration != null ? elasticChannelConfiguration.build() : null;
        }

        @Override
        public final Builder elasticChannelConfiguration(ElasticChannelConfiguration elasticChannelConfiguration) {
            this.elasticChannelConfiguration = elasticChannelConfiguration;
            return this;
        }

        public final ExpirationSettings.Builder getExpirationSettings() {
            return this.expirationSettings != null ? this.expirationSettings.toBuilder() : null;
        }

        public final void setExpirationSettings(ExpirationSettings.BuilderImpl expirationSettings) {
            this.expirationSettings = expirationSettings != null ? expirationSettings.build() : null;
        }

        @Override
        public final Builder expirationSettings(ExpirationSettings expirationSettings) {
            this.expirationSettings = expirationSettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateChannelRequest build() {
            return new CreateChannelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ChimeSdkMessagingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateChannelRequest> {
        public Builder appInstanceArn(String var1);

        public Builder name(String var1);

        public Builder mode(String var1);

        public Builder mode(ChannelMode var1);

        public Builder privacy(String var1);

        public Builder privacy(ChannelPrivacy var1);

        public Builder metadata(String var1);

        public Builder clientRequestToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder chimeBearer(String var1);

        public Builder channelId(String var1);

        public Builder memberArns(Collection<String> var1);

        public Builder memberArns(String ... var1);

        public Builder moderatorArns(Collection<String> var1);

        public Builder moderatorArns(String ... var1);

        public Builder elasticChannelConfiguration(ElasticChannelConfiguration var1);

        default public Builder elasticChannelConfiguration(Consumer<ElasticChannelConfiguration.Builder> elasticChannelConfiguration) {
            return this.elasticChannelConfiguration((ElasticChannelConfiguration)((ElasticChannelConfiguration.Builder)ElasticChannelConfiguration.builder().applyMutation(elasticChannelConfiguration)).build());
        }

        public Builder expirationSettings(ExpirationSettings var1);

        default public Builder expirationSettings(Consumer<ExpirationSettings.Builder> expirationSettings) {
            return this.expirationSettings((ExpirationSettings)((ExpirationSettings.Builder)ExpirationSettings.builder().applyMutation(expirationSettings)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

