/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.chimesdkvoice.model.AccessDeniedException;
import software.amazon.awssdk.services.chimesdkvoice.model.AssociatePhoneNumbersWithVoiceConnectorGroupRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.AssociatePhoneNumbersWithVoiceConnectorGroupResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.AssociatePhoneNumbersWithVoiceConnectorRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.AssociatePhoneNumbersWithVoiceConnectorResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.BadRequestException;
import software.amazon.awssdk.services.chimesdkvoice.model.BatchDeletePhoneNumberRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.BatchDeletePhoneNumberResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.BatchUpdatePhoneNumberRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.BatchUpdatePhoneNumberResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.ChimeSdkVoiceException;
import software.amazon.awssdk.services.chimesdkvoice.model.ChimeSdkVoiceRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ConflictException;
import software.amazon.awssdk.services.chimesdkvoice.model.CreatePhoneNumberOrderRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.CreatePhoneNumberOrderResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.CreateProxySessionRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.CreateProxySessionResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.CreateSipMediaApplicationCallRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.CreateSipMediaApplicationCallResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.CreateSipMediaApplicationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.CreateSipMediaApplicationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.CreateSipRuleRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.CreateSipRuleResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceConnectorGroupRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceConnectorGroupResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceConnectorRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceConnectorResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceProfileDomainRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceProfileDomainResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceProfileRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceProfileResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.DeletePhoneNumberRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.DeletePhoneNumberResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteProxySessionRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteProxySessionResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteSipMediaApplicationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteSipMediaApplicationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteSipRuleRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteSipRuleResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorEmergencyCallingConfigurationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorEmergencyCallingConfigurationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorGroupRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorGroupResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorOriginationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorOriginationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorProxyRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorProxyResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorStreamingConfigurationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorStreamingConfigurationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorTerminationCredentialsRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorTerminationCredentialsResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorTerminationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorTerminationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceProfileDomainRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceProfileDomainResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceProfileRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceProfileResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.DisassociatePhoneNumbersFromVoiceConnectorGroupRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.DisassociatePhoneNumbersFromVoiceConnectorGroupResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.DisassociatePhoneNumbersFromVoiceConnectorRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.DisassociatePhoneNumbersFromVoiceConnectorResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.ForbiddenException;
import software.amazon.awssdk.services.chimesdkvoice.model.GetGlobalSettingsRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetGlobalSettingsResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetPhoneNumberOrderRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetPhoneNumberOrderResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetPhoneNumberRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetPhoneNumberResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetPhoneNumberSettingsRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetPhoneNumberSettingsResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetProxySessionRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetProxySessionResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationAlexaSkillConfigurationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationAlexaSkillConfigurationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationLoggingConfigurationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationLoggingConfigurationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetSipRuleRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetSipRuleResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetSpeakerSearchTaskRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetSpeakerSearchTaskResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorEmergencyCallingConfigurationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorEmergencyCallingConfigurationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorGroupRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorGroupResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorLoggingConfigurationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorLoggingConfigurationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorOriginationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorOriginationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorProxyRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorProxyResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorStreamingConfigurationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorStreamingConfigurationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorTerminationHealthRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorTerminationHealthResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorTerminationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorTerminationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceProfileDomainRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceProfileDomainResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceProfileRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceProfileResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceToneAnalysisTaskRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceToneAnalysisTaskResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GoneException;
import software.amazon.awssdk.services.chimesdkvoice.model.ListAvailableVoiceConnectorRegionsRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListAvailableVoiceConnectorRegionsResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumberOrdersRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumberOrdersResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumbersRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumbersResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.ListProxySessionsRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListProxySessionsResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.ListSipMediaApplicationsRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListSipMediaApplicationsResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.ListSipRulesRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListSipRulesResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.ListSupportedPhoneNumberCountriesRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListSupportedPhoneNumberCountriesResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorGroupsRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorGroupsResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorTerminationCredentialsRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorTerminationCredentialsResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorsRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorsResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfileDomainsRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfileDomainsResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfilesRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfilesResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.NotFoundException;
import software.amazon.awssdk.services.chimesdkvoice.model.PutSipMediaApplicationAlexaSkillConfigurationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.PutSipMediaApplicationAlexaSkillConfigurationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.PutSipMediaApplicationLoggingConfigurationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.PutSipMediaApplicationLoggingConfigurationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorEmergencyCallingConfigurationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorEmergencyCallingConfigurationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorLoggingConfigurationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorLoggingConfigurationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorOriginationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorOriginationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorProxyRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorProxyResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorStreamingConfigurationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorStreamingConfigurationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorTerminationCredentialsRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorTerminationCredentialsResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorTerminationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorTerminationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.chimesdkvoice.model.RestorePhoneNumberRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.RestorePhoneNumberResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.SearchAvailablePhoneNumbersRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.SearchAvailablePhoneNumbersResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.ServiceFailureException;
import software.amazon.awssdk.services.chimesdkvoice.model.ServiceUnavailableException;
import software.amazon.awssdk.services.chimesdkvoice.model.StartSpeakerSearchTaskRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.StartSpeakerSearchTaskResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.StartVoiceToneAnalysisTaskRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.StartVoiceToneAnalysisTaskResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.StopSpeakerSearchTaskRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.StopSpeakerSearchTaskResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.StopVoiceToneAnalysisTaskRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.StopVoiceToneAnalysisTaskResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.TagResourceRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.TagResourceResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.ThrottledClientException;
import software.amazon.awssdk.services.chimesdkvoice.model.UnauthorizedClientException;
import software.amazon.awssdk.services.chimesdkvoice.model.UnprocessableEntityException;
import software.amazon.awssdk.services.chimesdkvoice.model.UntagResourceRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.UntagResourceResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateGlobalSettingsRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateGlobalSettingsResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdatePhoneNumberRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdatePhoneNumberResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdatePhoneNumberSettingsRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdatePhoneNumberSettingsResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateProxySessionRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateProxySessionResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateSipMediaApplicationCallRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateSipMediaApplicationCallResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateSipMediaApplicationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateSipMediaApplicationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateSipRuleRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateSipRuleResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceConnectorGroupRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceConnectorGroupResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceConnectorRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceConnectorResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceProfileDomainRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceProfileDomainResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceProfileRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceProfileResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.ValidateE911AddressRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ValidateE911AddressResponse;
import software.amazon.awssdk.services.chimesdkvoice.paginators.ListPhoneNumberOrdersPublisher;
import software.amazon.awssdk.services.chimesdkvoice.paginators.ListPhoneNumbersPublisher;
import software.amazon.awssdk.services.chimesdkvoice.paginators.ListProxySessionsPublisher;
import software.amazon.awssdk.services.chimesdkvoice.paginators.ListSipMediaApplicationsPublisher;
import software.amazon.awssdk.services.chimesdkvoice.paginators.ListSipRulesPublisher;
import software.amazon.awssdk.services.chimesdkvoice.paginators.ListVoiceConnectorGroupsPublisher;
import software.amazon.awssdk.services.chimesdkvoice.paginators.ListVoiceConnectorsPublisher;
import software.amazon.awssdk.services.chimesdkvoice.paginators.ListVoiceProfileDomainsPublisher;
import software.amazon.awssdk.services.chimesdkvoice.paginators.ListVoiceProfilesPublisher;
import software.amazon.awssdk.services.chimesdkvoice.paginators.SearchAvailablePhoneNumbersPublisher;
import software.amazon.awssdk.services.chimesdkvoice.transform.AssociatePhoneNumbersWithVoiceConnectorGroupRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.AssociatePhoneNumbersWithVoiceConnectorRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.BatchDeletePhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.BatchUpdatePhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.CreatePhoneNumberOrderRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.CreateProxySessionRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.CreateSipMediaApplicationCallRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.CreateSipMediaApplicationRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.CreateSipRuleRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.CreateVoiceConnectorGroupRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.CreateVoiceConnectorRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.CreateVoiceProfileDomainRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.CreateVoiceProfileRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.DeletePhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.DeleteProxySessionRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.DeleteSipMediaApplicationRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.DeleteSipRuleRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.DeleteVoiceConnectorEmergencyCallingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.DeleteVoiceConnectorGroupRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.DeleteVoiceConnectorOriginationRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.DeleteVoiceConnectorProxyRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.DeleteVoiceConnectorRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.DeleteVoiceConnectorStreamingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.DeleteVoiceConnectorTerminationCredentialsRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.DeleteVoiceConnectorTerminationRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.DeleteVoiceProfileDomainRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.DeleteVoiceProfileRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.DisassociatePhoneNumbersFromVoiceConnectorGroupRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.DisassociatePhoneNumbersFromVoiceConnectorRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.GetGlobalSettingsRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.GetPhoneNumberOrderRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.GetPhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.GetPhoneNumberSettingsRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.GetProxySessionRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.GetSipMediaApplicationAlexaSkillConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.GetSipMediaApplicationLoggingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.GetSipMediaApplicationRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.GetSipRuleRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.GetSpeakerSearchTaskRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.GetVoiceConnectorEmergencyCallingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.GetVoiceConnectorGroupRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.GetVoiceConnectorLoggingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.GetVoiceConnectorOriginationRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.GetVoiceConnectorProxyRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.GetVoiceConnectorRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.GetVoiceConnectorStreamingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.GetVoiceConnectorTerminationHealthRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.GetVoiceConnectorTerminationRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.GetVoiceProfileDomainRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.GetVoiceProfileRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.GetVoiceToneAnalysisTaskRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.ListAvailableVoiceConnectorRegionsRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.ListPhoneNumberOrdersRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.ListPhoneNumbersRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.ListProxySessionsRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.ListSipMediaApplicationsRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.ListSipRulesRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.ListSupportedPhoneNumberCountriesRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.ListVoiceConnectorGroupsRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.ListVoiceConnectorTerminationCredentialsRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.ListVoiceConnectorsRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.ListVoiceProfileDomainsRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.ListVoiceProfilesRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.PutSipMediaApplicationAlexaSkillConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.PutSipMediaApplicationLoggingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.PutVoiceConnectorEmergencyCallingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.PutVoiceConnectorLoggingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.PutVoiceConnectorOriginationRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.PutVoiceConnectorProxyRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.PutVoiceConnectorStreamingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.PutVoiceConnectorTerminationCredentialsRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.PutVoiceConnectorTerminationRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.RestorePhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.SearchAvailablePhoneNumbersRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.StartSpeakerSearchTaskRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.StartVoiceToneAnalysisTaskRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.StopSpeakerSearchTaskRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.StopVoiceToneAnalysisTaskRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.UpdateGlobalSettingsRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.UpdatePhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.UpdatePhoneNumberSettingsRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.UpdateProxySessionRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.UpdateSipMediaApplicationCallRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.UpdateSipMediaApplicationRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.UpdateSipRuleRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.UpdateVoiceConnectorGroupRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.UpdateVoiceConnectorRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.UpdateVoiceProfileDomainRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.UpdateVoiceProfileRequestMarshaller;
import software.amazon.awssdk.services.chimesdkvoice.transform.ValidateE911AddressRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link ChimeSdkVoiceAsyncClient}.
 *
 * @see ChimeSdkVoiceAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultChimeSdkVoiceAsyncClient implements ChimeSdkVoiceAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultChimeSdkVoiceAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final ChimeSdkVoiceServiceClientConfiguration serviceClientConfiguration;

    protected DefaultChimeSdkVoiceAsyncClient(ChimeSdkVoiceServiceClientConfiguration serviceClientConfiguration,
            SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * Invokes the AssociatePhoneNumbersWithVoiceConnector operation asynchronously.
     *
     * @param associatePhoneNumbersWithVoiceConnectorRequest
     * @return A Java Future containing the result of the AssociatePhoneNumbersWithVoiceConnector operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.AssociatePhoneNumbersWithVoiceConnector
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/AssociatePhoneNumbersWithVoiceConnector"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociatePhoneNumbersWithVoiceConnectorResponse> associatePhoneNumbersWithVoiceConnector(
            AssociatePhoneNumbersWithVoiceConnectorRequest associatePhoneNumbersWithVoiceConnectorRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associatePhoneNumbersWithVoiceConnectorRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociatePhoneNumbersWithVoiceConnector");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociatePhoneNumbersWithVoiceConnectorResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, AssociatePhoneNumbersWithVoiceConnectorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociatePhoneNumbersWithVoiceConnectorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociatePhoneNumbersWithVoiceConnectorRequest, AssociatePhoneNumbersWithVoiceConnectorResponse>()
                            .withOperationName("AssociatePhoneNumbersWithVoiceConnector")
                            .withMarshaller(new AssociatePhoneNumbersWithVoiceConnectorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(associatePhoneNumbersWithVoiceConnectorRequest));
            CompletableFuture<AssociatePhoneNumbersWithVoiceConnectorResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the AssociatePhoneNumbersWithVoiceConnectorGroup operation asynchronously.
     *
     * @param associatePhoneNumbersWithVoiceConnectorGroupRequest
     * @return A Java Future containing the result of the AssociatePhoneNumbersWithVoiceConnectorGroup operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.AssociatePhoneNumbersWithVoiceConnectorGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/AssociatePhoneNumbersWithVoiceConnectorGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociatePhoneNumbersWithVoiceConnectorGroupResponse> associatePhoneNumbersWithVoiceConnectorGroup(
            AssociatePhoneNumbersWithVoiceConnectorGroupRequest associatePhoneNumbersWithVoiceConnectorGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associatePhoneNumbersWithVoiceConnectorGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociatePhoneNumbersWithVoiceConnectorGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociatePhoneNumbersWithVoiceConnectorGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, AssociatePhoneNumbersWithVoiceConnectorGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociatePhoneNumbersWithVoiceConnectorGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociatePhoneNumbersWithVoiceConnectorGroupRequest, AssociatePhoneNumbersWithVoiceConnectorGroupResponse>()
                            .withOperationName("AssociatePhoneNumbersWithVoiceConnectorGroup")
                            .withMarshaller(new AssociatePhoneNumbersWithVoiceConnectorGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(associatePhoneNumbersWithVoiceConnectorGroupRequest));
            CompletableFuture<AssociatePhoneNumbersWithVoiceConnectorGroupResponse> whenCompleted = executeFuture.whenComplete((
                    r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the BatchDeletePhoneNumber operation asynchronously.
     *
     * @param batchDeletePhoneNumberRequest
     * @return A Java Future containing the result of the BatchDeletePhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.BatchDeletePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/BatchDeletePhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDeletePhoneNumberResponse> batchDeletePhoneNumber(
            BatchDeletePhoneNumberRequest batchDeletePhoneNumberRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDeletePhoneNumberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDeletePhoneNumber");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDeletePhoneNumberResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchDeletePhoneNumberResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchDeletePhoneNumberResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDeletePhoneNumberRequest, BatchDeletePhoneNumberResponse>()
                            .withOperationName("BatchDeletePhoneNumber")
                            .withMarshaller(new BatchDeletePhoneNumberRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(batchDeletePhoneNumberRequest));
            CompletableFuture<BatchDeletePhoneNumberResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the BatchUpdatePhoneNumber operation asynchronously.
     *
     * @param batchUpdatePhoneNumberRequest
     * @return A Java Future containing the result of the BatchUpdatePhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.BatchUpdatePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/BatchUpdatePhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchUpdatePhoneNumberResponse> batchUpdatePhoneNumber(
            BatchUpdatePhoneNumberRequest batchUpdatePhoneNumberRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchUpdatePhoneNumberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchUpdatePhoneNumber");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchUpdatePhoneNumberResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchUpdatePhoneNumberResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchUpdatePhoneNumberResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchUpdatePhoneNumberRequest, BatchUpdatePhoneNumberResponse>()
                            .withOperationName("BatchUpdatePhoneNumber")
                            .withMarshaller(new BatchUpdatePhoneNumberRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(batchUpdatePhoneNumberRequest));
            CompletableFuture<BatchUpdatePhoneNumberResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the CreatePhoneNumberOrder operation asynchronously.
     *
     * @param createPhoneNumberOrderRequest
     * @return A Java Future containing the result of the CreatePhoneNumberOrder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException</li>
     *         <li>ForbiddenException</li>
     *         <li>AccessDeniedException</li>
     *         <li>UnauthorizedClientException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ResourceLimitExceededException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.CreatePhoneNumberOrder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreatePhoneNumberOrder"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePhoneNumberOrderResponse> createPhoneNumberOrder(
            CreatePhoneNumberOrderRequest createPhoneNumberOrderRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPhoneNumberOrderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePhoneNumberOrder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePhoneNumberOrderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreatePhoneNumberOrderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreatePhoneNumberOrderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePhoneNumberOrderRequest, CreatePhoneNumberOrderResponse>()
                            .withOperationName("CreatePhoneNumberOrder")
                            .withMarshaller(new CreatePhoneNumberOrderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createPhoneNumberOrderRequest));
            CompletableFuture<CreatePhoneNumberOrderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the CreateProxySession operation asynchronously.
     *
     * @param createProxySessionRequest
     * @return A Java Future containing the result of the CreateProxySession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.CreateProxySession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateProxySession"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateProxySessionResponse> createProxySession(CreateProxySessionRequest createProxySessionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createProxySessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateProxySession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateProxySessionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateProxySessionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateProxySessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateProxySessionRequest, CreateProxySessionResponse>()
                            .withOperationName("CreateProxySession")
                            .withMarshaller(new CreateProxySessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createProxySessionRequest));
            CompletableFuture<CreateProxySessionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the CreateSipMediaApplication operation asynchronously.
     *
     * @param createSipMediaApplicationRequest
     * @return A Java Future containing the result of the CreateSipMediaApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException</li>
     *         <li>ForbiddenException</li>
     *         <li>AccessDeniedException</li>
     *         <li>UnauthorizedClientException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ResourceLimitExceededException</li>
     *         <li>ConflictException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.CreateSipMediaApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateSipMediaApplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSipMediaApplicationResponse> createSipMediaApplication(
            CreateSipMediaApplicationRequest createSipMediaApplicationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSipMediaApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSipMediaApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSipMediaApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateSipMediaApplicationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSipMediaApplicationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSipMediaApplicationRequest, CreateSipMediaApplicationResponse>()
                            .withOperationName("CreateSipMediaApplication")
                            .withMarshaller(new CreateSipMediaApplicationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createSipMediaApplicationRequest));
            CompletableFuture<CreateSipMediaApplicationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the CreateSipMediaApplicationCall operation asynchronously.
     *
     * @param createSipMediaApplicationCallRequest
     * @return A Java Future containing the result of the CreateSipMediaApplicationCall operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException</li>
     *         <li>ForbiddenException</li>
     *         <li>ResourceLimitExceededException</li>
     *         <li>ThrottledClientException</li>
     *         <li>UnauthorizedClientException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.CreateSipMediaApplicationCall
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateSipMediaApplicationCall"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSipMediaApplicationCallResponse> createSipMediaApplicationCall(
            CreateSipMediaApplicationCallRequest createSipMediaApplicationCallRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createSipMediaApplicationCallRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSipMediaApplicationCall");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSipMediaApplicationCallResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateSipMediaApplicationCallResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSipMediaApplicationCallResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSipMediaApplicationCallRequest, CreateSipMediaApplicationCallResponse>()
                            .withOperationName("CreateSipMediaApplicationCall")
                            .withMarshaller(new CreateSipMediaApplicationCallRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createSipMediaApplicationCallRequest));
            CompletableFuture<CreateSipMediaApplicationCallResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the CreateSipRule operation asynchronously.
     *
     * @param createSipRuleRequest
     * @return A Java Future containing the result of the CreateSipRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException</li>
     *         <li>ForbiddenException</li>
     *         <li>AccessDeniedException</li>
     *         <li>UnauthorizedClientException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ResourceLimitExceededException</li>
     *         <li>ConflictException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.CreateSipRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateSipRule" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSipRuleResponse> createSipRule(CreateSipRuleRequest createSipRuleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSipRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSipRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSipRuleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateSipRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSipRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSipRuleRequest, CreateSipRuleResponse>()
                            .withOperationName("CreateSipRule")
                            .withMarshaller(new CreateSipRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createSipRuleRequest));
            CompletableFuture<CreateSipRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the CreateVoiceConnector operation asynchronously.
     *
     * @param createVoiceConnectorRequest
     * @return A Java Future containing the result of the CreateVoiceConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException</li>
     *         <li>ForbiddenException</li>
     *         <li>AccessDeniedException</li>
     *         <li>UnauthorizedClientException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ResourceLimitExceededException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.CreateVoiceConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateVoiceConnector"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVoiceConnectorResponse> createVoiceConnector(
            CreateVoiceConnectorRequest createVoiceConnectorRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVoiceConnectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVoiceConnector");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateVoiceConnectorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateVoiceConnectorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateVoiceConnectorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVoiceConnectorRequest, CreateVoiceConnectorResponse>()
                            .withOperationName("CreateVoiceConnector")
                            .withMarshaller(new CreateVoiceConnectorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createVoiceConnectorRequest));
            CompletableFuture<CreateVoiceConnectorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the CreateVoiceConnectorGroup operation asynchronously.
     *
     * @param createVoiceConnectorGroupRequest
     * @return A Java Future containing the result of the CreateVoiceConnectorGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException</li>
     *         <li>ForbiddenException</li>
     *         <li>AccessDeniedException</li>
     *         <li>UnauthorizedClientException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ResourceLimitExceededException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.CreateVoiceConnectorGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateVoiceConnectorGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVoiceConnectorGroupResponse> createVoiceConnectorGroup(
            CreateVoiceConnectorGroupRequest createVoiceConnectorGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVoiceConnectorGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVoiceConnectorGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateVoiceConnectorGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateVoiceConnectorGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateVoiceConnectorGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVoiceConnectorGroupRequest, CreateVoiceConnectorGroupResponse>()
                            .withOperationName("CreateVoiceConnectorGroup")
                            .withMarshaller(new CreateVoiceConnectorGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createVoiceConnectorGroupRequest));
            CompletableFuture<CreateVoiceConnectorGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the CreateVoiceProfile operation asynchronously.
     *
     * @param createVoiceProfileRequest
     * @return A Java Future containing the result of the CreateVoiceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException</li>
     *         <li>ResourceLimitExceededException</li>
     *         <li>UnauthorizedClientException</li>
     *         <li>ForbiddenException</li>
     *         <li>AccessDeniedException</li>
     *         <li>NotFoundException</li>
     *         <li>ConflictException</li>
     *         <li>GoneException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.CreateVoiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateVoiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVoiceProfileResponse> createVoiceProfile(CreateVoiceProfileRequest createVoiceProfileRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVoiceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVoiceProfile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateVoiceProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateVoiceProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateVoiceProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVoiceProfileRequest, CreateVoiceProfileResponse>()
                            .withOperationName("CreateVoiceProfile")
                            .withMarshaller(new CreateVoiceProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createVoiceProfileRequest));
            CompletableFuture<CreateVoiceProfileResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the CreateVoiceProfileDomain operation asynchronously.
     *
     * @param createVoiceProfileDomainRequest
     * @return A Java Future containing the result of the CreateVoiceProfileDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException</li>
     *         <li>ForbiddenException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ConflictException</li>
     *         <li>UnauthorizedClientException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ResourceLimitExceededException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.CreateVoiceProfileDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateVoiceProfileDomain"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVoiceProfileDomainResponse> createVoiceProfileDomain(
            CreateVoiceProfileDomainRequest createVoiceProfileDomainRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVoiceProfileDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVoiceProfileDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateVoiceProfileDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateVoiceProfileDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateVoiceProfileDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVoiceProfileDomainRequest, CreateVoiceProfileDomainResponse>()
                            .withOperationName("CreateVoiceProfileDomain")
                            .withMarshaller(new CreateVoiceProfileDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createVoiceProfileDomainRequest));
            CompletableFuture<CreateVoiceProfileDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the DeletePhoneNumber operation asynchronously.
     *
     * @param deletePhoneNumberRequest
     * @return A Java Future containing the result of the DeletePhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeletePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeletePhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePhoneNumberResponse> deletePhoneNumber(DeletePhoneNumberRequest deletePhoneNumberRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePhoneNumberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePhoneNumber");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeletePhoneNumberResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeletePhoneNumberResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeletePhoneNumberResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePhoneNumberRequest, DeletePhoneNumberResponse>()
                            .withOperationName("DeletePhoneNumber")
                            .withMarshaller(new DeletePhoneNumberRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deletePhoneNumberRequest));
            CompletableFuture<DeletePhoneNumberResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the DeleteProxySession operation asynchronously.
     *
     * @param deleteProxySessionRequest
     * @return A Java Future containing the result of the DeleteProxySession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteProxySession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteProxySession"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteProxySessionResponse> deleteProxySession(DeleteProxySessionRequest deleteProxySessionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteProxySessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteProxySession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteProxySessionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteProxySessionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteProxySessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteProxySessionRequest, DeleteProxySessionResponse>()
                            .withOperationName("DeleteProxySession")
                            .withMarshaller(new DeleteProxySessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteProxySessionRequest));
            CompletableFuture<DeleteProxySessionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the DeleteSipMediaApplication operation asynchronously.
     *
     * @param deleteSipMediaApplicationRequest
     * @return A Java Future containing the result of the DeleteSipMediaApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ConflictException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteSipMediaApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteSipMediaApplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSipMediaApplicationResponse> deleteSipMediaApplication(
            DeleteSipMediaApplicationRequest deleteSipMediaApplicationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSipMediaApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSipMediaApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSipMediaApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteSipMediaApplicationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteSipMediaApplicationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSipMediaApplicationRequest, DeleteSipMediaApplicationResponse>()
                            .withOperationName("DeleteSipMediaApplication")
                            .withMarshaller(new DeleteSipMediaApplicationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteSipMediaApplicationRequest));
            CompletableFuture<DeleteSipMediaApplicationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the DeleteSipRule operation asynchronously.
     *
     * @param deleteSipRuleRequest
     * @return A Java Future containing the result of the DeleteSipRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ConflictException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteSipRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteSipRule" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSipRuleResponse> deleteSipRule(DeleteSipRuleRequest deleteSipRuleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSipRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSipRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSipRuleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteSipRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteSipRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSipRuleRequest, DeleteSipRuleResponse>()
                            .withOperationName("DeleteSipRule")
                            .withMarshaller(new DeleteSipRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteSipRuleRequest));
            CompletableFuture<DeleteSipRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the DeleteVoiceConnector operation asynchronously.
     *
     * @param deleteVoiceConnectorRequest
     * @return A Java Future containing the result of the DeleteVoiceConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ConflictException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteVoiceConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnector"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVoiceConnectorResponse> deleteVoiceConnector(
            DeleteVoiceConnectorRequest deleteVoiceConnectorRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVoiceConnectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVoiceConnector");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteVoiceConnectorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteVoiceConnectorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteVoiceConnectorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVoiceConnectorRequest, DeleteVoiceConnectorResponse>()
                            .withOperationName("DeleteVoiceConnector")
                            .withMarshaller(new DeleteVoiceConnectorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteVoiceConnectorRequest));
            CompletableFuture<DeleteVoiceConnectorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the DeleteVoiceConnectorEmergencyCallingConfiguration operation asynchronously.
     *
     * @param deleteVoiceConnectorEmergencyCallingConfigurationRequest
     * @return A Java Future containing the result of the DeleteVoiceConnectorEmergencyCallingConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteVoiceConnectorEmergencyCallingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorEmergencyCallingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVoiceConnectorEmergencyCallingConfigurationResponse> deleteVoiceConnectorEmergencyCallingConfiguration(
            DeleteVoiceConnectorEmergencyCallingConfigurationRequest deleteVoiceConnectorEmergencyCallingConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteVoiceConnectorEmergencyCallingConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVoiceConnectorEmergencyCallingConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteVoiceConnectorEmergencyCallingConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteVoiceConnectorEmergencyCallingConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteVoiceConnectorEmergencyCallingConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVoiceConnectorEmergencyCallingConfigurationRequest, DeleteVoiceConnectorEmergencyCallingConfigurationResponse>()
                            .withOperationName("DeleteVoiceConnectorEmergencyCallingConfiguration")
                            .withMarshaller(
                                    new DeleteVoiceConnectorEmergencyCallingConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteVoiceConnectorEmergencyCallingConfigurationRequest));
            CompletableFuture<DeleteVoiceConnectorEmergencyCallingConfigurationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the DeleteVoiceConnectorGroup operation asynchronously.
     *
     * @param deleteVoiceConnectorGroupRequest
     * @return A Java Future containing the result of the DeleteVoiceConnectorGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ConflictException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteVoiceConnectorGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVoiceConnectorGroupResponse> deleteVoiceConnectorGroup(
            DeleteVoiceConnectorGroupRequest deleteVoiceConnectorGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVoiceConnectorGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVoiceConnectorGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteVoiceConnectorGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteVoiceConnectorGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteVoiceConnectorGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVoiceConnectorGroupRequest, DeleteVoiceConnectorGroupResponse>()
                            .withOperationName("DeleteVoiceConnectorGroup")
                            .withMarshaller(new DeleteVoiceConnectorGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteVoiceConnectorGroupRequest));
            CompletableFuture<DeleteVoiceConnectorGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the DeleteVoiceConnectorOrigination operation asynchronously.
     *
     * @param deleteVoiceConnectorOriginationRequest
     * @return A Java Future containing the result of the DeleteVoiceConnectorOrigination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteVoiceConnectorOrigination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorOrigination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVoiceConnectorOriginationResponse> deleteVoiceConnectorOrigination(
            DeleteVoiceConnectorOriginationRequest deleteVoiceConnectorOriginationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteVoiceConnectorOriginationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVoiceConnectorOrigination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteVoiceConnectorOriginationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteVoiceConnectorOriginationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteVoiceConnectorOriginationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVoiceConnectorOriginationRequest, DeleteVoiceConnectorOriginationResponse>()
                            .withOperationName("DeleteVoiceConnectorOrigination")
                            .withMarshaller(new DeleteVoiceConnectorOriginationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteVoiceConnectorOriginationRequest));
            CompletableFuture<DeleteVoiceConnectorOriginationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the DeleteVoiceConnectorProxy operation asynchronously.
     *
     * @param deleteVoiceConnectorProxyRequest
     * @return A Java Future containing the result of the DeleteVoiceConnectorProxy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteVoiceConnectorProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorProxy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVoiceConnectorProxyResponse> deleteVoiceConnectorProxy(
            DeleteVoiceConnectorProxyRequest deleteVoiceConnectorProxyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVoiceConnectorProxyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVoiceConnectorProxy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteVoiceConnectorProxyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteVoiceConnectorProxyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteVoiceConnectorProxyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVoiceConnectorProxyRequest, DeleteVoiceConnectorProxyResponse>()
                            .withOperationName("DeleteVoiceConnectorProxy")
                            .withMarshaller(new DeleteVoiceConnectorProxyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteVoiceConnectorProxyRequest));
            CompletableFuture<DeleteVoiceConnectorProxyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the DeleteVoiceConnectorStreamingConfiguration operation asynchronously.
     *
     * @param deleteVoiceConnectorStreamingConfigurationRequest
     * @return A Java Future containing the result of the DeleteVoiceConnectorStreamingConfiguration operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteVoiceConnectorStreamingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorStreamingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVoiceConnectorStreamingConfigurationResponse> deleteVoiceConnectorStreamingConfiguration(
            DeleteVoiceConnectorStreamingConfigurationRequest deleteVoiceConnectorStreamingConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteVoiceConnectorStreamingConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVoiceConnectorStreamingConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteVoiceConnectorStreamingConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteVoiceConnectorStreamingConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteVoiceConnectorStreamingConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVoiceConnectorStreamingConfigurationRequest, DeleteVoiceConnectorStreamingConfigurationResponse>()
                            .withOperationName("DeleteVoiceConnectorStreamingConfiguration")
                            .withMarshaller(new DeleteVoiceConnectorStreamingConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteVoiceConnectorStreamingConfigurationRequest));
            CompletableFuture<DeleteVoiceConnectorStreamingConfigurationResponse> whenCompleted = executeFuture.whenComplete((r,
                    e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the DeleteVoiceConnectorTermination operation asynchronously.
     *
     * @param deleteVoiceConnectorTerminationRequest
     * @return A Java Future containing the result of the DeleteVoiceConnectorTermination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteVoiceConnectorTermination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorTermination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVoiceConnectorTerminationResponse> deleteVoiceConnectorTermination(
            DeleteVoiceConnectorTerminationRequest deleteVoiceConnectorTerminationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteVoiceConnectorTerminationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVoiceConnectorTermination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteVoiceConnectorTerminationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteVoiceConnectorTerminationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteVoiceConnectorTerminationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVoiceConnectorTerminationRequest, DeleteVoiceConnectorTerminationResponse>()
                            .withOperationName("DeleteVoiceConnectorTermination")
                            .withMarshaller(new DeleteVoiceConnectorTerminationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteVoiceConnectorTerminationRequest));
            CompletableFuture<DeleteVoiceConnectorTerminationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the DeleteVoiceConnectorTerminationCredentials operation asynchronously.
     *
     * @param deleteVoiceConnectorTerminationCredentialsRequest
     * @return A Java Future containing the result of the DeleteVoiceConnectorTerminationCredentials operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteVoiceConnectorTerminationCredentials
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorTerminationCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVoiceConnectorTerminationCredentialsResponse> deleteVoiceConnectorTerminationCredentials(
            DeleteVoiceConnectorTerminationCredentialsRequest deleteVoiceConnectorTerminationCredentialsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteVoiceConnectorTerminationCredentialsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVoiceConnectorTerminationCredentials");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteVoiceConnectorTerminationCredentialsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteVoiceConnectorTerminationCredentialsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteVoiceConnectorTerminationCredentialsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVoiceConnectorTerminationCredentialsRequest, DeleteVoiceConnectorTerminationCredentialsResponse>()
                            .withOperationName("DeleteVoiceConnectorTerminationCredentials")
                            .withMarshaller(new DeleteVoiceConnectorTerminationCredentialsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteVoiceConnectorTerminationCredentialsRequest));
            CompletableFuture<DeleteVoiceConnectorTerminationCredentialsResponse> whenCompleted = executeFuture.whenComplete((r,
                    e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the DeleteVoiceProfile operation asynchronously.
     *
     * @param deleteVoiceProfileRequest
     * @return A Java Future containing the result of the DeleteVoiceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException</li>
     *         <li>UnauthorizedClientException</li>
     *         <li>ForbiddenException</li>
     *         <li>AccessDeniedException</li>
     *         <li>NotFoundException</li>
     *         <li>ConflictException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteVoiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVoiceProfileResponse> deleteVoiceProfile(DeleteVoiceProfileRequest deleteVoiceProfileRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVoiceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVoiceProfile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteVoiceProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteVoiceProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteVoiceProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVoiceProfileRequest, DeleteVoiceProfileResponse>()
                            .withOperationName("DeleteVoiceProfile")
                            .withMarshaller(new DeleteVoiceProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteVoiceProfileRequest));
            CompletableFuture<DeleteVoiceProfileResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the DeleteVoiceProfileDomain operation asynchronously.
     *
     * @param deleteVoiceProfileDomainRequest
     * @return A Java Future containing the result of the DeleteVoiceProfileDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>AccessDeniedException</li>
     *         <li>BadRequestException</li>
     *         <li>ConflictException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteVoiceProfileDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceProfileDomain"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVoiceProfileDomainResponse> deleteVoiceProfileDomain(
            DeleteVoiceProfileDomainRequest deleteVoiceProfileDomainRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVoiceProfileDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVoiceProfileDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteVoiceProfileDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteVoiceProfileDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteVoiceProfileDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVoiceProfileDomainRequest, DeleteVoiceProfileDomainResponse>()
                            .withOperationName("DeleteVoiceProfileDomain")
                            .withMarshaller(new DeleteVoiceProfileDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteVoiceProfileDomainRequest));
            CompletableFuture<DeleteVoiceProfileDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the DisassociatePhoneNumbersFromVoiceConnector operation asynchronously.
     *
     * @param disassociatePhoneNumbersFromVoiceConnectorRequest
     * @return A Java Future containing the result of the DisassociatePhoneNumbersFromVoiceConnector operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DisassociatePhoneNumbersFromVoiceConnector
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DisassociatePhoneNumbersFromVoiceConnector"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociatePhoneNumbersFromVoiceConnectorResponse> disassociatePhoneNumbersFromVoiceConnector(
            DisassociatePhoneNumbersFromVoiceConnectorRequest disassociatePhoneNumbersFromVoiceConnectorRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociatePhoneNumbersFromVoiceConnectorRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociatePhoneNumbersFromVoiceConnector");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociatePhoneNumbersFromVoiceConnectorResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisassociatePhoneNumbersFromVoiceConnectorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociatePhoneNumbersFromVoiceConnectorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociatePhoneNumbersFromVoiceConnectorRequest, DisassociatePhoneNumbersFromVoiceConnectorResponse>()
                            .withOperationName("DisassociatePhoneNumbersFromVoiceConnector")
                            .withMarshaller(new DisassociatePhoneNumbersFromVoiceConnectorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociatePhoneNumbersFromVoiceConnectorRequest));
            CompletableFuture<DisassociatePhoneNumbersFromVoiceConnectorResponse> whenCompleted = executeFuture.whenComplete((r,
                    e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the DisassociatePhoneNumbersFromVoiceConnectorGroup operation asynchronously.
     *
     * @param disassociatePhoneNumbersFromVoiceConnectorGroupRequest
     * @return A Java Future containing the result of the DisassociatePhoneNumbersFromVoiceConnectorGroup operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DisassociatePhoneNumbersFromVoiceConnectorGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DisassociatePhoneNumbersFromVoiceConnectorGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociatePhoneNumbersFromVoiceConnectorGroupResponse> disassociatePhoneNumbersFromVoiceConnectorGroup(
            DisassociatePhoneNumbersFromVoiceConnectorGroupRequest disassociatePhoneNumbersFromVoiceConnectorGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociatePhoneNumbersFromVoiceConnectorGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociatePhoneNumbersFromVoiceConnectorGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociatePhoneNumbersFromVoiceConnectorGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisassociatePhoneNumbersFromVoiceConnectorGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociatePhoneNumbersFromVoiceConnectorGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociatePhoneNumbersFromVoiceConnectorGroupRequest, DisassociatePhoneNumbersFromVoiceConnectorGroupResponse>()
                            .withOperationName("DisassociatePhoneNumbersFromVoiceConnectorGroup")
                            .withMarshaller(new DisassociatePhoneNumbersFromVoiceConnectorGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociatePhoneNumbersFromVoiceConnectorGroupRequest));
            CompletableFuture<DisassociatePhoneNumbersFromVoiceConnectorGroupResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the GetGlobalSettings operation asynchronously.
     *
     * @param getGlobalSettingsRequest
     * @return A Java Future containing the result of the GetGlobalSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetGlobalSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetGlobalSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetGlobalSettingsResponse> getGlobalSettings(GetGlobalSettingsRequest getGlobalSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getGlobalSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGlobalSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetGlobalSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetGlobalSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetGlobalSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetGlobalSettingsRequest, GetGlobalSettingsResponse>()
                            .withOperationName("GetGlobalSettings")
                            .withMarshaller(new GetGlobalSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getGlobalSettingsRequest));
            CompletableFuture<GetGlobalSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the GetPhoneNumber operation asynchronously.
     *
     * @param getPhoneNumberRequest
     * @return A Java Future containing the result of the GetPhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetPhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetPhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetPhoneNumberResponse> getPhoneNumber(GetPhoneNumberRequest getPhoneNumberRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPhoneNumberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPhoneNumber");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetPhoneNumberResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetPhoneNumberResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetPhoneNumberResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPhoneNumberRequest, GetPhoneNumberResponse>()
                            .withOperationName("GetPhoneNumber")
                            .withMarshaller(new GetPhoneNumberRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getPhoneNumberRequest));
            CompletableFuture<GetPhoneNumberResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the GetPhoneNumberOrder operation asynchronously.
     *
     * @param getPhoneNumberOrderRequest
     * @return A Java Future containing the result of the GetPhoneNumberOrder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetPhoneNumberOrder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetPhoneNumberOrder"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetPhoneNumberOrderResponse> getPhoneNumberOrder(
            GetPhoneNumberOrderRequest getPhoneNumberOrderRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPhoneNumberOrderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPhoneNumberOrder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetPhoneNumberOrderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetPhoneNumberOrderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetPhoneNumberOrderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPhoneNumberOrderRequest, GetPhoneNumberOrderResponse>()
                            .withOperationName("GetPhoneNumberOrder")
                            .withMarshaller(new GetPhoneNumberOrderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getPhoneNumberOrderRequest));
            CompletableFuture<GetPhoneNumberOrderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the GetPhoneNumberSettings operation asynchronously.
     *
     * @param getPhoneNumberSettingsRequest
     * @return A Java Future containing the result of the GetPhoneNumberSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetPhoneNumberSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetPhoneNumberSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetPhoneNumberSettingsResponse> getPhoneNumberSettings(
            GetPhoneNumberSettingsRequest getPhoneNumberSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPhoneNumberSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPhoneNumberSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetPhoneNumberSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetPhoneNumberSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetPhoneNumberSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPhoneNumberSettingsRequest, GetPhoneNumberSettingsResponse>()
                            .withOperationName("GetPhoneNumberSettings")
                            .withMarshaller(new GetPhoneNumberSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getPhoneNumberSettingsRequest));
            CompletableFuture<GetPhoneNumberSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the GetProxySession operation asynchronously.
     *
     * @param getProxySessionRequest
     * @return A Java Future containing the result of the GetProxySession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetProxySession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetProxySession"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetProxySessionResponse> getProxySession(GetProxySessionRequest getProxySessionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getProxySessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetProxySession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetProxySessionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetProxySessionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetProxySessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetProxySessionRequest, GetProxySessionResponse>()
                            .withOperationName("GetProxySession")
                            .withMarshaller(new GetProxySessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getProxySessionRequest));
            CompletableFuture<GetProxySessionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the GetSipMediaApplication operation asynchronously.
     *
     * @param getSipMediaApplicationRequest
     * @return A Java Future containing the result of the GetSipMediaApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetSipMediaApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetSipMediaApplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSipMediaApplicationResponse> getSipMediaApplication(
            GetSipMediaApplicationRequest getSipMediaApplicationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSipMediaApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSipMediaApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSipMediaApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSipMediaApplicationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSipMediaApplicationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSipMediaApplicationRequest, GetSipMediaApplicationResponse>()
                            .withOperationName("GetSipMediaApplication")
                            .withMarshaller(new GetSipMediaApplicationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getSipMediaApplicationRequest));
            CompletableFuture<GetSipMediaApplicationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the GetSipMediaApplicationAlexaSkillConfiguration operation asynchronously.
     *
     * @param getSipMediaApplicationAlexaSkillConfigurationRequest
     * @return A Java Future containing the result of the GetSipMediaApplicationAlexaSkillConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetSipMediaApplicationAlexaSkillConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetSipMediaApplicationAlexaSkillConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSipMediaApplicationAlexaSkillConfigurationResponse> getSipMediaApplicationAlexaSkillConfiguration(
            GetSipMediaApplicationAlexaSkillConfigurationRequest getSipMediaApplicationAlexaSkillConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getSipMediaApplicationAlexaSkillConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSipMediaApplicationAlexaSkillConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSipMediaApplicationAlexaSkillConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetSipMediaApplicationAlexaSkillConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSipMediaApplicationAlexaSkillConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSipMediaApplicationAlexaSkillConfigurationRequest, GetSipMediaApplicationAlexaSkillConfigurationResponse>()
                            .withOperationName("GetSipMediaApplicationAlexaSkillConfiguration")
                            .withMarshaller(new GetSipMediaApplicationAlexaSkillConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(getSipMediaApplicationAlexaSkillConfigurationRequest));
            CompletableFuture<GetSipMediaApplicationAlexaSkillConfigurationResponse> whenCompleted = executeFuture.whenComplete((
                    r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the GetSipMediaApplicationLoggingConfiguration operation asynchronously.
     *
     * @param getSipMediaApplicationLoggingConfigurationRequest
     * @return A Java Future containing the result of the GetSipMediaApplicationLoggingConfiguration operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetSipMediaApplicationLoggingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetSipMediaApplicationLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSipMediaApplicationLoggingConfigurationResponse> getSipMediaApplicationLoggingConfiguration(
            GetSipMediaApplicationLoggingConfigurationRequest getSipMediaApplicationLoggingConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getSipMediaApplicationLoggingConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSipMediaApplicationLoggingConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSipMediaApplicationLoggingConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetSipMediaApplicationLoggingConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSipMediaApplicationLoggingConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSipMediaApplicationLoggingConfigurationRequest, GetSipMediaApplicationLoggingConfigurationResponse>()
                            .withOperationName("GetSipMediaApplicationLoggingConfiguration")
                            .withMarshaller(new GetSipMediaApplicationLoggingConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(getSipMediaApplicationLoggingConfigurationRequest));
            CompletableFuture<GetSipMediaApplicationLoggingConfigurationResponse> whenCompleted = executeFuture.whenComplete((r,
                    e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the GetSipRule operation asynchronously.
     *
     * @param getSipRuleRequest
     * @return A Java Future containing the result of the GetSipRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetSipRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetSipRule" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSipRuleResponse> getSipRule(GetSipRuleRequest getSipRuleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSipRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSipRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSipRuleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetSipRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSipRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSipRuleRequest, GetSipRuleResponse>().withOperationName("GetSipRule")
                            .withMarshaller(new GetSipRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getSipRuleRequest));
            CompletableFuture<GetSipRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the GetSpeakerSearchTask operation asynchronously.
     *
     * @param getSpeakerSearchTaskRequest
     * @return A Java Future containing the result of the GetSpeakerSearchTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException</li>
     *         <li>ForbiddenException</li>
     *         <li>NotFoundException</li>
     *         <li>ConflictException</li>
     *         <li>ThrottledClientException</li>
     *         <li>AccessDeniedException</li>
     *         <li>UnauthorizedClientException</li>
     *         <li>ServiceFailureException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetSpeakerSearchTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetSpeakerSearchTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSpeakerSearchTaskResponse> getSpeakerSearchTask(
            GetSpeakerSearchTaskRequest getSpeakerSearchTaskRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSpeakerSearchTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSpeakerSearchTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSpeakerSearchTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSpeakerSearchTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSpeakerSearchTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSpeakerSearchTaskRequest, GetSpeakerSearchTaskResponse>()
                            .withOperationName("GetSpeakerSearchTask")
                            .withMarshaller(new GetSpeakerSearchTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getSpeakerSearchTaskRequest));
            CompletableFuture<GetSpeakerSearchTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the GetVoiceConnector operation asynchronously.
     *
     * @param getVoiceConnectorRequest
     * @return A Java Future containing the result of the GetVoiceConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnector"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetVoiceConnectorResponse> getVoiceConnector(GetVoiceConnectorRequest getVoiceConnectorRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVoiceConnectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVoiceConnector");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetVoiceConnectorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetVoiceConnectorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetVoiceConnectorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetVoiceConnectorRequest, GetVoiceConnectorResponse>()
                            .withOperationName("GetVoiceConnector")
                            .withMarshaller(new GetVoiceConnectorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getVoiceConnectorRequest));
            CompletableFuture<GetVoiceConnectorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the GetVoiceConnectorEmergencyCallingConfiguration operation asynchronously.
     *
     * @param getVoiceConnectorEmergencyCallingConfigurationRequest
     * @return A Java Future containing the result of the GetVoiceConnectorEmergencyCallingConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceConnectorEmergencyCallingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorEmergencyCallingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetVoiceConnectorEmergencyCallingConfigurationResponse> getVoiceConnectorEmergencyCallingConfiguration(
            GetVoiceConnectorEmergencyCallingConfigurationRequest getVoiceConnectorEmergencyCallingConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getVoiceConnectorEmergencyCallingConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVoiceConnectorEmergencyCallingConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetVoiceConnectorEmergencyCallingConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetVoiceConnectorEmergencyCallingConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetVoiceConnectorEmergencyCallingConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetVoiceConnectorEmergencyCallingConfigurationRequest, GetVoiceConnectorEmergencyCallingConfigurationResponse>()
                            .withOperationName("GetVoiceConnectorEmergencyCallingConfiguration")
                            .withMarshaller(new GetVoiceConnectorEmergencyCallingConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(getVoiceConnectorEmergencyCallingConfigurationRequest));
            CompletableFuture<GetVoiceConnectorEmergencyCallingConfigurationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the GetVoiceConnectorGroup operation asynchronously.
     *
     * @param getVoiceConnectorGroupRequest
     * @return A Java Future containing the result of the GetVoiceConnectorGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceConnectorGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetVoiceConnectorGroupResponse> getVoiceConnectorGroup(
            GetVoiceConnectorGroupRequest getVoiceConnectorGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVoiceConnectorGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVoiceConnectorGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetVoiceConnectorGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetVoiceConnectorGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetVoiceConnectorGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetVoiceConnectorGroupRequest, GetVoiceConnectorGroupResponse>()
                            .withOperationName("GetVoiceConnectorGroup")
                            .withMarshaller(new GetVoiceConnectorGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getVoiceConnectorGroupRequest));
            CompletableFuture<GetVoiceConnectorGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the GetVoiceConnectorLoggingConfiguration operation asynchronously.
     *
     * @param getVoiceConnectorLoggingConfigurationRequest
     * @return A Java Future containing the result of the GetVoiceConnectorLoggingConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceConnectorLoggingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetVoiceConnectorLoggingConfigurationResponse> getVoiceConnectorLoggingConfiguration(
            GetVoiceConnectorLoggingConfigurationRequest getVoiceConnectorLoggingConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getVoiceConnectorLoggingConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVoiceConnectorLoggingConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetVoiceConnectorLoggingConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetVoiceConnectorLoggingConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetVoiceConnectorLoggingConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetVoiceConnectorLoggingConfigurationRequest, GetVoiceConnectorLoggingConfigurationResponse>()
                            .withOperationName("GetVoiceConnectorLoggingConfiguration")
                            .withMarshaller(new GetVoiceConnectorLoggingConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getVoiceConnectorLoggingConfigurationRequest));
            CompletableFuture<GetVoiceConnectorLoggingConfigurationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the GetVoiceConnectorOrigination operation asynchronously.
     *
     * @param getVoiceConnectorOriginationRequest
     * @return A Java Future containing the result of the GetVoiceConnectorOrigination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceConnectorOrigination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorOrigination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetVoiceConnectorOriginationResponse> getVoiceConnectorOrigination(
            GetVoiceConnectorOriginationRequest getVoiceConnectorOriginationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVoiceConnectorOriginationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVoiceConnectorOrigination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetVoiceConnectorOriginationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetVoiceConnectorOriginationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetVoiceConnectorOriginationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetVoiceConnectorOriginationRequest, GetVoiceConnectorOriginationResponse>()
                            .withOperationName("GetVoiceConnectorOrigination")
                            .withMarshaller(new GetVoiceConnectorOriginationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getVoiceConnectorOriginationRequest));
            CompletableFuture<GetVoiceConnectorOriginationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the GetVoiceConnectorProxy operation asynchronously.
     *
     * @param getVoiceConnectorProxyRequest
     * @return A Java Future containing the result of the GetVoiceConnectorProxy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceConnectorProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorProxy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetVoiceConnectorProxyResponse> getVoiceConnectorProxy(
            GetVoiceConnectorProxyRequest getVoiceConnectorProxyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVoiceConnectorProxyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVoiceConnectorProxy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetVoiceConnectorProxyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetVoiceConnectorProxyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetVoiceConnectorProxyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetVoiceConnectorProxyRequest, GetVoiceConnectorProxyResponse>()
                            .withOperationName("GetVoiceConnectorProxy")
                            .withMarshaller(new GetVoiceConnectorProxyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getVoiceConnectorProxyRequest));
            CompletableFuture<GetVoiceConnectorProxyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the GetVoiceConnectorStreamingConfiguration operation asynchronously.
     *
     * @param getVoiceConnectorStreamingConfigurationRequest
     * @return A Java Future containing the result of the GetVoiceConnectorStreamingConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceConnectorStreamingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorStreamingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetVoiceConnectorStreamingConfigurationResponse> getVoiceConnectorStreamingConfiguration(
            GetVoiceConnectorStreamingConfigurationRequest getVoiceConnectorStreamingConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getVoiceConnectorStreamingConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVoiceConnectorStreamingConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetVoiceConnectorStreamingConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetVoiceConnectorStreamingConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetVoiceConnectorStreamingConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetVoiceConnectorStreamingConfigurationRequest, GetVoiceConnectorStreamingConfigurationResponse>()
                            .withOperationName("GetVoiceConnectorStreamingConfiguration")
                            .withMarshaller(new GetVoiceConnectorStreamingConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(getVoiceConnectorStreamingConfigurationRequest));
            CompletableFuture<GetVoiceConnectorStreamingConfigurationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the GetVoiceConnectorTermination operation asynchronously.
     *
     * @param getVoiceConnectorTerminationRequest
     * @return A Java Future containing the result of the GetVoiceConnectorTermination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceConnectorTermination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorTermination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetVoiceConnectorTerminationResponse> getVoiceConnectorTermination(
            GetVoiceConnectorTerminationRequest getVoiceConnectorTerminationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVoiceConnectorTerminationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVoiceConnectorTermination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetVoiceConnectorTerminationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetVoiceConnectorTerminationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetVoiceConnectorTerminationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetVoiceConnectorTerminationRequest, GetVoiceConnectorTerminationResponse>()
                            .withOperationName("GetVoiceConnectorTermination")
                            .withMarshaller(new GetVoiceConnectorTerminationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getVoiceConnectorTerminationRequest));
            CompletableFuture<GetVoiceConnectorTerminationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the GetVoiceConnectorTerminationHealth operation asynchronously.
     *
     * @param getVoiceConnectorTerminationHealthRequest
     * @return A Java Future containing the result of the GetVoiceConnectorTerminationHealth operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceConnectorTerminationHealth
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorTerminationHealth"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetVoiceConnectorTerminationHealthResponse> getVoiceConnectorTerminationHealth(
            GetVoiceConnectorTerminationHealthRequest getVoiceConnectorTerminationHealthRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getVoiceConnectorTerminationHealthRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVoiceConnectorTerminationHealth");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetVoiceConnectorTerminationHealthResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetVoiceConnectorTerminationHealthResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetVoiceConnectorTerminationHealthResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetVoiceConnectorTerminationHealthRequest, GetVoiceConnectorTerminationHealthResponse>()
                            .withOperationName("GetVoiceConnectorTerminationHealth")
                            .withMarshaller(new GetVoiceConnectorTerminationHealthRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getVoiceConnectorTerminationHealthRequest));
            CompletableFuture<GetVoiceConnectorTerminationHealthResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the GetVoiceProfile operation asynchronously.
     *
     * @param getVoiceProfileRequest
     * @return A Java Future containing the result of the GetVoiceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException</li>
     *         <li>UnauthorizedClientException</li>
     *         <li>ForbiddenException</li>
     *         <li>AccessDeniedException</li>
     *         <li>NotFoundException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetVoiceProfileResponse> getVoiceProfile(GetVoiceProfileRequest getVoiceProfileRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVoiceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVoiceProfile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetVoiceProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetVoiceProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetVoiceProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetVoiceProfileRequest, GetVoiceProfileResponse>()
                            .withOperationName("GetVoiceProfile")
                            .withMarshaller(new GetVoiceProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getVoiceProfileRequest));
            CompletableFuture<GetVoiceProfileResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the GetVoiceProfileDomain operation asynchronously.
     *
     * @param getVoiceProfileDomainRequest
     * @return A Java Future containing the result of the GetVoiceProfileDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>AccessDeniedException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceProfileDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceProfileDomain"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetVoiceProfileDomainResponse> getVoiceProfileDomain(
            GetVoiceProfileDomainRequest getVoiceProfileDomainRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVoiceProfileDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVoiceProfileDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetVoiceProfileDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetVoiceProfileDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetVoiceProfileDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetVoiceProfileDomainRequest, GetVoiceProfileDomainResponse>()
                            .withOperationName("GetVoiceProfileDomain")
                            .withMarshaller(new GetVoiceProfileDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getVoiceProfileDomainRequest));
            CompletableFuture<GetVoiceProfileDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the GetVoiceToneAnalysisTask operation asynchronously.
     *
     * @param getVoiceToneAnalysisTaskRequest
     * @return A Java Future containing the result of the GetVoiceToneAnalysisTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException</li>
     *         <li>ForbiddenException</li>
     *         <li>NotFoundException</li>
     *         <li>ConflictException</li>
     *         <li>ThrottledClientException</li>
     *         <li>AccessDeniedException</li>
     *         <li>UnauthorizedClientException</li>
     *         <li>ServiceFailureException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceToneAnalysisTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceToneAnalysisTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetVoiceToneAnalysisTaskResponse> getVoiceToneAnalysisTask(
            GetVoiceToneAnalysisTaskRequest getVoiceToneAnalysisTaskRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVoiceToneAnalysisTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVoiceToneAnalysisTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetVoiceToneAnalysisTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetVoiceToneAnalysisTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetVoiceToneAnalysisTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetVoiceToneAnalysisTaskRequest, GetVoiceToneAnalysisTaskResponse>()
                            .withOperationName("GetVoiceToneAnalysisTask")
                            .withMarshaller(new GetVoiceToneAnalysisTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getVoiceToneAnalysisTaskRequest));
            CompletableFuture<GetVoiceToneAnalysisTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the ListAvailableVoiceConnectorRegions operation asynchronously.
     *
     * @param listAvailableVoiceConnectorRegionsRequest
     * @return A Java Future containing the result of the ListAvailableVoiceConnectorRegions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListAvailableVoiceConnectorRegions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListAvailableVoiceConnectorRegions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAvailableVoiceConnectorRegionsResponse> listAvailableVoiceConnectorRegions(
            ListAvailableVoiceConnectorRegionsRequest listAvailableVoiceConnectorRegionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAvailableVoiceConnectorRegionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAvailableVoiceConnectorRegions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAvailableVoiceConnectorRegionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListAvailableVoiceConnectorRegionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAvailableVoiceConnectorRegionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAvailableVoiceConnectorRegionsRequest, ListAvailableVoiceConnectorRegionsResponse>()
                            .withOperationName("ListAvailableVoiceConnectorRegions")
                            .withMarshaller(new ListAvailableVoiceConnectorRegionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listAvailableVoiceConnectorRegionsRequest));
            CompletableFuture<ListAvailableVoiceConnectorRegionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the ListPhoneNumberOrders operation asynchronously.
     *
     * @param listPhoneNumberOrdersRequest
     * @return A Java Future containing the result of the ListPhoneNumberOrders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListPhoneNumberOrders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListPhoneNumberOrders"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListPhoneNumberOrdersResponse> listPhoneNumberOrders(
            ListPhoneNumberOrdersRequest listPhoneNumberOrdersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPhoneNumberOrdersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPhoneNumberOrders");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPhoneNumberOrdersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListPhoneNumberOrdersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListPhoneNumberOrdersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPhoneNumberOrdersRequest, ListPhoneNumberOrdersResponse>()
                            .withOperationName("ListPhoneNumberOrders")
                            .withMarshaller(new ListPhoneNumberOrdersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listPhoneNumberOrdersRequest));
            CompletableFuture<ListPhoneNumberOrdersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the ListPhoneNumberOrders operation asynchronously.<br/>
     * <p>
     * This is a variant of
     * {@link #listPhoneNumberOrders(software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumberOrdersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListPhoneNumberOrdersPublisher publisher = client.listPhoneNumberOrdersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListPhoneNumberOrdersPublisher publisher = client.listPhoneNumberOrdersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumberOrdersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumberOrdersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPhoneNumberOrders(software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumberOrdersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPhoneNumberOrdersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListPhoneNumberOrders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListPhoneNumberOrders"
     *      target="_top">AWS API Documentation</a>
     */
    public ListPhoneNumberOrdersPublisher listPhoneNumberOrdersPaginator(ListPhoneNumberOrdersRequest listPhoneNumberOrdersRequest) {
        return new ListPhoneNumberOrdersPublisher(this, applyPaginatorUserAgent(listPhoneNumberOrdersRequest));
    }

    /**
     * Invokes the ListPhoneNumbers operation asynchronously.
     *
     * @param listPhoneNumbersRequest
     * @return A Java Future containing the result of the ListPhoneNumbers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>NotFoundException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListPhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListPhoneNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListPhoneNumbersResponse> listPhoneNumbers(ListPhoneNumbersRequest listPhoneNumbersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPhoneNumbersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPhoneNumbers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPhoneNumbersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListPhoneNumbersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListPhoneNumbersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPhoneNumbersRequest, ListPhoneNumbersResponse>()
                            .withOperationName("ListPhoneNumbers")
                            .withMarshaller(new ListPhoneNumbersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listPhoneNumbersRequest));
            CompletableFuture<ListPhoneNumbersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the ListPhoneNumbers operation asynchronously.<br/>
     * <p>
     * This is a variant of
     * {@link #listPhoneNumbers(software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumbersRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListPhoneNumbersPublisher publisher = client.listPhoneNumbersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListPhoneNumbersPublisher publisher = client.listPhoneNumbersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumbersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumbersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPhoneNumbers(software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumbersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPhoneNumbersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>NotFoundException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListPhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListPhoneNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    public ListPhoneNumbersPublisher listPhoneNumbersPaginator(ListPhoneNumbersRequest listPhoneNumbersRequest) {
        return new ListPhoneNumbersPublisher(this, applyPaginatorUserAgent(listPhoneNumbersRequest));
    }

    /**
     * Invokes the ListProxySessions operation asynchronously.
     *
     * @param listProxySessionsRequest
     * @return A Java Future containing the result of the ListProxySessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListProxySessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListProxySessions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListProxySessionsResponse> listProxySessions(ListProxySessionsRequest listProxySessionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listProxySessionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListProxySessions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListProxySessionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListProxySessionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListProxySessionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListProxySessionsRequest, ListProxySessionsResponse>()
                            .withOperationName("ListProxySessions")
                            .withMarshaller(new ListProxySessionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listProxySessionsRequest));
            CompletableFuture<ListProxySessionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the ListProxySessions operation asynchronously.<br/>
     * <p>
     * This is a variant of
     * {@link #listProxySessions(software.amazon.awssdk.services.chimesdkvoice.model.ListProxySessionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListProxySessionsPublisher publisher = client.listProxySessionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListProxySessionsPublisher publisher = client.listProxySessionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chimesdkvoice.model.ListProxySessionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chimesdkvoice.model.ListProxySessionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProxySessions(software.amazon.awssdk.services.chimesdkvoice.model.ListProxySessionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProxySessionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListProxySessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListProxySessions"
     *      target="_top">AWS API Documentation</a>
     */
    public ListProxySessionsPublisher listProxySessionsPaginator(ListProxySessionsRequest listProxySessionsRequest) {
        return new ListProxySessionsPublisher(this, applyPaginatorUserAgent(listProxySessionsRequest));
    }

    /**
     * Invokes the ListSipMediaApplications operation asynchronously.
     *
     * @param listSipMediaApplicationsRequest
     * @return A Java Future containing the result of the ListSipMediaApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListSipMediaApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListSipMediaApplications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSipMediaApplicationsResponse> listSipMediaApplications(
            ListSipMediaApplicationsRequest listSipMediaApplicationsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSipMediaApplicationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSipMediaApplications");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSipMediaApplicationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSipMediaApplicationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListSipMediaApplicationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSipMediaApplicationsRequest, ListSipMediaApplicationsResponse>()
                            .withOperationName("ListSipMediaApplications")
                            .withMarshaller(new ListSipMediaApplicationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listSipMediaApplicationsRequest));
            CompletableFuture<ListSipMediaApplicationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the ListSipMediaApplications operation asynchronously.<br/>
     * <p>
     * This is a variant of
     * {@link #listSipMediaApplications(software.amazon.awssdk.services.chimesdkvoice.model.ListSipMediaApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListSipMediaApplicationsPublisher publisher = client.listSipMediaApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListSipMediaApplicationsPublisher publisher = client.listSipMediaApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chimesdkvoice.model.ListSipMediaApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chimesdkvoice.model.ListSipMediaApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSipMediaApplications(software.amazon.awssdk.services.chimesdkvoice.model.ListSipMediaApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSipMediaApplicationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListSipMediaApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListSipMediaApplications"
     *      target="_top">AWS API Documentation</a>
     */
    public ListSipMediaApplicationsPublisher listSipMediaApplicationsPaginator(
            ListSipMediaApplicationsRequest listSipMediaApplicationsRequest) {
        return new ListSipMediaApplicationsPublisher(this, applyPaginatorUserAgent(listSipMediaApplicationsRequest));
    }

    /**
     * Invokes the ListSipRules operation asynchronously.
     *
     * @param listSipRulesRequest
     * @return A Java Future containing the result of the ListSipRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListSipRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListSipRules" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSipRulesResponse> listSipRules(ListSipRulesRequest listSipRulesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSipRulesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSipRules");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSipRulesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListSipRulesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListSipRulesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSipRulesRequest, ListSipRulesResponse>()
                            .withOperationName("ListSipRules").withMarshaller(new ListSipRulesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listSipRulesRequest));
            CompletableFuture<ListSipRulesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the ListSipRules operation asynchronously.<br/>
     * <p>
     * This is a variant of
     * {@link #listSipRules(software.amazon.awssdk.services.chimesdkvoice.model.ListSipRulesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListSipRulesPublisher publisher = client.listSipRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListSipRulesPublisher publisher = client.listSipRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chimesdkvoice.model.ListSipRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chimesdkvoice.model.ListSipRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSipRules(software.amazon.awssdk.services.chimesdkvoice.model.ListSipRulesRequest)} operation.</b>
     * </p>
     *
     * @param listSipRulesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListSipRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListSipRules" target="_top">AWS
     *      API Documentation</a>
     */
    public ListSipRulesPublisher listSipRulesPaginator(ListSipRulesRequest listSipRulesRequest) {
        return new ListSipRulesPublisher(this, applyPaginatorUserAgent(listSipRulesRequest));
    }

    /**
     * Invokes the ListSupportedPhoneNumberCountries operation asynchronously.
     *
     * @param listSupportedPhoneNumberCountriesRequest
     * @return A Java Future containing the result of the ListSupportedPhoneNumberCountries operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException</li>
     *         <li>ForbiddenException</li>
     *         <li>AccessDeniedException</li>
     *         <li>UnauthorizedClientException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListSupportedPhoneNumberCountries
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListSupportedPhoneNumberCountries"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSupportedPhoneNumberCountriesResponse> listSupportedPhoneNumberCountries(
            ListSupportedPhoneNumberCountriesRequest listSupportedPhoneNumberCountriesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listSupportedPhoneNumberCountriesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSupportedPhoneNumberCountries");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSupportedPhoneNumberCountriesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListSupportedPhoneNumberCountriesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListSupportedPhoneNumberCountriesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSupportedPhoneNumberCountriesRequest, ListSupportedPhoneNumberCountriesResponse>()
                            .withOperationName("ListSupportedPhoneNumberCountries")
                            .withMarshaller(new ListSupportedPhoneNumberCountriesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listSupportedPhoneNumberCountriesRequest));
            CompletableFuture<ListSupportedPhoneNumberCountriesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the ListTagsForResource operation asynchronously.
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException</li>
     *         <li>ForbiddenException</li>
     *         <li>NotFoundException</li>
     *         <li>UnauthorizedClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource")
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the ListVoiceConnectorGroups operation asynchronously.
     *
     * @param listVoiceConnectorGroupsRequest
     * @return A Java Future containing the result of the ListVoiceConnectorGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListVoiceConnectorGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListVoiceConnectorGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListVoiceConnectorGroupsResponse> listVoiceConnectorGroups(
            ListVoiceConnectorGroupsRequest listVoiceConnectorGroupsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listVoiceConnectorGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVoiceConnectorGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListVoiceConnectorGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListVoiceConnectorGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListVoiceConnectorGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListVoiceConnectorGroupsRequest, ListVoiceConnectorGroupsResponse>()
                            .withOperationName("ListVoiceConnectorGroups")
                            .withMarshaller(new ListVoiceConnectorGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listVoiceConnectorGroupsRequest));
            CompletableFuture<ListVoiceConnectorGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the ListVoiceConnectorGroups operation asynchronously.<br/>
     * <p>
     * This is a variant of
     * {@link #listVoiceConnectorGroups(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListVoiceConnectorGroupsPublisher publisher = client.listVoiceConnectorGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListVoiceConnectorGroupsPublisher publisher = client.listVoiceConnectorGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVoiceConnectorGroups(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVoiceConnectorGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListVoiceConnectorGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListVoiceConnectorGroups"
     *      target="_top">AWS API Documentation</a>
     */
    public ListVoiceConnectorGroupsPublisher listVoiceConnectorGroupsPaginator(
            ListVoiceConnectorGroupsRequest listVoiceConnectorGroupsRequest) {
        return new ListVoiceConnectorGroupsPublisher(this, applyPaginatorUserAgent(listVoiceConnectorGroupsRequest));
    }

    /**
     * Invokes the ListVoiceConnectorTerminationCredentials operation asynchronously.
     *
     * @param listVoiceConnectorTerminationCredentialsRequest
     * @return A Java Future containing the result of the ListVoiceConnectorTerminationCredentials operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListVoiceConnectorTerminationCredentials
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListVoiceConnectorTerminationCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListVoiceConnectorTerminationCredentialsResponse> listVoiceConnectorTerminationCredentials(
            ListVoiceConnectorTerminationCredentialsRequest listVoiceConnectorTerminationCredentialsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listVoiceConnectorTerminationCredentialsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVoiceConnectorTerminationCredentials");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListVoiceConnectorTerminationCredentialsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListVoiceConnectorTerminationCredentialsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListVoiceConnectorTerminationCredentialsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListVoiceConnectorTerminationCredentialsRequest, ListVoiceConnectorTerminationCredentialsResponse>()
                            .withOperationName("ListVoiceConnectorTerminationCredentials")
                            .withMarshaller(new ListVoiceConnectorTerminationCredentialsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(listVoiceConnectorTerminationCredentialsRequest));
            CompletableFuture<ListVoiceConnectorTerminationCredentialsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the ListVoiceConnectors operation asynchronously.
     *
     * @param listVoiceConnectorsRequest
     * @return A Java Future containing the result of the ListVoiceConnectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListVoiceConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListVoiceConnectors"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListVoiceConnectorsResponse> listVoiceConnectors(
            ListVoiceConnectorsRequest listVoiceConnectorsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listVoiceConnectorsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVoiceConnectors");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListVoiceConnectorsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListVoiceConnectorsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListVoiceConnectorsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListVoiceConnectorsRequest, ListVoiceConnectorsResponse>()
                            .withOperationName("ListVoiceConnectors")
                            .withMarshaller(new ListVoiceConnectorsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listVoiceConnectorsRequest));
            CompletableFuture<ListVoiceConnectorsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the ListVoiceConnectors operation asynchronously.<br/>
     * <p>
     * This is a variant of
     * {@link #listVoiceConnectors(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListVoiceConnectorsPublisher publisher = client.listVoiceConnectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListVoiceConnectorsPublisher publisher = client.listVoiceConnectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVoiceConnectors(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVoiceConnectorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListVoiceConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListVoiceConnectors"
     *      target="_top">AWS API Documentation</a>
     */
    public ListVoiceConnectorsPublisher listVoiceConnectorsPaginator(ListVoiceConnectorsRequest listVoiceConnectorsRequest) {
        return new ListVoiceConnectorsPublisher(this, applyPaginatorUserAgent(listVoiceConnectorsRequest));
    }

    /**
     * Invokes the ListVoiceProfileDomains operation asynchronously.
     *
     * @param listVoiceProfileDomainsRequest
     * @return A Java Future containing the result of the ListVoiceProfileDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException</li>
     *         <li>UnauthorizedClientException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListVoiceProfileDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListVoiceProfileDomains"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListVoiceProfileDomainsResponse> listVoiceProfileDomains(
            ListVoiceProfileDomainsRequest listVoiceProfileDomainsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listVoiceProfileDomainsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVoiceProfileDomains");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListVoiceProfileDomainsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListVoiceProfileDomainsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListVoiceProfileDomainsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListVoiceProfileDomainsRequest, ListVoiceProfileDomainsResponse>()
                            .withOperationName("ListVoiceProfileDomains")
                            .withMarshaller(new ListVoiceProfileDomainsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listVoiceProfileDomainsRequest));
            CompletableFuture<ListVoiceProfileDomainsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the ListVoiceProfileDomains operation asynchronously.<br/>
     * <p>
     * This is a variant of
     * {@link #listVoiceProfileDomains(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfileDomainsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListVoiceProfileDomainsPublisher publisher = client.listVoiceProfileDomainsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListVoiceProfileDomainsPublisher publisher = client.listVoiceProfileDomainsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfileDomainsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfileDomainsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVoiceProfileDomains(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfileDomainsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVoiceProfileDomainsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException</li>
     *         <li>UnauthorizedClientException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListVoiceProfileDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListVoiceProfileDomains"
     *      target="_top">AWS API Documentation</a>
     */
    public ListVoiceProfileDomainsPublisher listVoiceProfileDomainsPaginator(
            ListVoiceProfileDomainsRequest listVoiceProfileDomainsRequest) {
        return new ListVoiceProfileDomainsPublisher(this, applyPaginatorUserAgent(listVoiceProfileDomainsRequest));
    }

    /**
     * Invokes the ListVoiceProfiles operation asynchronously.
     *
     * @param listVoiceProfilesRequest
     * @return A Java Future containing the result of the ListVoiceProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException</li>
     *         <li>UnauthorizedClientException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListVoiceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListVoiceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListVoiceProfilesResponse> listVoiceProfiles(ListVoiceProfilesRequest listVoiceProfilesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listVoiceProfilesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVoiceProfiles");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListVoiceProfilesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListVoiceProfilesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListVoiceProfilesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListVoiceProfilesRequest, ListVoiceProfilesResponse>()
                            .withOperationName("ListVoiceProfiles")
                            .withMarshaller(new ListVoiceProfilesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listVoiceProfilesRequest));
            CompletableFuture<ListVoiceProfilesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the ListVoiceProfiles operation asynchronously.<br/>
     * <p>
     * This is a variant of
     * {@link #listVoiceProfiles(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListVoiceProfilesPublisher publisher = client.listVoiceProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListVoiceProfilesPublisher publisher = client.listVoiceProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVoiceProfiles(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVoiceProfilesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException</li>
     *         <li>UnauthorizedClientException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListVoiceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListVoiceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    public ListVoiceProfilesPublisher listVoiceProfilesPaginator(ListVoiceProfilesRequest listVoiceProfilesRequest) {
        return new ListVoiceProfilesPublisher(this, applyPaginatorUserAgent(listVoiceProfilesRequest));
    }

    /**
     * Invokes the PutSipMediaApplicationAlexaSkillConfiguration operation asynchronously.
     *
     * @param putSipMediaApplicationAlexaSkillConfigurationRequest
     * @return A Java Future containing the result of the PutSipMediaApplicationAlexaSkillConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.PutSipMediaApplicationAlexaSkillConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutSipMediaApplicationAlexaSkillConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutSipMediaApplicationAlexaSkillConfigurationResponse> putSipMediaApplicationAlexaSkillConfiguration(
            PutSipMediaApplicationAlexaSkillConfigurationRequest putSipMediaApplicationAlexaSkillConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putSipMediaApplicationAlexaSkillConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutSipMediaApplicationAlexaSkillConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutSipMediaApplicationAlexaSkillConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, PutSipMediaApplicationAlexaSkillConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutSipMediaApplicationAlexaSkillConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutSipMediaApplicationAlexaSkillConfigurationRequest, PutSipMediaApplicationAlexaSkillConfigurationResponse>()
                            .withOperationName("PutSipMediaApplicationAlexaSkillConfiguration")
                            .withMarshaller(new PutSipMediaApplicationAlexaSkillConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(putSipMediaApplicationAlexaSkillConfigurationRequest));
            CompletableFuture<PutSipMediaApplicationAlexaSkillConfigurationResponse> whenCompleted = executeFuture.whenComplete((
                    r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the PutSipMediaApplicationLoggingConfiguration operation asynchronously.
     *
     * @param putSipMediaApplicationLoggingConfigurationRequest
     * @return A Java Future containing the result of the PutSipMediaApplicationLoggingConfiguration operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.PutSipMediaApplicationLoggingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutSipMediaApplicationLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutSipMediaApplicationLoggingConfigurationResponse> putSipMediaApplicationLoggingConfiguration(
            PutSipMediaApplicationLoggingConfigurationRequest putSipMediaApplicationLoggingConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putSipMediaApplicationLoggingConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutSipMediaApplicationLoggingConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutSipMediaApplicationLoggingConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, PutSipMediaApplicationLoggingConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutSipMediaApplicationLoggingConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutSipMediaApplicationLoggingConfigurationRequest, PutSipMediaApplicationLoggingConfigurationResponse>()
                            .withOperationName("PutSipMediaApplicationLoggingConfiguration")
                            .withMarshaller(new PutSipMediaApplicationLoggingConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(putSipMediaApplicationLoggingConfigurationRequest));
            CompletableFuture<PutSipMediaApplicationLoggingConfigurationResponse> whenCompleted = executeFuture.whenComplete((r,
                    e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the PutVoiceConnectorEmergencyCallingConfiguration operation asynchronously.
     *
     * @param putVoiceConnectorEmergencyCallingConfigurationRequest
     * @return A Java Future containing the result of the PutVoiceConnectorEmergencyCallingConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.PutVoiceConnectorEmergencyCallingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorEmergencyCallingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutVoiceConnectorEmergencyCallingConfigurationResponse> putVoiceConnectorEmergencyCallingConfiguration(
            PutVoiceConnectorEmergencyCallingConfigurationRequest putVoiceConnectorEmergencyCallingConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putVoiceConnectorEmergencyCallingConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutVoiceConnectorEmergencyCallingConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutVoiceConnectorEmergencyCallingConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, PutVoiceConnectorEmergencyCallingConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutVoiceConnectorEmergencyCallingConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutVoiceConnectorEmergencyCallingConfigurationRequest, PutVoiceConnectorEmergencyCallingConfigurationResponse>()
                            .withOperationName("PutVoiceConnectorEmergencyCallingConfiguration")
                            .withMarshaller(new PutVoiceConnectorEmergencyCallingConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(putVoiceConnectorEmergencyCallingConfigurationRequest));
            CompletableFuture<PutVoiceConnectorEmergencyCallingConfigurationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the PutVoiceConnectorLoggingConfiguration operation asynchronously.
     *
     * @param putVoiceConnectorLoggingConfigurationRequest
     * @return A Java Future containing the result of the PutVoiceConnectorLoggingConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.PutVoiceConnectorLoggingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutVoiceConnectorLoggingConfigurationResponse> putVoiceConnectorLoggingConfiguration(
            PutVoiceConnectorLoggingConfigurationRequest putVoiceConnectorLoggingConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putVoiceConnectorLoggingConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutVoiceConnectorLoggingConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutVoiceConnectorLoggingConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, PutVoiceConnectorLoggingConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutVoiceConnectorLoggingConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutVoiceConnectorLoggingConfigurationRequest, PutVoiceConnectorLoggingConfigurationResponse>()
                            .withOperationName("PutVoiceConnectorLoggingConfiguration")
                            .withMarshaller(new PutVoiceConnectorLoggingConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putVoiceConnectorLoggingConfigurationRequest));
            CompletableFuture<PutVoiceConnectorLoggingConfigurationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the PutVoiceConnectorOrigination operation asynchronously.
     *
     * @param putVoiceConnectorOriginationRequest
     * @return A Java Future containing the result of the PutVoiceConnectorOrigination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.PutVoiceConnectorOrigination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorOrigination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutVoiceConnectorOriginationResponse> putVoiceConnectorOrigination(
            PutVoiceConnectorOriginationRequest putVoiceConnectorOriginationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putVoiceConnectorOriginationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutVoiceConnectorOrigination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutVoiceConnectorOriginationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutVoiceConnectorOriginationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutVoiceConnectorOriginationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutVoiceConnectorOriginationRequest, PutVoiceConnectorOriginationResponse>()
                            .withOperationName("PutVoiceConnectorOrigination")
                            .withMarshaller(new PutVoiceConnectorOriginationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putVoiceConnectorOriginationRequest));
            CompletableFuture<PutVoiceConnectorOriginationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the PutVoiceConnectorProxy operation asynchronously.
     *
     * @param putVoiceConnectorProxyRequest
     * @return A Java Future containing the result of the PutVoiceConnectorProxy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>AccessDeniedException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.PutVoiceConnectorProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorProxy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutVoiceConnectorProxyResponse> putVoiceConnectorProxy(
            PutVoiceConnectorProxyRequest putVoiceConnectorProxyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putVoiceConnectorProxyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutVoiceConnectorProxy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutVoiceConnectorProxyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutVoiceConnectorProxyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutVoiceConnectorProxyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutVoiceConnectorProxyRequest, PutVoiceConnectorProxyResponse>()
                            .withOperationName("PutVoiceConnectorProxy")
                            .withMarshaller(new PutVoiceConnectorProxyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putVoiceConnectorProxyRequest));
            CompletableFuture<PutVoiceConnectorProxyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the PutVoiceConnectorStreamingConfiguration operation asynchronously.
     *
     * @param putVoiceConnectorStreamingConfigurationRequest
     * @return A Java Future containing the result of the PutVoiceConnectorStreamingConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.PutVoiceConnectorStreamingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorStreamingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutVoiceConnectorStreamingConfigurationResponse> putVoiceConnectorStreamingConfiguration(
            PutVoiceConnectorStreamingConfigurationRequest putVoiceConnectorStreamingConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putVoiceConnectorStreamingConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutVoiceConnectorStreamingConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutVoiceConnectorStreamingConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, PutVoiceConnectorStreamingConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutVoiceConnectorStreamingConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutVoiceConnectorStreamingConfigurationRequest, PutVoiceConnectorStreamingConfigurationResponse>()
                            .withOperationName("PutVoiceConnectorStreamingConfiguration")
                            .withMarshaller(new PutVoiceConnectorStreamingConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(putVoiceConnectorStreamingConfigurationRequest));
            CompletableFuture<PutVoiceConnectorStreamingConfigurationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the PutVoiceConnectorTermination operation asynchronously.
     *
     * @param putVoiceConnectorTerminationRequest
     * @return A Java Future containing the result of the PutVoiceConnectorTermination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.PutVoiceConnectorTermination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorTermination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutVoiceConnectorTerminationResponse> putVoiceConnectorTermination(
            PutVoiceConnectorTerminationRequest putVoiceConnectorTerminationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putVoiceConnectorTerminationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutVoiceConnectorTermination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutVoiceConnectorTerminationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutVoiceConnectorTerminationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutVoiceConnectorTerminationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutVoiceConnectorTerminationRequest, PutVoiceConnectorTerminationResponse>()
                            .withOperationName("PutVoiceConnectorTermination")
                            .withMarshaller(new PutVoiceConnectorTerminationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putVoiceConnectorTerminationRequest));
            CompletableFuture<PutVoiceConnectorTerminationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the PutVoiceConnectorTerminationCredentials operation asynchronously.
     *
     * @param putVoiceConnectorTerminationCredentialsRequest
     * @return A Java Future containing the result of the PutVoiceConnectorTerminationCredentials operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.PutVoiceConnectorTerminationCredentials
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorTerminationCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutVoiceConnectorTerminationCredentialsResponse> putVoiceConnectorTerminationCredentials(
            PutVoiceConnectorTerminationCredentialsRequest putVoiceConnectorTerminationCredentialsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putVoiceConnectorTerminationCredentialsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutVoiceConnectorTerminationCredentials");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutVoiceConnectorTerminationCredentialsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, PutVoiceConnectorTerminationCredentialsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutVoiceConnectorTerminationCredentialsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutVoiceConnectorTerminationCredentialsRequest, PutVoiceConnectorTerminationCredentialsResponse>()
                            .withOperationName("PutVoiceConnectorTerminationCredentials")
                            .withMarshaller(new PutVoiceConnectorTerminationCredentialsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(putVoiceConnectorTerminationCredentialsRequest));
            CompletableFuture<PutVoiceConnectorTerminationCredentialsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the RestorePhoneNumber operation asynchronously.
     *
     * @param restorePhoneNumberRequest
     * @return A Java Future containing the result of the RestorePhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ResourceLimitExceededException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.RestorePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/RestorePhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RestorePhoneNumberResponse> restorePhoneNumber(RestorePhoneNumberRequest restorePhoneNumberRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, restorePhoneNumberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestorePhoneNumber");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RestorePhoneNumberResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RestorePhoneNumberResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RestorePhoneNumberResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RestorePhoneNumberRequest, RestorePhoneNumberResponse>()
                            .withOperationName("RestorePhoneNumber")
                            .withMarshaller(new RestorePhoneNumberRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(restorePhoneNumberRequest));
            CompletableFuture<RestorePhoneNumberResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the SearchAvailablePhoneNumbers operation asynchronously.
     *
     * @param searchAvailablePhoneNumbersRequest
     * @return A Java Future containing the result of the SearchAvailablePhoneNumbers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException</li>
     *         <li>ForbiddenException</li>
     *         <li>AccessDeniedException</li>
     *         <li>UnauthorizedClientException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.SearchAvailablePhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/SearchAvailablePhoneNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SearchAvailablePhoneNumbersResponse> searchAvailablePhoneNumbers(
            SearchAvailablePhoneNumbersRequest searchAvailablePhoneNumbersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchAvailablePhoneNumbersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchAvailablePhoneNumbers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchAvailablePhoneNumbersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SearchAvailablePhoneNumbersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchAvailablePhoneNumbersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchAvailablePhoneNumbersRequest, SearchAvailablePhoneNumbersResponse>()
                            .withOperationName("SearchAvailablePhoneNumbers")
                            .withMarshaller(new SearchAvailablePhoneNumbersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(searchAvailablePhoneNumbersRequest));
            CompletableFuture<SearchAvailablePhoneNumbersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the SearchAvailablePhoneNumbers operation asynchronously.<br/>
     * <p>
     * This is a variant of
     * {@link #searchAvailablePhoneNumbers(software.amazon.awssdk.services.chimesdkvoice.model.SearchAvailablePhoneNumbersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.SearchAvailablePhoneNumbersPublisher publisher = client.searchAvailablePhoneNumbersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.SearchAvailablePhoneNumbersPublisher publisher = client.searchAvailablePhoneNumbersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chimesdkvoice.model.SearchAvailablePhoneNumbersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chimesdkvoice.model.SearchAvailablePhoneNumbersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchAvailablePhoneNumbers(software.amazon.awssdk.services.chimesdkvoice.model.SearchAvailablePhoneNumbersRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchAvailablePhoneNumbersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException</li>
     *         <li>ForbiddenException</li>
     *         <li>AccessDeniedException</li>
     *         <li>UnauthorizedClientException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.SearchAvailablePhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/SearchAvailablePhoneNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    public SearchAvailablePhoneNumbersPublisher searchAvailablePhoneNumbersPaginator(
            SearchAvailablePhoneNumbersRequest searchAvailablePhoneNumbersRequest) {
        return new SearchAvailablePhoneNumbersPublisher(this, applyPaginatorUserAgent(searchAvailablePhoneNumbersRequest));
    }

    /**
     * Invokes the StartSpeakerSearchTask operation asynchronously.
     *
     * @param startSpeakerSearchTaskRequest
     * @return A Java Future containing the result of the StartSpeakerSearchTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException</li>
     *         <li>ResourceLimitExceededException</li>
     *         <li>UnauthorizedClientException</li>
     *         <li>ForbiddenException</li>
     *         <li>AccessDeniedException</li>
     *         <li>NotFoundException</li>
     *         <li>ConflictException</li>
     *         <li>GoneException</li>
     *         <li>UnprocessableEntityException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.StartSpeakerSearchTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/StartSpeakerSearchTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartSpeakerSearchTaskResponse> startSpeakerSearchTask(
            StartSpeakerSearchTaskRequest startSpeakerSearchTaskRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startSpeakerSearchTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartSpeakerSearchTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartSpeakerSearchTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartSpeakerSearchTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartSpeakerSearchTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartSpeakerSearchTaskRequest, StartSpeakerSearchTaskResponse>()
                            .withOperationName("StartSpeakerSearchTask")
                            .withMarshaller(new StartSpeakerSearchTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startSpeakerSearchTaskRequest));
            CompletableFuture<StartSpeakerSearchTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the StartVoiceToneAnalysisTask operation asynchronously.
     *
     * @param startVoiceToneAnalysisTaskRequest
     * @return A Java Future containing the result of the StartVoiceToneAnalysisTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException</li>
     *         <li>ResourceLimitExceededException</li>
     *         <li>UnauthorizedClientException</li>
     *         <li>ForbiddenException</li>
     *         <li>AccessDeniedException</li>
     *         <li>NotFoundException</li>
     *         <li>ConflictException</li>
     *         <li>GoneException</li>
     *         <li>UnprocessableEntityException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.StartVoiceToneAnalysisTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/StartVoiceToneAnalysisTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartVoiceToneAnalysisTaskResponse> startVoiceToneAnalysisTask(
            StartVoiceToneAnalysisTaskRequest startVoiceToneAnalysisTaskRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startVoiceToneAnalysisTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartVoiceToneAnalysisTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartVoiceToneAnalysisTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartVoiceToneAnalysisTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartVoiceToneAnalysisTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartVoiceToneAnalysisTaskRequest, StartVoiceToneAnalysisTaskResponse>()
                            .withOperationName("StartVoiceToneAnalysisTask")
                            .withMarshaller(new StartVoiceToneAnalysisTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startVoiceToneAnalysisTaskRequest));
            CompletableFuture<StartVoiceToneAnalysisTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the StopSpeakerSearchTask operation asynchronously.
     *
     * @param stopSpeakerSearchTaskRequest
     * @return A Java Future containing the result of the StopSpeakerSearchTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException</li>
     *         <li>UnauthorizedClientException</li>
     *         <li>ForbiddenException</li>
     *         <li>AccessDeniedException</li>
     *         <li>NotFoundException</li>
     *         <li>ConflictException</li>
     *         <li>UnprocessableEntityException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.StopSpeakerSearchTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/StopSpeakerSearchTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopSpeakerSearchTaskResponse> stopSpeakerSearchTask(
            StopSpeakerSearchTaskRequest stopSpeakerSearchTaskRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopSpeakerSearchTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopSpeakerSearchTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopSpeakerSearchTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopSpeakerSearchTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopSpeakerSearchTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopSpeakerSearchTaskRequest, StopSpeakerSearchTaskResponse>()
                            .withOperationName("StopSpeakerSearchTask")
                            .withMarshaller(new StopSpeakerSearchTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(stopSpeakerSearchTaskRequest));
            CompletableFuture<StopSpeakerSearchTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the StopVoiceToneAnalysisTask operation asynchronously.
     *
     * @param stopVoiceToneAnalysisTaskRequest
     * @return A Java Future containing the result of the StopVoiceToneAnalysisTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException</li>
     *         <li>UnauthorizedClientException</li>
     *         <li>ForbiddenException</li>
     *         <li>AccessDeniedException</li>
     *         <li>NotFoundException</li>
     *         <li>ConflictException</li>
     *         <li>UnprocessableEntityException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.StopVoiceToneAnalysisTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/StopVoiceToneAnalysisTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopVoiceToneAnalysisTaskResponse> stopVoiceToneAnalysisTask(
            StopVoiceToneAnalysisTaskRequest stopVoiceToneAnalysisTaskRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopVoiceToneAnalysisTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopVoiceToneAnalysisTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopVoiceToneAnalysisTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopVoiceToneAnalysisTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopVoiceToneAnalysisTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopVoiceToneAnalysisTaskRequest, StopVoiceToneAnalysisTaskResponse>()
                            .withOperationName("StopVoiceToneAnalysisTask")
                            .withMarshaller(new StopVoiceToneAnalysisTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(stopVoiceToneAnalysisTaskRequest));
            CompletableFuture<StopVoiceToneAnalysisTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the TagResource operation asynchronously.
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException</li>
     *         <li>ForbiddenException</li>
     *         <li>NotFoundException</li>
     *         <li>ResourceLimitExceededException</li>
     *         <li>UnauthorizedClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the UntagResource operation asynchronously.
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException</li>
     *         <li>ForbiddenException</li>
     *         <li>NotFoundException</li>
     *         <li>UnauthorizedClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource")
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the UpdateGlobalSettings operation asynchronously.
     *
     * @param updateGlobalSettingsRequest
     * @return A Java Future containing the result of the UpdateGlobalSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UpdateGlobalSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateGlobalSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateGlobalSettingsResponse> updateGlobalSettings(
            UpdateGlobalSettingsRequest updateGlobalSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateGlobalSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateGlobalSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateGlobalSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateGlobalSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateGlobalSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateGlobalSettingsRequest, UpdateGlobalSettingsResponse>()
                            .withOperationName("UpdateGlobalSettings")
                            .withMarshaller(new UpdateGlobalSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateGlobalSettingsRequest));
            CompletableFuture<UpdateGlobalSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the UpdatePhoneNumber operation asynchronously.
     *
     * @param updatePhoneNumberRequest
     * @return A Java Future containing the result of the UpdatePhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ConflictException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UpdatePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdatePhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdatePhoneNumberResponse> updatePhoneNumber(UpdatePhoneNumberRequest updatePhoneNumberRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePhoneNumberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePhoneNumber");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdatePhoneNumberResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdatePhoneNumberResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdatePhoneNumberResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdatePhoneNumberRequest, UpdatePhoneNumberResponse>()
                            .withOperationName("UpdatePhoneNumber")
                            .withMarshaller(new UpdatePhoneNumberRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updatePhoneNumberRequest));
            CompletableFuture<UpdatePhoneNumberResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the UpdatePhoneNumberSettings operation asynchronously.
     *
     * @param updatePhoneNumberSettingsRequest
     * @return A Java Future containing the result of the UpdatePhoneNumberSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UpdatePhoneNumberSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdatePhoneNumberSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdatePhoneNumberSettingsResponse> updatePhoneNumberSettings(
            UpdatePhoneNumberSettingsRequest updatePhoneNumberSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePhoneNumberSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePhoneNumberSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdatePhoneNumberSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdatePhoneNumberSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdatePhoneNumberSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdatePhoneNumberSettingsRequest, UpdatePhoneNumberSettingsResponse>()
                            .withOperationName("UpdatePhoneNumberSettings")
                            .withMarshaller(new UpdatePhoneNumberSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updatePhoneNumberSettingsRequest));
            CompletableFuture<UpdatePhoneNumberSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the UpdateProxySession operation asynchronously.
     *
     * @param updateProxySessionRequest
     * @return A Java Future containing the result of the UpdateProxySession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UpdateProxySession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateProxySession"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateProxySessionResponse> updateProxySession(UpdateProxySessionRequest updateProxySessionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateProxySessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateProxySession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateProxySessionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateProxySessionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateProxySessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateProxySessionRequest, UpdateProxySessionResponse>()
                            .withOperationName("UpdateProxySession")
                            .withMarshaller(new UpdateProxySessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateProxySessionRequest));
            CompletableFuture<UpdateProxySessionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the UpdateSipMediaApplication operation asynchronously.
     *
     * @param updateSipMediaApplicationRequest
     * @return A Java Future containing the result of the UpdateSipMediaApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ConflictException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UpdateSipMediaApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateSipMediaApplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSipMediaApplicationResponse> updateSipMediaApplication(
            UpdateSipMediaApplicationRequest updateSipMediaApplicationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSipMediaApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSipMediaApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSipMediaApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateSipMediaApplicationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateSipMediaApplicationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSipMediaApplicationRequest, UpdateSipMediaApplicationResponse>()
                            .withOperationName("UpdateSipMediaApplication")
                            .withMarshaller(new UpdateSipMediaApplicationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateSipMediaApplicationRequest));
            CompletableFuture<UpdateSipMediaApplicationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the UpdateSipMediaApplicationCall operation asynchronously.
     *
     * @param updateSipMediaApplicationCallRequest
     * @return A Java Future containing the result of the UpdateSipMediaApplicationCall operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>ResourceLimitExceededException</li>
     *         <li>ThrottledClientException</li>
     *         <li>UnauthorizedClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UpdateSipMediaApplicationCall
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateSipMediaApplicationCall"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSipMediaApplicationCallResponse> updateSipMediaApplicationCall(
            UpdateSipMediaApplicationCallRequest updateSipMediaApplicationCallRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateSipMediaApplicationCallRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSipMediaApplicationCall");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSipMediaApplicationCallResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateSipMediaApplicationCallResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateSipMediaApplicationCallResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSipMediaApplicationCallRequest, UpdateSipMediaApplicationCallResponse>()
                            .withOperationName("UpdateSipMediaApplicationCall")
                            .withMarshaller(new UpdateSipMediaApplicationCallRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateSipMediaApplicationCallRequest));
            CompletableFuture<UpdateSipMediaApplicationCallResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the UpdateSipRule operation asynchronously.
     *
     * @param updateSipRuleRequest
     * @return A Java Future containing the result of the UpdateSipRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ConflictException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ResourceLimitExceededException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UpdateSipRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateSipRule" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSipRuleResponse> updateSipRule(UpdateSipRuleRequest updateSipRuleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSipRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSipRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSipRuleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateSipRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateSipRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSipRuleRequest, UpdateSipRuleResponse>()
                            .withOperationName("UpdateSipRule")
                            .withMarshaller(new UpdateSipRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateSipRuleRequest));
            CompletableFuture<UpdateSipRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the UpdateVoiceConnector operation asynchronously.
     *
     * @param updateVoiceConnectorRequest
     * @return A Java Future containing the result of the UpdateVoiceConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UpdateVoiceConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateVoiceConnector"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateVoiceConnectorResponse> updateVoiceConnector(
            UpdateVoiceConnectorRequest updateVoiceConnectorRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateVoiceConnectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateVoiceConnector");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateVoiceConnectorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateVoiceConnectorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateVoiceConnectorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateVoiceConnectorRequest, UpdateVoiceConnectorResponse>()
                            .withOperationName("UpdateVoiceConnector")
                            .withMarshaller(new UpdateVoiceConnectorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateVoiceConnectorRequest));
            CompletableFuture<UpdateVoiceConnectorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the UpdateVoiceConnectorGroup operation asynchronously.
     *
     * @param updateVoiceConnectorGroupRequest
     * @return A Java Future containing the result of the UpdateVoiceConnectorGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ConflictException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UpdateVoiceConnectorGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateVoiceConnectorGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateVoiceConnectorGroupResponse> updateVoiceConnectorGroup(
            UpdateVoiceConnectorGroupRequest updateVoiceConnectorGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateVoiceConnectorGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateVoiceConnectorGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateVoiceConnectorGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateVoiceConnectorGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateVoiceConnectorGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateVoiceConnectorGroupRequest, UpdateVoiceConnectorGroupResponse>()
                            .withOperationName("UpdateVoiceConnectorGroup")
                            .withMarshaller(new UpdateVoiceConnectorGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateVoiceConnectorGroupRequest));
            CompletableFuture<UpdateVoiceConnectorGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the UpdateVoiceProfile operation asynchronously.
     *
     * @param updateVoiceProfileRequest
     * @return A Java Future containing the result of the UpdateVoiceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException</li>
     *         <li>UnauthorizedClientException</li>
     *         <li>ForbiddenException</li>
     *         <li>AccessDeniedException</li>
     *         <li>NotFoundException</li>
     *         <li>ConflictException</li>
     *         <li>GoneException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UpdateVoiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateVoiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateVoiceProfileResponse> updateVoiceProfile(UpdateVoiceProfileRequest updateVoiceProfileRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateVoiceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateVoiceProfile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateVoiceProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateVoiceProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateVoiceProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateVoiceProfileRequest, UpdateVoiceProfileResponse>()
                            .withOperationName("UpdateVoiceProfile")
                            .withMarshaller(new UpdateVoiceProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateVoiceProfileRequest));
            CompletableFuture<UpdateVoiceProfileResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the UpdateVoiceProfileDomain operation asynchronously.
     *
     * @param updateVoiceProfileDomainRequest
     * @return A Java Future containing the result of the UpdateVoiceProfileDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>AccessDeniedException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UpdateVoiceProfileDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateVoiceProfileDomain"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateVoiceProfileDomainResponse> updateVoiceProfileDomain(
            UpdateVoiceProfileDomainRequest updateVoiceProfileDomainRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateVoiceProfileDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateVoiceProfileDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateVoiceProfileDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateVoiceProfileDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateVoiceProfileDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateVoiceProfileDomainRequest, UpdateVoiceProfileDomainResponse>()
                            .withOperationName("UpdateVoiceProfileDomain")
                            .withMarshaller(new UpdateVoiceProfileDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateVoiceProfileDomainRequest));
            CompletableFuture<UpdateVoiceProfileDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the ValidateE911Address operation asynchronously.
     *
     * @param validateE911AddressRequest
     * @return A Java Future containing the result of the ValidateE911Address operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException</li>
     *         <li>NotFoundException</li>
     *         <li>ForbiddenException</li>
     *         <li>BadRequestException</li>
     *         <li>ThrottledClientException</li>
     *         <li>ServiceUnavailableException</li>
     *         <li>ServiceFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ValidateE911Address
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ValidateE911Address"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ValidateE911AddressResponse> validateE911Address(
            ValidateE911AddressRequest validateE911AddressRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, validateE911AddressRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Voice");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ValidateE911Address");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ValidateE911AddressResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ValidateE911AddressResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ValidateE911AddressResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ValidateE911AddressRequest, ValidateE911AddressResponse>()
                            .withOperationName("ValidateE911Address")
                            .withMarshaller(new ValidateE911AddressRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(validateE911AddressRequest));
            CompletableFuture<ValidateE911AddressResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final ChimeSdkVoiceServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(ChimeSdkVoiceException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ForbiddenException")
                                .exceptionBuilderSupplier(ForbiddenException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                                .exceptionBuilderSupplier(ResourceLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("GoneException").exceptionBuilderSupplier(GoneException::builder)
                                .httpStatusCode(410).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnauthorizedClientException")
                                .exceptionBuilderSupplier(UnauthorizedClientException::builder).httpStatusCode(401).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotFoundException")
                                .exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceFailureException")
                                .exceptionBuilderSupplier(ServiceFailureException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnprocessableEntityException")
                                .exceptionBuilderSupplier(UnprocessableEntityException::builder).httpStatusCode(422).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottledClientException")
                                .exceptionBuilderSupplier(ThrottledClientException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceUnavailableException")
                                .exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(503).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BadRequestException")
                                .exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(400).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends ChimeSdkVoiceRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
