/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociatePhoneNumbersWithVoiceConnectorGroupResponse extends ChimeSdkVoiceResponse
        implements
        ToCopyableBuilder<AssociatePhoneNumbersWithVoiceConnectorGroupResponse.Builder, AssociatePhoneNumbersWithVoiceConnectorGroupResponse> {
    private static final SdkField<List<PhoneNumberError>> PHONE_NUMBER_ERRORS_FIELD = SdkField
            .<List<PhoneNumberError>> builder(MarshallingType.LIST)
            .memberName("PhoneNumberErrors")
            .getter(getter(AssociatePhoneNumbersWithVoiceConnectorGroupResponse::phoneNumberErrors))
            .setter(setter(Builder::phoneNumberErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberErrors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PhoneNumberError> builder(MarshallingType.SDK_POJO)
                                            .constructor(PhoneNumberError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_ERRORS_FIELD));

    private final List<PhoneNumberError> phoneNumberErrors;

    private AssociatePhoneNumbersWithVoiceConnectorGroupResponse(BuilderImpl builder) {
        super(builder);
        this.phoneNumberErrors = builder.phoneNumberErrors;
    }

    /**
     * For responses, this returns true if the service returned a value for the PhoneNumberErrors property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPhoneNumberErrors() {
        return phoneNumberErrors != null && !(phoneNumberErrors instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the PhoneNumberErrors property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPhoneNumberErrors} method.
     * </p>
     * 
     * @return The value of the PhoneNumberErrors property for this object.
     */
    public final List<PhoneNumberError> phoneNumberErrors() {
        return phoneNumberErrors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPhoneNumberErrors() ? phoneNumberErrors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatePhoneNumbersWithVoiceConnectorGroupResponse)) {
            return false;
        }
        AssociatePhoneNumbersWithVoiceConnectorGroupResponse other = (AssociatePhoneNumbersWithVoiceConnectorGroupResponse) obj;
        return hasPhoneNumberErrors() == other.hasPhoneNumberErrors()
                && Objects.equals(phoneNumberErrors(), other.phoneNumberErrors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociatePhoneNumbersWithVoiceConnectorGroupResponse")
                .add("PhoneNumberErrors", hasPhoneNumberErrors() ? phoneNumberErrors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PhoneNumberErrors":
            return Optional.ofNullable(clazz.cast(phoneNumberErrors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociatePhoneNumbersWithVoiceConnectorGroupResponse, T> g) {
        return obj -> g.apply((AssociatePhoneNumbersWithVoiceConnectorGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkVoiceResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociatePhoneNumbersWithVoiceConnectorGroupResponse> {
        /**
         * Sets the value of the PhoneNumberErrors property for this object.
         *
         * @param phoneNumberErrors
         *        The new value for the PhoneNumberErrors property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberErrors(Collection<PhoneNumberError> phoneNumberErrors);

        /**
         * Sets the value of the PhoneNumberErrors property for this object.
         *
         * @param phoneNumberErrors
         *        The new value for the PhoneNumberErrors property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberErrors(PhoneNumberError... phoneNumberErrors);

        /**
         * Sets the value of the PhoneNumberErrors property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkvoice.model.PhoneNumberError.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.chimesdkvoice.model.PhoneNumberError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkvoice.model.PhoneNumberError.Builder#build()} is called
         * immediately and its result is passed to {@link #phoneNumberErrors(List<PhoneNumberError>)}.
         * 
         * @param phoneNumberErrors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkvoice.model.PhoneNumberError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phoneNumberErrors(java.util.Collection<PhoneNumberError>)
         */
        Builder phoneNumberErrors(Consumer<PhoneNumberError.Builder>... phoneNumberErrors);
    }

    static final class BuilderImpl extends ChimeSdkVoiceResponse.BuilderImpl implements Builder {
        private List<PhoneNumberError> phoneNumberErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatePhoneNumbersWithVoiceConnectorGroupResponse model) {
            super(model);
            phoneNumberErrors(model.phoneNumberErrors);
        }

        public final List<PhoneNumberError.Builder> getPhoneNumberErrors() {
            List<PhoneNumberError.Builder> result = PhoneNumberErrorListCopier.copyToBuilder(this.phoneNumberErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhoneNumberErrors(Collection<PhoneNumberError.BuilderImpl> phoneNumberErrors) {
            this.phoneNumberErrors = PhoneNumberErrorListCopier.copyFromBuilder(phoneNumberErrors);
        }

        @Override
        public final Builder phoneNumberErrors(Collection<PhoneNumberError> phoneNumberErrors) {
            this.phoneNumberErrors = PhoneNumberErrorListCopier.copy(phoneNumberErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberErrors(PhoneNumberError... phoneNumberErrors) {
            phoneNumberErrors(Arrays.asList(phoneNumberErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberErrors(Consumer<PhoneNumberError.Builder>... phoneNumberErrors) {
            phoneNumberErrors(Stream.of(phoneNumberErrors).map(c -> PhoneNumberError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AssociatePhoneNumbersWithVoiceConnectorGroupResponse build() {
            return new AssociatePhoneNumbersWithVoiceConnectorGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
