/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeoMatchParams implements SdkPojo, Serializable, ToCopyableBuilder<GeoMatchParams.Builder, GeoMatchParams> {
    private static final SdkField<String> COUNTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Country")
            .getter(getter(GeoMatchParams::country)).setter(setter(Builder::country))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()).build();

    private static final SdkField<String> AREA_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AreaCode").getter(getter(GeoMatchParams::areaCode)).setter(setter(Builder::areaCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AreaCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(COUNTRY_FIELD, AREA_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String country;

    private final String areaCode;

    private GeoMatchParams(BuilderImpl builder) {
        this.country = builder.country;
        this.areaCode = builder.areaCode;
    }

    /**
     * Returns the value of the Country property for this object.
     * 
     * @return The value of the Country property for this object.
     */
    public final String country() {
        return country;
    }

    /**
     * Returns the value of the AreaCode property for this object.
     * 
     * @return The value of the AreaCode property for this object.
     */
    public final String areaCode() {
        return areaCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(country());
        hashCode = 31 * hashCode + Objects.hashCode(areaCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoMatchParams)) {
            return false;
        }
        GeoMatchParams other = (GeoMatchParams) obj;
        return Objects.equals(country(), other.country()) && Objects.equals(areaCode(), other.areaCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeoMatchParams").add("Country", country()).add("AreaCode", areaCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Country":
            return Optional.ofNullable(clazz.cast(country()));
        case "AreaCode":
            return Optional.ofNullable(clazz.cast(areaCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GeoMatchParams, T> g) {
        return obj -> g.apply((GeoMatchParams) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeoMatchParams> {
        /**
         * Sets the value of the Country property for this object.
         *
         * @param country
         *        The new value for the Country property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(String country);

        /**
         * Sets the value of the AreaCode property for this object.
         *
         * @param areaCode
         *        The new value for the AreaCode property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder areaCode(String areaCode);
    }

    static final class BuilderImpl implements Builder {
        private String country;

        private String areaCode;

        private BuilderImpl() {
        }

        private BuilderImpl(GeoMatchParams model) {
            country(model.country);
            areaCode(model.areaCode);
        }

        public final String getCountry() {
            return country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final String getAreaCode() {
            return areaCode;
        }

        public final void setAreaCode(String areaCode) {
            this.areaCode = areaCode;
        }

        @Override
        public final Builder areaCode(String areaCode) {
            this.areaCode = areaCode;
            return this;
        }

        @Override
        public GeoMatchParams build() {
            return new GeoMatchParams(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
