/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetGlobalSettingsResponse extends ChimeSdkVoiceResponse implements
        ToCopyableBuilder<GetGlobalSettingsResponse.Builder, GetGlobalSettingsResponse> {
    private static final SdkField<VoiceConnectorSettings> VOICE_CONNECTOR_FIELD = SdkField
            .<VoiceConnectorSettings> builder(MarshallingType.SDK_POJO).memberName("VoiceConnector")
            .getter(getter(GetGlobalSettingsResponse::voiceConnector)).setter(setter(Builder::voiceConnector))
            .constructor(VoiceConnectorSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceConnector").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CONNECTOR_FIELD));

    private final VoiceConnectorSettings voiceConnector;

    private GetGlobalSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.voiceConnector = builder.voiceConnector;
    }

    /**
     * Returns the value of the VoiceConnector property for this object.
     * 
     * @return The value of the VoiceConnector property for this object.
     */
    public final VoiceConnectorSettings voiceConnector() {
        return voiceConnector;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(voiceConnector());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGlobalSettingsResponse)) {
            return false;
        }
        GetGlobalSettingsResponse other = (GetGlobalSettingsResponse) obj;
        return Objects.equals(voiceConnector(), other.voiceConnector());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetGlobalSettingsResponse").add("VoiceConnector", voiceConnector()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VoiceConnector":
            return Optional.ofNullable(clazz.cast(voiceConnector()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetGlobalSettingsResponse, T> g) {
        return obj -> g.apply((GetGlobalSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkVoiceResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetGlobalSettingsResponse> {
        /**
         * Sets the value of the VoiceConnector property for this object.
         *
         * @param voiceConnector
         *        The new value for the VoiceConnector property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceConnector(VoiceConnectorSettings voiceConnector);

        /**
         * Sets the value of the VoiceConnector property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VoiceConnectorSettings.Builder} avoiding
         * the need to create one manually via {@link VoiceConnectorSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VoiceConnectorSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #voiceConnector(VoiceConnectorSettings)}.
         * 
         * @param voiceConnector
         *        a consumer that will call methods on {@link VoiceConnectorSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #voiceConnector(VoiceConnectorSettings)
         */
        default Builder voiceConnector(Consumer<VoiceConnectorSettings.Builder> voiceConnector) {
            return voiceConnector(VoiceConnectorSettings.builder().applyMutation(voiceConnector).build());
        }
    }

    static final class BuilderImpl extends ChimeSdkVoiceResponse.BuilderImpl implements Builder {
        private VoiceConnectorSettings voiceConnector;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGlobalSettingsResponse model) {
            super(model);
            voiceConnector(model.voiceConnector);
        }

        public final VoiceConnectorSettings.Builder getVoiceConnector() {
            return voiceConnector != null ? voiceConnector.toBuilder() : null;
        }

        public final void setVoiceConnector(VoiceConnectorSettings.BuilderImpl voiceConnector) {
            this.voiceConnector = voiceConnector != null ? voiceConnector.build() : null;
        }

        @Override
        public final Builder voiceConnector(VoiceConnectorSettings voiceConnector) {
            this.voiceConnector = voiceConnector;
            return this;
        }

        @Override
        public GetGlobalSettingsResponse build() {
            return new GetGlobalSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
