/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSipMediaApplicationAlexaSkillConfigurationResponse extends ChimeSdkVoiceResponse
        implements
        ToCopyableBuilder<GetSipMediaApplicationAlexaSkillConfigurationResponse.Builder, GetSipMediaApplicationAlexaSkillConfigurationResponse> {
    private static final SdkField<SipMediaApplicationAlexaSkillConfiguration> SIP_MEDIA_APPLICATION_ALEXA_SKILL_CONFIGURATION_FIELD = SdkField
            .<SipMediaApplicationAlexaSkillConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("SipMediaApplicationAlexaSkillConfiguration")
            .getter(getter(GetSipMediaApplicationAlexaSkillConfigurationResponse::sipMediaApplicationAlexaSkillConfiguration))
            .setter(setter(Builder::sipMediaApplicationAlexaSkillConfiguration))
            .constructor(SipMediaApplicationAlexaSkillConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SipMediaApplicationAlexaSkillConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SIP_MEDIA_APPLICATION_ALEXA_SKILL_CONFIGURATION_FIELD));

    private final SipMediaApplicationAlexaSkillConfiguration sipMediaApplicationAlexaSkillConfiguration;

    private GetSipMediaApplicationAlexaSkillConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.sipMediaApplicationAlexaSkillConfiguration = builder.sipMediaApplicationAlexaSkillConfiguration;
    }

    /**
     * Returns the value of the SipMediaApplicationAlexaSkillConfiguration property for this object.
     * 
     * @return The value of the SipMediaApplicationAlexaSkillConfiguration property for this object.
     */
    public final SipMediaApplicationAlexaSkillConfiguration sipMediaApplicationAlexaSkillConfiguration() {
        return sipMediaApplicationAlexaSkillConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sipMediaApplicationAlexaSkillConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSipMediaApplicationAlexaSkillConfigurationResponse)) {
            return false;
        }
        GetSipMediaApplicationAlexaSkillConfigurationResponse other = (GetSipMediaApplicationAlexaSkillConfigurationResponse) obj;
        return Objects.equals(sipMediaApplicationAlexaSkillConfiguration(), other.sipMediaApplicationAlexaSkillConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSipMediaApplicationAlexaSkillConfigurationResponse")
                .add("SipMediaApplicationAlexaSkillConfiguration", sipMediaApplicationAlexaSkillConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SipMediaApplicationAlexaSkillConfiguration":
            return Optional.ofNullable(clazz.cast(sipMediaApplicationAlexaSkillConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSipMediaApplicationAlexaSkillConfigurationResponse, T> g) {
        return obj -> g.apply((GetSipMediaApplicationAlexaSkillConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkVoiceResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSipMediaApplicationAlexaSkillConfigurationResponse> {
        /**
         * Sets the value of the SipMediaApplicationAlexaSkillConfiguration property for this object.
         *
         * @param sipMediaApplicationAlexaSkillConfiguration
         *        The new value for the SipMediaApplicationAlexaSkillConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sipMediaApplicationAlexaSkillConfiguration(
                SipMediaApplicationAlexaSkillConfiguration sipMediaApplicationAlexaSkillConfiguration);

        /**
         * Sets the value of the SipMediaApplicationAlexaSkillConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link SipMediaApplicationAlexaSkillConfiguration.Builder} avoiding the need to create one manually via
         * {@link SipMediaApplicationAlexaSkillConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SipMediaApplicationAlexaSkillConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #sipMediaApplicationAlexaSkillConfiguration(SipMediaApplicationAlexaSkillConfiguration)}.
         * 
         * @param sipMediaApplicationAlexaSkillConfiguration
         *        a consumer that will call methods on {@link SipMediaApplicationAlexaSkillConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sipMediaApplicationAlexaSkillConfiguration(SipMediaApplicationAlexaSkillConfiguration)
         */
        default Builder sipMediaApplicationAlexaSkillConfiguration(
                Consumer<SipMediaApplicationAlexaSkillConfiguration.Builder> sipMediaApplicationAlexaSkillConfiguration) {
            return sipMediaApplicationAlexaSkillConfiguration(SipMediaApplicationAlexaSkillConfiguration.builder()
                    .applyMutation(sipMediaApplicationAlexaSkillConfiguration).build());
        }
    }

    static final class BuilderImpl extends ChimeSdkVoiceResponse.BuilderImpl implements Builder {
        private SipMediaApplicationAlexaSkillConfiguration sipMediaApplicationAlexaSkillConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSipMediaApplicationAlexaSkillConfigurationResponse model) {
            super(model);
            sipMediaApplicationAlexaSkillConfiguration(model.sipMediaApplicationAlexaSkillConfiguration);
        }

        public final SipMediaApplicationAlexaSkillConfiguration.Builder getSipMediaApplicationAlexaSkillConfiguration() {
            return sipMediaApplicationAlexaSkillConfiguration != null ? sipMediaApplicationAlexaSkillConfiguration.toBuilder()
                    : null;
        }

        public final void setSipMediaApplicationAlexaSkillConfiguration(
                SipMediaApplicationAlexaSkillConfiguration.BuilderImpl sipMediaApplicationAlexaSkillConfiguration) {
            this.sipMediaApplicationAlexaSkillConfiguration = sipMediaApplicationAlexaSkillConfiguration != null ? sipMediaApplicationAlexaSkillConfiguration
                    .build() : null;
        }

        @Override
        public final Builder sipMediaApplicationAlexaSkillConfiguration(
                SipMediaApplicationAlexaSkillConfiguration sipMediaApplicationAlexaSkillConfiguration) {
            this.sipMediaApplicationAlexaSkillConfiguration = sipMediaApplicationAlexaSkillConfiguration;
            return this;
        }

        @Override
        public GetSipMediaApplicationAlexaSkillConfigurationResponse build() {
            return new GetSipMediaApplicationAlexaSkillConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
