/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetVoiceConnectorProxyResponse extends ChimeSdkVoiceResponse implements
        ToCopyableBuilder<GetVoiceConnectorProxyResponse.Builder, GetVoiceConnectorProxyResponse> {
    private static final SdkField<Proxy> PROXY_FIELD = SdkField.<Proxy> builder(MarshallingType.SDK_POJO).memberName("Proxy")
            .getter(getter(GetVoiceConnectorProxyResponse::proxy)).setter(setter(Builder::proxy)).constructor(Proxy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Proxy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROXY_FIELD));

    private final Proxy proxy;

    private GetVoiceConnectorProxyResponse(BuilderImpl builder) {
        super(builder);
        this.proxy = builder.proxy;
    }

    /**
     * Returns the value of the Proxy property for this object.
     * 
     * @return The value of the Proxy property for this object.
     */
    public final Proxy proxy() {
        return proxy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(proxy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVoiceConnectorProxyResponse)) {
            return false;
        }
        GetVoiceConnectorProxyResponse other = (GetVoiceConnectorProxyResponse) obj;
        return Objects.equals(proxy(), other.proxy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetVoiceConnectorProxyResponse").add("Proxy", proxy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Proxy":
            return Optional.ofNullable(clazz.cast(proxy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetVoiceConnectorProxyResponse, T> g) {
        return obj -> g.apply((GetVoiceConnectorProxyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkVoiceResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetVoiceConnectorProxyResponse> {
        /**
         * Sets the value of the Proxy property for this object.
         *
         * @param proxy
         *        The new value for the Proxy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxy(Proxy proxy);

        /**
         * Sets the value of the Proxy property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Proxy.Builder} avoiding the need to
         * create one manually via {@link Proxy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Proxy.Builder#build()} is called immediately and its result is
         * passed to {@link #proxy(Proxy)}.
         * 
         * @param proxy
         *        a consumer that will call methods on {@link Proxy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #proxy(Proxy)
         */
        default Builder proxy(Consumer<Proxy.Builder> proxy) {
            return proxy(Proxy.builder().applyMutation(proxy).build());
        }
    }

    static final class BuilderImpl extends ChimeSdkVoiceResponse.BuilderImpl implements Builder {
        private Proxy proxy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVoiceConnectorProxyResponse model) {
            super(model);
            proxy(model.proxy);
        }

        public final Proxy.Builder getProxy() {
            return proxy != null ? proxy.toBuilder() : null;
        }

        public final void setProxy(Proxy.BuilderImpl proxy) {
            this.proxy = proxy != null ? proxy.build() : null;
        }

        @Override
        public final Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        @Override
        public GetVoiceConnectorProxyResponse build() {
            return new GetVoiceConnectorProxyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
