/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAvailableVoiceConnectorRegionsResponse extends ChimeSdkVoiceResponse implements
        ToCopyableBuilder<ListAvailableVoiceConnectorRegionsResponse.Builder, ListAvailableVoiceConnectorRegionsResponse> {
    private static final SdkField<List<String>> VOICE_CONNECTOR_REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VoiceConnectorRegions")
            .getter(getter(ListAvailableVoiceConnectorRegionsResponse::voiceConnectorRegionsAsStrings))
            .setter(setter(Builder::voiceConnectorRegionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceConnectorRegions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(VOICE_CONNECTOR_REGIONS_FIELD));

    private final List<String> voiceConnectorRegions;

    private ListAvailableVoiceConnectorRegionsResponse(BuilderImpl builder) {
        super(builder);
        this.voiceConnectorRegions = builder.voiceConnectorRegions;
    }

    /**
     * Returns the value of the VoiceConnectorRegions property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVoiceConnectorRegions} method.
     * </p>
     * 
     * @return The value of the VoiceConnectorRegions property for this object.
     */
    public final List<VoiceConnectorAwsRegion> voiceConnectorRegions() {
        return VoiceConnectorAwsRegionListCopier.copyStringToEnum(voiceConnectorRegions);
    }

    /**
     * For responses, this returns true if the service returned a value for the VoiceConnectorRegions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasVoiceConnectorRegions() {
        return voiceConnectorRegions != null && !(voiceConnectorRegions instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the VoiceConnectorRegions property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVoiceConnectorRegions} method.
     * </p>
     * 
     * @return The value of the VoiceConnectorRegions property for this object.
     */
    public final List<String> voiceConnectorRegionsAsStrings() {
        return voiceConnectorRegions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasVoiceConnectorRegions() ? voiceConnectorRegionsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAvailableVoiceConnectorRegionsResponse)) {
            return false;
        }
        ListAvailableVoiceConnectorRegionsResponse other = (ListAvailableVoiceConnectorRegionsResponse) obj;
        return hasVoiceConnectorRegions() == other.hasVoiceConnectorRegions()
                && Objects.equals(voiceConnectorRegionsAsStrings(), other.voiceConnectorRegionsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAvailableVoiceConnectorRegionsResponse")
                .add("VoiceConnectorRegions", hasVoiceConnectorRegions() ? voiceConnectorRegionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VoiceConnectorRegions":
            return Optional.ofNullable(clazz.cast(voiceConnectorRegionsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAvailableVoiceConnectorRegionsResponse, T> g) {
        return obj -> g.apply((ListAvailableVoiceConnectorRegionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkVoiceResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAvailableVoiceConnectorRegionsResponse> {
        /**
         * Sets the value of the VoiceConnectorRegions property for this object.
         *
         * @param voiceConnectorRegions
         *        The new value for the VoiceConnectorRegions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceConnectorRegionsWithStrings(Collection<String> voiceConnectorRegions);

        /**
         * Sets the value of the VoiceConnectorRegions property for this object.
         *
         * @param voiceConnectorRegions
         *        The new value for the VoiceConnectorRegions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceConnectorRegionsWithStrings(String... voiceConnectorRegions);

        /**
         * Sets the value of the VoiceConnectorRegions property for this object.
         *
         * @param voiceConnectorRegions
         *        The new value for the VoiceConnectorRegions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceConnectorRegions(Collection<VoiceConnectorAwsRegion> voiceConnectorRegions);

        /**
         * Sets the value of the VoiceConnectorRegions property for this object.
         *
         * @param voiceConnectorRegions
         *        The new value for the VoiceConnectorRegions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceConnectorRegions(VoiceConnectorAwsRegion... voiceConnectorRegions);
    }

    static final class BuilderImpl extends ChimeSdkVoiceResponse.BuilderImpl implements Builder {
        private List<String> voiceConnectorRegions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAvailableVoiceConnectorRegionsResponse model) {
            super(model);
            voiceConnectorRegionsWithStrings(model.voiceConnectorRegions);
        }

        public final Collection<String> getVoiceConnectorRegions() {
            if (voiceConnectorRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return voiceConnectorRegions;
        }

        public final void setVoiceConnectorRegions(Collection<String> voiceConnectorRegions) {
            this.voiceConnectorRegions = VoiceConnectorAwsRegionListCopier.copy(voiceConnectorRegions);
        }

        @Override
        public final Builder voiceConnectorRegionsWithStrings(Collection<String> voiceConnectorRegions) {
            this.voiceConnectorRegions = VoiceConnectorAwsRegionListCopier.copy(voiceConnectorRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder voiceConnectorRegionsWithStrings(String... voiceConnectorRegions) {
            voiceConnectorRegionsWithStrings(Arrays.asList(voiceConnectorRegions));
            return this;
        }

        @Override
        public final Builder voiceConnectorRegions(Collection<VoiceConnectorAwsRegion> voiceConnectorRegions) {
            this.voiceConnectorRegions = VoiceConnectorAwsRegionListCopier.copyEnumToString(voiceConnectorRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder voiceConnectorRegions(VoiceConnectorAwsRegion... voiceConnectorRegions) {
            voiceConnectorRegions(Arrays.asList(voiceConnectorRegions));
            return this;
        }

        @Override
        public ListAvailableVoiceConnectorRegionsResponse build() {
            return new ListAvailableVoiceConnectorRegionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
